/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.misc;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.misc.Consts;

public class StringUtil {
    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String trim(String s, String defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        if ((s = s.trim()).length() == 0) {
            return defaultValue;
        }
        return s;
    }

    public static String rtrim(String s, char c) {
        if (s == null) {
            return s;
        }
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public static String join(Collection<?> c) {
        String seperator = ", ";
        return StringUtil.join(c, seperator);
    }

    public static String join(Collection<?> c, String seperator) {
        StringBuilder sb = new StringBuilder(c.size() * 8);
        for (Object o : c) {
            if (sb.length() > 0) {
                sb.append(seperator);
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static String join(Object[] c) {
        String seperator = ", ";
        return StringUtil.join(c, seperator);
    }

    public static String join(Object[] c, String seperator) {
        if (c == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(c.length * 8);
        Object[] objectArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (sb.length() > 0) {
                sb.append(seperator);
            }
            sb.append(o);
            ++n2;
        }
        return sb.toString();
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean endsWith(CharSequence sb, char c) {
        if (sb == null || sb.length() == 0) {
            return false;
        }
        return sb.charAt(sb.length() - 1) == c;
    }

    public static int count(String text, String str) {
        if (text == null || str == null || str.length() == 0) {
            return 0;
        }
        int count = 0;
        int step = Math.min(1, str.length());
        int i = 0;
        while ((i = text.indexOf(str, i)) >= 0) {
            i += step;
            ++count;
        }
        return count;
    }

    public static String[] split(String s, char c) {
        if (s == null) {
            return Consts.EMPTY_STR_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char d = s.charAt(i);
            if (d != c) {
                sb.append(d);
            } else {
                list.add(sb.toString());
                sb = new StringBuilder();
            }
            ++i;
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public static Map<String, Object> parse(String queryString) {
        if (queryString == null) {
            return new HashMap<String, Object>();
        }
        String s = queryString.trim();
        if (s.length() == 0) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] stringArray = s.split("\\&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fragment = stringArray[n2];
            int i = fragment.indexOf(61);
            if (i > 0) {
                String text;
                String key = fragment.substring(0, i);
                if (key.indexOf(37) >= 0) {
                    key = StringUtil.decode(key);
                }
                if ((text = fragment.substring(i + 1)) != null && text.length() > 0) {
                    text = StringUtil.decode(text);
                }
                if (!map.containsKey(key)) {
                    map.put(key, text);
                } else {
                    Object original = map.get(key);
                    if (original instanceof List) {
                        ((List)original).add(text);
                    } else {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(original);
                        list.add(text);
                        map.put(key, list);
                    }
                }
            }
            ++n2;
        }
        return map;
    }

    private static String decode(String key) {
        try {
            return URLDecoder.decode(key, "UTF-8");
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    public static String toLowerCase(String s) {
        block4: {
            if (s == null) {
                return s;
            }
            int i = 0;
            int j = s.length();
            while (i < j) {
                char c = s.charAt(i);
                if (c < 'A' || c > 'Z') {
                    ++i;
                    continue;
                }
                break block4;
            }
            return s;
        }
        char[] buffer = new char[s.length()];
        int i = 0;
        int j = s.length();
        while (i < j) {
            char c = s.charAt(i);
            buffer[i] = c >= 'A' && c <= 'Z' ? (char)(c + 32) : c;
            ++i;
        }
        return new String(buffer);
    }

    public static String toUpperCase(String s) {
        block4: {
            if (s == null) {
                return s;
            }
            int i = 0;
            int j = s.length();
            while (i < j) {
                char c = s.charAt(i);
                if (c < 'a' || c > 'z') {
                    ++i;
                    continue;
                }
                break block4;
            }
            return s;
        }
        char[] buffer = new char[s.length()];
        int i = 0;
        int j = s.length();
        while (i < j) {
            char c = s.charAt(i);
            buffer[i] = c >= 'a' && c <= 'z' ? (char)(c + -32) : c;
            ++i;
        }
        return new String(buffer);
    }

    public static String toString(Object key) {
        if (key == null) {
            return "null";
        }
        return key.toString();
    }

    public static boolean allAreAsciiChars(String str) {
        if (str != null) {
            int i = 0;
            while (i < str.length()) {
                char ch = str.charAt(i);
                if (ch >= '\u0080') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        throw new IllegalArgumentException("string cannot be null.");
    }
}

