/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.message;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.service.job.util.Config;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.jms.TextMessage;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityHeaderDef;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ExecutionMode;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.enhanced.EMessage;
import com.kingdee.bos.workflow.define.enhanced.IEMessageActivity;
import com.kingdee.bos.workflow.define.enhanced.IMessageActivity;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.ParticipantHelper;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfExecutionObject;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.message.ISmsReceiverFilter;
import com.kingdee.bos.workflow.enactment.message.WfMessage;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.bos.workflow.util.WfBizObjUtils;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class WfMessageUtil {
    private static Logger logger;
    public static final String Valid_PREFIX = "Valid_";
    public static final String EMAIL_PREFIX = "Email_";
    public static final String MOBILE_PREFIX = "Mobile_";
    public static MessageListener messageListener;
    private static String msgDateFormat;
    private static ISmsReceiverFilter smsFilter;

    static {
        String tmp;
        logger = Logger.getLogger(WfMessageUtil.class);
        messageListener = null;
        msgDateFormat = "yyyy-MM-dd HH:mm:ss";
        ConfigurationItem workfowConfig = Configuration.getInstance().getConfigItem("Workflow");
        if (workfowConfig != null && (tmp = workfowConfig.getProperty("MsgDateFormat")) != null && tmp.length() > 0) {
            msgDateFormat = tmp;
        }
        smsFilter = null;
        String s = Config.getString((String)"Workflow", (String)"SmsReceiverFilter");
        if (s != null) {
            try {
                Class<?> cls = Class.forName(s);
                smsFilter = (ISmsReceiverFilter)cls.newInstance();
            }
            catch (Throwable t) {
                logger.warn((Object)"init SmsReceiverFilter failed;", t);
            }
        }
    }

    public static String createValidProcessVarKey(String activityDefId) {
        return Valid_PREFIX + activityDefId;
    }

    public static String createEmailProcessVarKey(String activityDefId) {
        return EMAIL_PREFIX + activityDefId;
    }

    public static String createMobileProcessVarKey(String activityDefId) {
        return MOBILE_PREFIX + activityDefId;
    }

    public static String parseMessage(String message, WfActivity activity, Locale locale) throws WfException {
        if (message == null) {
            return "";
        }
        ContextUtils.setLocaleToThread((Locale)locale);
        try {
            String string = WfMessageUtil.innerGet(message, activity, locale);
            return string;
        }
        finally {
            ContextUtils.setLocaleToThread((Locale)LocaleUtils.locale_l2);
        }
    }

    public static String parseMessageForDeadlineJob(String message, WfActivity activity, Locale locale, WfAssignment wfassignment) throws WfException {
        if (message == null) {
            return "";
        }
        ContextUtils.setLocaleToThread((Locale)locale);
        try {
            message = WfMessageUtil.innerGet(message, activity, locale);
            String string = message = WfMessageUtil.parseEmailApproveMsg(activity.container().getProcessContext(), wfassignment.getAssignmentInfo(), message);
            return string;
        }
        finally {
            ContextUtils.setLocaleToThread((Locale)LocaleUtils.locale_l2);
        }
    }

    private static String innerGet(String message, WfActivity activity, Locale locale) throws WfException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"parseMessage begin:");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(msgDateFormat);
        if (message.indexOf("@@") >= 0) {
            DataFieldCollection dc = activity.container().getDefinition().getDataFields();
            ProcessContext context = activity.container().getProcessContext();
            String[] dataFieldNames = context.getDataFieldNames();
            ArrayList<String> dataFieldNameList = new ArrayList<String>();
            int i = 0;
            while (i < dataFieldNames.length) {
                String name = dataFieldNames[i];
                if (name != null && name.trim().length() != 0) {
                    dataFieldNameList.add(dataFieldNames[i]);
                }
                ++i;
            }
            Collections.sort(dataFieldNameList, (Comparator)new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (!(o1 instanceof String)) {
                        return -1;
                    }
                    if (!(o2 instanceof String)) {
                        return 1;
                    }
                    String str1 = (String)o1;
                    String str2 = (String)o2;
                    return str2.length() - str1.length();
                }
            });
            dataFieldNames = dataFieldNameList.toArray(new String[0]);
            i = 0;
            while (i < dataFieldNames.length) {
                DataFieldDef dfd = dc.getByName(dataFieldNames[i]);
                if (dfd == null || !dfd.getDataType().equals(BasicType.BIZOBJ) && !dfd.getDataType().equals(BasicType.APPROVERESULT)) {
                    Object dataFieldVal = context.getDataFieldValue(dataFieldNames[i]);
                    if (dataFieldVal instanceof Date) {
                        String s = sdf.format((Date)dataFieldVal);
                        if (s.endsWith("00:00:00")) {
                            s = s.substring(0, 10);
                        }
                        dataFieldVal = s;
                    }
                    String dataFieldName = dataFieldVal != null ? dataFieldVal.toString() : "";
                    message = StringUtils.replace((String)message, (String)("@@" + dataFieldNames[i]), (String)StringUtils.cnulls((String)dataFieldName));
                }
                ++i;
            }
            Context ctx = context.getWfEngine().getClonedContext();
            ctx.setLocale(locale);
            message = WfBizObjUtils.replaceBizObjValue((ProcessContext)context, (ProcessDef)activity.container().getDefinition(), (DataFieldCollection)dc, (String)message, (Context)ctx);
        }
        if (message.indexOf("<%") != -1) {
            HashMap<String, Object> replaceMap = new HashMap<String, Object>();
            String[] mStr = message.split("<%");
            int i = 0;
            while (i < mStr.length) {
                Object obj;
                String temp = mStr[i];
                if (temp.indexOf("%>") != -1 && !StringUtils.isEmpty((String)(temp = temp.substring(0, temp.lastIndexOf("%>")))) && (obj = ScriptUtil.evelScript((String)temp, (ProcessInstInfo)activity.getWfEngine().getProcessInst(activity.getMeta().getProcInstId()).getData(), (Locale)locale, (WfEngine)activity.getWfEngine())) != null) {
                    if (obj instanceof Date) {
                        String s = sdf.format((Date)obj);
                        if (s.endsWith("00:00:00")) {
                            s = s.substring(0, 10);
                        }
                        obj = s;
                    }
                    replaceMap.put(temp, obj);
                }
                ++i;
            }
            for (Map.Entry entry : replaceMap.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                message = StringUtils.replace((String)message, (String)("<%" + key + "%>"), (String)value.toString());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)message);
            logger.debug((Object)"parseMessage end");
        }
        return message;
    }

    public static String getDistinctRecievers(List persons) {
        if (persons == null || persons.isEmpty()) {
            return null;
        }
        StringBuffer receivers = new StringBuffer();
        HashSet<String> tempSet = new HashSet<String>();
        boolean flag = false;
        for (Person person : persons) {
            if (tempSet.contains(person.getUserId())) continue;
            tempSet.add(person.getUserId());
            if (flag) {
                receivers.append(';');
            }
            receivers.append(person.getUserId());
            flag = true;
        }
        return receivers.toString();
    }

    public static void sendAssignCreationEvent(WfActivity activity, AssignmentInfo assignment) throws WfException {
        ActivityDef actDef = activity.getDefinition();
        if (!(actDef instanceof ManpowerActivityDef)) {
            return;
        }
        String tag = (String)activity.container().getProcessContext().getDataFieldValue("$ProcessTag$");
        Locale[] locales = ApplicationUtil.getContextLocales((Context)activity.getWfEngine().context());
        if (actDef instanceof IMessageActivity) {
            AssignmentMessage msg = ((IMessageActivity)actDef).getMessage();
            AssignmentCreationEvent event = new AssignmentCreationEvent();
            event.titles = new HashMap();
            event.bodies = new HashMap();
            WfMessageUtil.fillAssignmentCreationEvent(activity, assignment, event);
            int i = 0;
            while (i < locales.length) {
                Locale locale = locales[i];
                event.titles.put(locale, WfMessageUtil.parseMessage(msg.getTitle(locale), activity, locale));
                event.bodies.put(locale, WfMessageUtil.parseMessage(msg.getBody(locale), activity, locale));
                ++i;
            }
            event.isSendCommon = true;
            event.isSendEmail = false;
            event.isSendMobile = false;
            event.tags = tag;
            event.isSupportProcessAssist = assignment.getAssignInfo().isIsSupportMobile();
            WfTxContext.current().getTxAssignmentMgr().addAssignmentCreationEvent(event);
            Locale l2 = new Locale("L2");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5de5\u4f5c\u6d41\u53d1\u9001\u6d88\u606f --[\u4efb\u52a1\u666e\u901a\u4e8b\u4ef6]\u4e3b\u9898:" + event.titles.get(l2) + "; \u5185\u5bb9:" + event.bodies.get(l2)));
            }
        }
    }

    private static boolean isPreActivitySkiped(List preApproveList, WfEngine wfEngine) throws WfException {
        boolean flag = false;
        if (preApproveList == null || preApproveList.isEmpty()) {
            return flag;
        }
        int i = 0;
        while (i < preApproveList.size()) {
            String actInstId = (String)preApproveList.get(i);
            boolean temp = wfEngine.getActivityInst(actInstId).isSkiped();
            if (temp) {
                flag = true;
                break;
            }
            ++i;
        }
        return flag;
    }

    private static boolean isValid(ProcessContext context, WfActivity activity) {
        String valid;
        boolean flag = false;
        String key = Valid_PREFIX + activity.getDefinition().getID();
        String string = valid = context.getDataFieldValue(key) != null ? (String)context.getDataFieldValue(key) : null;
        if (!StringUtils.isEmpty((String)valid) && "true".equals(valid)) {
            flag = true;
            context.setDataFieldValue(key, (Object)"");
        }
        return flag;
    }

    private static boolean isSendMailWhenSubmit(ProcessContext context, WfActivity activity) {
        String sendEmail;
        boolean flag = false;
        String key = EMAIL_PREFIX + activity.getDefinition().getID();
        String string = sendEmail = context.getDataFieldValue(key) != null ? (String)context.getDataFieldValue(key) : null;
        if (!StringUtils.isEmpty((String)sendEmail) && "true".equals(sendEmail)) {
            flag = true;
            context.setDataFieldValue(key, (Object)"");
        }
        return flag;
    }

    private static boolean isSendMobileWhenSubmit(ProcessContext context, WfActivity activity) {
        String sendMobile;
        boolean flag = false;
        String key = MOBILE_PREFIX + activity.getDefinition().getID();
        String string = sendMobile = context.getDataFieldValue(key) != null ? (String)context.getDataFieldValue(key) : null;
        if (!StringUtils.isEmpty((String)sendMobile) && "true".equals(sendMobile)) {
            flag = true;
            context.setDataFieldValue(key, (Object)"");
        }
        return flag;
    }

    public static void sendAssignMessage(WfActivity activity, AssignmentInfo assignment, String receivers) {
        throw new UnsupportedOperationException("\u8bf7\u6539\u4e3a\u8c03\u7528\u65b9\u6cd5\uff1asendAssignMessage(WfActivity activity, Collection assignments)");
    }

    public static void sendAssignMessage(WfActivity activity, Collection assignments) throws WfException {
        if (assignments.size() == 0) {
            return;
        }
        Context ctx = activity.getContext();
        ActivityDef actDef = activity.getDefinition();
        WfEngine wfEngine = activity.getWfEngine();
        ProcessContext context = activity.container().getProcessContext();
        boolean isValid = WfMessageUtil.isValid(context, activity);
        if (actDef instanceof ManpowerActivityDef) {
            EMessage emsg;
            boolean isSendSMS;
            ApproveActivityDef approve;
            ExtendedAttributeDef mailApprovePage;
            boolean isSendMail;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"************\u5de5\u4f5c\u6d41\u5ba1\u6279\u6d88\u606f***********begin");
            }
            ManpowerActivityDef manpowerActDef = (ManpowerActivityDef)actDef;
            List preApproveList = WfMessageUtil.getPreApproveList(wfEngine, activity.getId());
            Locale[] locales = ApplicationUtil.getContextLocales((Context)wfEngine.context());
            AssignmentMessage msg = manpowerActDef.getMessage();
            String parent = activity.getMeta().getActInstInfo().getParentActInstId();
            boolean isSkiped = true;
            if (parent == null) {
                isSkiped = WfMessageUtil.isPreActivitySkiped(preApproveList, wfEngine);
            }
            if (isSendMail = WfMessageUtil.isSendMail(activity, wfEngine, context, isValid, preApproveList, false, msg, isSkiped)) {
                WfMessageUtil.sendMail(activity, assignments, locales, msg);
            }
            if (actDef instanceof ApproveActivityDef && (mailApprovePage = (approve = (ApproveActivityDef)activity.getDefinition()).getActivityHeader().getExtendedAttributes().get("mailApprovePage")) != null && !StringUtils.isEmpty((String)mailApprovePage.getValue())) {
                WfMessageUtil.sendNewMailApprove(activity, assignments, mailApprovePage.getValue());
            }
            if (isSendSMS = WfMessageUtil.isSendSMS(activity, wfEngine, context, isValid, preApproveList, isSkiped, emsg = manpowerActDef.getEMessage())) {
                WfMessageUtil.sendSMS(activity, assignments, ctx, locales, emsg, msg);
            }
        } else {
            EMessage emsg;
            AssignmentMessage msg;
            if (actDef instanceof IMessageActivity && (msg = ((IMessageActivity)actDef).getMessage()) != null && msg.isSendMail()) {
                WfMessageUtil.otherSendMail(activity, assignments, msg);
            }
            if (actDef instanceof IEMessageActivity && (emsg = ((IEMessageActivity)actDef).getEMessage()) != null && emsg.isEnable()) {
                WfMessageUtil.otherSendSMS(activity, assignments, ctx, emsg);
            }
        }
    }

    private static void otherSendSMS(WfActivity activity, Collection assignments, Context ctx, EMessage emsg) throws WfException {
        for (AssignmentInfo assignment : assignments) {
            if (WfMessageUtil.filterSmsReceivers(ctx, assignment.getUserId()) == null) continue;
            WfMessage message = new WfMessage();
            message.setActivity(activity);
            message.setContent(activity, emsg);
            message.setContentType(4);
            WfMessageUtil.setOrgVariable(message, activity, assignment);
            message.setSourceId(assignment.getAssignmentId());
            message.send(assignment.getUserId());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("\u5de5\u4f5c\u6d41\u53d1\u9001\u6d88\u606f --[\u4efb\u52a1\u77ed\u4fe1\u6d88\u606f]\u4e3b\u9898:" + message.getSubject() + "; \u5185\u5bb9:" + message.getContent()));
        }
    }

    private static void otherSendMail(WfActivity activity, Collection assignments, AssignmentMessage msg) throws WfException {
        for (AssignmentInfo assignment : assignments) {
            WfMessage message = new WfMessage();
            message.setActivity(activity);
            message.setContent(activity, msg, true);
            message.setContentType(2);
            WfMessageUtil.setOrgVariable(message, activity, assignment);
            message.setSourceId(assignment.getAssignmentId());
            message.send(assignment.getUserId());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("\u5de5\u4f5c\u6d41\u53d1\u9001\u6d88\u606f --[\u4efb\u52a1\u90ae\u4ef6\u6d88\u606f] \u4e3b\u9898:" + message.getSubject() + "; \u5185\u5bb9:" + message.getContent()));
        }
    }

    private static void sendSMS(WfActivity activity, Collection assignments, Context ctx, Locale[] locales, EMessage emsg, AssignmentMessage msg) throws WfException {
        for (AssignmentInfo assignment : assignments) {
            if (WfMessageUtil.filterSmsReceivers(ctx, assignment.getUserId()) == null) continue;
            AssignmentCreationEvent event = new AssignmentCreationEvent();
            event.titles = new HashMap();
            event.bodies = new HashMap();
            int i = 0;
            while (i < locales.length) {
                Locale locale = locales[i];
                String msgStr = emsg.getContent(locale);
                if (StringUtils.isEmpty((String)msgStr)) {
                    msgStr = msg.getTitle(locale);
                }
                event.bodies.put(locale, WfMessageUtil.parseMessage(msgStr, activity, locale));
                ++i;
            }
            WfMessageUtil.fillAssignmentCreationEvent(activity, assignment, event);
            event.isSendCommon = false;
            event.isSendMobile = true;
            event.isSendEmail = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("************\u5de5\u4f5c\u6d41\u5ba1\u6279\u6d88\u606f***********\u77ed\u4fe1\u63a5\u6536\u4eba(\u8fc7\u6ee4\u524d):" + assignment.getUserId()));
            }
            event.receiver = assignment.getUserId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("************\u5de5\u4f5c\u6d41\u5ba1\u6279\u6d88\u606f***********\u77ed\u4fe1\u63a5\u6536\u4eba(\u8fc7\u6ee4\u540e):" + event.receiver));
            }
            WfTxContext.current().getTxAssignmentMgr().addAssignmentCreationEvent(event);
            Locale l2 = new Locale("L2");
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("\u5de5\u4f5c\u6d41\u53d1\u9001\u6d88\u606f --[\u4efb\u52a1\u77ed\u4fe1\u4e8b\u4ef6] \u4e3b\u9898:" + event.titles.get(l2) + "; \u5185\u5bb9" + event.bodies.get(l2)));
        }
    }

    private static boolean isSendSMS(WfActivity activity, WfEngine wfEngine, ProcessContext context, boolean isValid, List preApproveList, boolean isSkiped, EMessage emsg) throws WfException {
        boolean isOpenMessageSendOnUI = false;
        try {
            String str = ParamManager.getParamValue((Context)wfEngine.context(), null, (String)"isOpenMessageSendOnUI");
            if (!StringUtils.isEmpty((String)str) && "true".equals(str)) {
                isOpenMessageSendOnUI = true;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        boolean isSendSMS = false;
        if (isValid) {
            isSendSMS = WfMessageUtil.isSendMobileWhenSubmit(context, activity);
        } else if (isSkiped || preApproveList == null || preApproveList.isEmpty() || !isOpenMessageSendOnUI) {
            isSendSMS = emsg != null && emsg.isEnable();
        } else {
            try {
                isSendSMS = WfMessageUtil.invokeSendMethod(preApproveList, wfEngine, "isMobelNotifyNext");
            }
            catch (Exception ex) {
                throw new WfException((Throwable)ex, true);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("************\u5de5\u4f5c\u6d41\u5ba1\u6279\u6d88\u606f***********\u53d1\u9001\u77ed\u4fe1:" + isSendSMS));
        }
        if (!isSendSMS && activity.getMeta().getParentActInstId() != null) {
            FlowContext runtime = activity.container().getProcessContext().getFlowContext();
            Execution e = runtime.getExecution(activity.getId());
            isSendSMS = "true".equals(e.getProperty("sendSMS"));
        }
        return isSendSMS;
    }

    private static String parseEmailApproveMsg(ProcessContext context, AssignmentInfo assignment, String raw) {
        int i;
        if (!raw.contains("{#") || !raw.contains("#}")) {
            return raw;
        }
        String prefix = (String)context.getDataFieldValue("EMAIL_APPROVE_URL_PREFIX");
        if (StringUtils.isEmpty((String)prefix)) {
            return raw;
        }
        String transToApprove = "/easweb/webviews/workflow/transferApprove.jsp?AssignmentId=" + assignment.getAssignmentId();
        String url = String.valueOf(prefix) + transToApprove;
        int j = 0;
        StringBuilder sb = new StringBuilder();
        while ((i = raw.indexOf("{#")) >= 0 && (j = raw.indexOf("#}")) > 0) {
            sb.append(raw.substring(0, i));
            sb.append("<a href='");
            sb.append(url);
            sb.append("'>" + url);
            sb.append("</a>");
            raw = raw.substring(j + 2, raw.length());
        }
        sb.append(raw);
        return sb.toString();
    }

    private static void sendMail(WfActivity activity, Collection assignments, Locale[] locales, AssignmentMessage msg) throws WfException {
        for (AssignmentInfo assignment : assignments) {
            AssignmentCreationEvent event = new AssignmentCreationEvent();
            event.titles = new HashMap();
            event.bodies = new HashMap();
            boolean isMailSameAsMessage = msg.isMailSameAsMessage();
            int i = 0;
            while (i < locales.length) {
                Locale locale = locales[i];
                String title = "";
                String body = "";
                if (isMailSameAsMessage) {
                    title = msg.getTitle(locale);
                    body = msg.getBody(locale);
                } else {
                    title = msg.getMailTitle(locale);
                    body = msg.getMailBody(locale);
                }
                event.titles.put(locale, WfMessageUtil.parseMessage(title, activity, locale));
                String bodyMsg = WfMessageUtil.parseMessage(body, activity, locale);
                bodyMsg = WfMessageUtil.parseEmailApproveMsg(activity.container().getProcessContext(), assignment, bodyMsg);
                event.bodies.put(locale, bodyMsg);
                ++i;
            }
            WfMessageUtil.fillAssignmentCreationEvent(activity, assignment, event);
            event.isSendCommon = false;
            event.isSendMobile = false;
            event.isSendEmail = true;
            event.receiver = assignment.getUserId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("************\u5de5\u4f5c\u6d41\u5ba1\u6279\u6d88\u606f***********\u90ae\u4ef6\u63a5\u6536\u4eba:" + assignment.getUserId()));
            }
            WfTxContext.current().getTxAssignmentMgr().addAssignmentCreationEvent(event);
            Locale l2 = new Locale("L2");
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("\u5de5\u4f5c\u6d41\u53d1\u9001\u6d88\u606f --[\u4efb\u52a1\u90ae\u4ef6\u4e8b\u4ef6]\u4e3b\u9898:" + event.titles.get(l2) + "; \u5185\u5bb9:" + event.bodies.get(l2)));
        }
    }

    private static void sendNewMailApprove(WfActivity activity, Collection assignments, String pageId) throws WfException {
        Iterator it = assignments.iterator();
        if (pageId.contains("ids")) {
            pageId = (String)((Map)JSON.parseObject((String)pageId, Map.class)).get("ids");
        }
        while (it.hasNext()) {
            AssignmentInfo assignment = (AssignmentInfo)it.next();
            AssignmentCreationEvent event = new AssignmentCreationEvent();
            WfMessageUtil.fillAssignmentCreationEvent(activity, assignment, event);
            event.isSendCommon = false;
            event.isSendMobile = false;
            event.isSendEmail = false;
            event.isMailApprove = true;
            event.receiver = assignment.getUserId();
            event.mailApprovePageId = pageId;
            WfTxContext.current().getTxAssignmentMgr().addAssignmentCreationEvent(event);
        }
    }

    private static boolean isSendMail(WfActivity activity, WfEngine wfEngine, ProcessContext context, boolean isValid, List preApproveList, boolean isSendMail, AssignmentMessage msg, boolean isSkiped) throws WfException {
        boolean isOpenMessageSendOnUI = false;
        try {
            String str = ParamManager.getParamValue((Context)wfEngine.context(), null, (String)"isOpenMessageSendOnUI");
            if (!StringUtils.isEmpty((String)str) && "true".equals(str)) {
                isOpenMessageSendOnUI = true;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (isValid) {
            isSendMail = WfMessageUtil.isSendMailWhenSubmit(context, activity);
        } else if (isSkiped || preApproveList == null || preApproveList.isEmpty() || !isOpenMessageSendOnUI) {
            isSendMail = msg != null && msg.isSendMail();
        } else {
            try {
                isSendMail = WfMessageUtil.invokeSendMethod(preApproveList, wfEngine, "isMailNotifyNext");
            }
            catch (Exception ex) {
                throw new WfException((Throwable)ex, true);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("************\u5de5\u4f5c\u6d41\u5ba1\u6279\u6d88\u606f***********\u53d1\u9001\u90ae\u4ef6:" + isSendMail));
        }
        if (!isSendMail && activity.getMeta().getParentActInstId() != null) {
            FlowContext runtime = activity.container().getProcessContext().getFlowContext();
            Execution e = runtime.getExecution(activity.getId());
            isSendMail = "true".equals(e.getProperty("sendMail"));
        }
        return isSendMail;
    }

    public static void sendNotifyMessage(WfActivity activity) throws WfException {
        IEMessageActivity emsgAct;
        EMessage emsg;
        WfMessage message;
        IMessageActivity msgAct;
        AssignmentMessage amsg;
        ActivityDef def = activity.getDefinition();
        List persons = ParticipantHelper.getPersonsByParticipants((WfExecutionObject)activity, (ActivityDef)activity.getDefinition(), (String)activity.getProcInstId());
        String recievers = WfMessageUtil.getDistinctRecievers(persons);
        if (recievers == null || recievers.trim().length() == 0) {
            return;
        }
        if (def instanceof IMessageActivity && (amsg = (msgAct = (IMessageActivity)def).getMessage()) != null) {
            message = new WfMessage();
            message.setActivity(activity);
            message.setContent(activity, amsg);
            message.setContentType(1);
            String sourceKey = amsg.getSourceKey();
            if (!StringUtils.isEmpty((String)sourceKey)) {
                Object billId = activity.container().getProcessContext().getDataFieldValue(sourceKey);
                if (billId != null) {
                    message.setSourceId(billId.toString());
                }
            } else {
                message.setSourceId(activity.getMeta().getActInstId());
            }
            message.send(WfMessageUtil.getRecievers(persons));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5de5\u4f5c\u6d41\u53d1\u9001\u6d88\u606f --[\u666e\u901a\u901a\u77e5\u6d88\u606f]\u4e3b\u9898:" + message.getSubject() + "; \u5185\u5bb9:" + message.getContent()));
            }
            if (amsg.isSendMail()) {
                message = new WfMessage();
                message.setActivity(activity);
                message.setContent(activity, amsg, true);
                message.setContentType(2);
                message.send(recievers);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u5de5\u4f5c\u6d41\u53d1\u9001\u6d88\u606f --[\u90ae\u4ef6\u901a\u77e5\u6d88\u606f]\u4e3b\u9898:" + message.getSubject() + "; \u5185\u5bb9:" + message.getContent()));
                }
            }
            logger.error((Object)"push notify message start");
            Context ctx = activity.getContext();
            TextMessage msg = new TextMessage();
            msg.setStringHeader("databaseCenter", ctx.getAIS());
            msg.setStringHeader("solution", ctx.getSolution());
            msg.setStringHeader("receiver", recievers);
            msg.setIntHeader("ContentType", 1);
            int i = 1;
            while (i < 4) {
                String localString = "L" + i;
                Locale locale = new Locale(localString);
                String initiatorName = activity.container().getProcessMeta().getInitiatorName(locale);
                String title = "";
                String body = "";
                title = amsg.getTitle(locale);
                body = amsg.getBody(locale);
                msg.setLocaleStringHeader("predetails", initiatorName, locale);
                msg.setLocaleStringHeader("title", WfMessageUtil.parseMessage(title, activity, locale), locale);
                msg.setLocaleStringHeader("body", WfMessageUtil.parseMessage(body, activity, locale), locale);
                ++i;
            }
            if (messageListener == null) {
                ConfigurationItem config = Configuration.getInstance().getConfigItemByPath("MessageService/listeners");
                if (config == null) {
                    logger.error((Object)"MessageService Listeners Configuration error!");
                    return;
                }
                List listenerConfigs = config.getAllChildren();
                int i2 = 0;
                while (i2 < listenerConfigs.size()) {
                    ConfigurationItem item = (ConfigurationItem)listenerConfigs.get(i2);
                    if ("WFNoticeListener".equals(item.getProperty("name"))) {
                        try {
                            Class<?> listenerClass = Class.forName(item.getProperty("class"));
                            messageListener = (MessageListener)listenerClass.newInstance();
                        }
                        catch (IllegalAccessException ex) {
                            logger.error((Object)"cannot laod listener class!", (Throwable)ex);
                        }
                        catch (InstantiationException ex) {
                            logger.error((Object)"cannot laod listener class!", (Throwable)ex);
                        }
                        catch (ClassNotFoundException ex) {
                            logger.error((Object)"cannot laod listener class!", (Throwable)ex);
                        }
                        catch (Throwable ex) {
                            logger.error((Object)"cannot laod listener class!", ex);
                        }
                        break;
                    }
                    ++i2;
                }
            }
            if (messageListener != null) {
                logger.error((Object)"user pushutil push message");
            }
            logger.error((Object)"notify WFMessage is send XT success !");
        }
        if (def instanceof IEMessageActivity && (emsg = (emsgAct = (IEMessageActivity)def).getEMessage()) != null && emsg.isEnable()) {
            message = new WfMessage();
            message.setContentType(4);
            message.setActivity(activity);
            message.setContent(activity, emsg);
            message.send(recievers);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5de5\u4f5c\u6d41\u53d1\u9001\u6d88\u606f --[\u77ed\u4fe1\u901a\u77e5\u6d88\u606f], \u6d88\u606f\u4e3b\u9898:" + message.getSubject() + "; \u6d88\u606f\u5185\u5bb9:" + message.getContent()));
            }
        }
    }

    public static void sendCCMessage(WfActivity activity, String sourceId, String senderId, String receivers) throws WfException {
        ActivityDef actDef = activity.getDefinition();
        if (!(actDef instanceof ManpowerActivityDef)) {
            return;
        }
        if (actDef instanceof IMessageActivity) {
            Context ctx = activity.getWfEngine().context();
            Locale[] locales = ApplicationUtil.getContextLocales((Context)ctx);
            WfMessage wfMessage = new WfMessage();
            wfMessage.setActivity(activity);
            Message message = wfMessage.getMessage();
            message.setStringHeader("senderId", senderId);
            Map subjects = WfMessageUtil.getMessageTitles(activity, locales);
            Map bodies = WfMessageUtil.getMessageContents(activity, locales);
            int i = 0;
            while (i < locales.length) {
                Locale locale = locales[i];
                message.setLocaleStringHeader("title", (String)subjects.get(locale), locale);
                message.setLocaleStringHeader("body", (String)bodies.get(locale), locale);
                ++i;
            }
            wfMessage.setContentType(1);
            wfMessage.setBizType(80);
            wfMessage.setSourceId(sourceId);
            wfMessage.send(receivers);
            logger.info((Object)("sendCCMessage successfully,actInstId:" + activity.getId()));
        }
    }

    public static String getRecievers(List persons) {
        StringBuffer rs = new StringBuffer();
        boolean flag = false;
        int i = 0;
        while (i < persons.size()) {
            Person p = (Person)persons.get(i);
            if (flag) {
                rs.append(';');
            }
            rs.append(p.getUserId());
            flag = true;
            ++i;
        }
        return rs.toString();
    }

    public static String getMessageTitle(WfActivity activity, Locale locale) throws WfException {
        IMessageActivity mAct;
        AssignmentMessage messageDef;
        ActivityDef actDef = activity.getDefinition();
        if (actDef instanceof IMessageActivity && (messageDef = (mAct = (IMessageActivity)actDef).getMessage()) != null) {
            String subjectFormatString = messageDef.getTitle(locale);
            subjectFormatString = WfMessageUtil.getMessageTitle4Appended(activity, subjectFormatString);
            return WfMessageUtil.parseMessage(subjectFormatString, activity, locale);
        }
        return actDef.getName(locale);
    }

    private static String getMessageTitle4Appended(WfActivity activity, String subjectFormatString) throws WfException {
        String tmp;
        Execution e;
        ProcessContext ctx = activity.container().getProcessContext();
        if (ctx.isPvmMode() && (e = ctx.getFlowContext().getExecution(activity.getId())) != null && Util.isAppended((Execution)e) && (tmp = Util.getMessageTitle((Execution)e)) != null) {
            subjectFormatString = tmp;
        }
        return subjectFormatString;
    }

    public static Map getMessageTitles(WfActivity activity, Locale[] locales) throws WfException {
        Hashtable<Locale, String> titles = null;
        if (locales != null) {
            titles = new Hashtable<Locale, String>();
            int i = 0;
            while (i < locales.length) {
                String msgTitle = WfMessageUtil.getMessageTitle(activity, locales[i]);
                if (msgTitle == null) {
                    msgTitle = "";
                }
                if (msgTitle.length() > 1000) {
                    msgTitle = msgTitle.substring(0, 999);
                }
                titles.put(locales[i], msgTitle);
                ++i;
            }
        }
        return titles;
    }

    public static String getMessageContent(WfActivity activity, Locale locale) throws WfException {
        IMessageActivity mAct;
        AssignmentMessage messageDef;
        ActivityDef actDef = activity.getDefinition();
        if (actDef instanceof IMessageActivity && (messageDef = (mAct = (IMessageActivity)actDef).getMessage()) != null) {
            String bodyFormatString = messageDef.getBody(locale);
            return WfMessageUtil.parseMessage(bodyFormatString, activity, locale);
        }
        return actDef.getName(locale);
    }

    public static Map getMessageContents(WfActivity activity, Locale[] locales) throws WfException {
        Hashtable<Locale, String> contents = null;
        if (locales != null) {
            contents = new Hashtable<Locale, String>();
            int i = 0;
            while (i < locales.length) {
                String content = WfMessageUtil.getMessageContent(activity, locales[i]);
                contents.put(locales[i], content == null ? "" : content);
                ++i;
            }
        }
        return contents;
    }

    private static void setOrgVariable(WfMessage message, WfActivity activity, AssignmentInfo assignment) throws WfException {
        ActivityDef actDef = activity.getDefinition();
        WfProcess process = activity.container();
        if (!WfMessageUtil.isOrgIsolationMessage(actDef)) {
            message.setOrgId(process.getOrgIdByHoldedBizObjId(assignment.getBizObjectIds()));
        } else if (WfMessageUtil.getAssignOrgIdVariableName(actDef) != null) {
            message.setOrgId(process.getOrgIdByVariable(WfMessageUtil.getAssignOrgIdVariableName(actDef)));
            if (WfMessageUtil.getAssignOrgTypeVariableName(actDef) != null) {
                message.setOrgType(process.getOrgTypeByVariable(WfMessageUtil.getAssignOrgTypeVariableName(actDef)).toString());
            }
        }
    }

    private static boolean invokeSendMethod(List preApproveIdList, WfEngine wfEngine, String methodName) throws Exception {
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)wfEngine.context(), (BOSObjectType)BOSObjectType.create((String)"63D30103"));
        Class[] paramTypes = new Class[]{String.class};
        Object[] args = new Object[1];
        Method method = obj.getClass().getMethod(methodName, paramTypes);
        if (method == null) {
            throw new WfException("fatal error: can't find method, method name is " + methodName);
        }
        for (String actInstId : preApproveIdList) {
            AssignmentInfo[] assigns = wfEngine.getAssignmentByActInstId(actInstId);
            int a = 0;
            while (a < assigns.length) {
                AssignmentInfo temp = assigns[a];
                if (WfAssignmentState.PROCESSING.equals((Object)temp.getState())) {
                    temp = wfEngine.getAssignment(temp.getAssignmentId()).getAssignmentInfo();
                }
                if (WfAssignmentState.COMPLETED.equals((Object)temp.getState())) {
                    args[0] = temp.getAssignmentId();
                    boolean isSend = (Boolean)method.invoke((Object)obj, args);
                    if (isSend) {
                        return true;
                    }
                }
                ++a;
            }
        }
        return false;
    }

    private static List getPreApproveList(WfEngine wfEngine, String actInstId) throws WfException {
        ArrayList<String> list = new ArrayList<String>();
        LinkedList stack = new LinkedList();
        HashSet checkedSet = new HashSet();
        try {
            WfMessageUtil.addPreActInstToStack(wfEngine, stack, checkedSet, actInstId);
            while (!stack.isEmpty()) {
                String preInstId = (String)stack.remove(0);
                WfActivity preActInst = wfEngine.getActivityInst(preInstId);
                ActivityDef actDef = preActInst.getDefinition();
                if (actDef instanceof ApproveActivityDef) {
                    list.add(preInstId);
                    continue;
                }
                if (actDef instanceof SubflowActivityDef && ((SubflowActivityDef)actDef).getExecution() == ExecutionMode.SYNCHR) {
                    ActivityInstInfo preActInstInfo = preActInst.getMeta();
                    String subProcInstId = preActInstInfo.getSubProcInstId();
                    if (StringUtils.isEmpty((String)subProcInstId)) continue;
                    String endActivityId = WfMessageUtil.getEndActivityId(wfEngine, subProcInstId);
                    WfMessageUtil.addPreActInstToStack(wfEngine, stack, checkedSet, endActivityId);
                    continue;
                }
                if (actDef instanceof ManpowerActivityDef) continue;
                if (actDef instanceof StartActivityDef) {
                    String parentActInstId = preActInst.getProcess().getInstanceInfo().getParentActInstId();
                    if (parentActInstId == null) continue;
                    WfMessageUtil.addPreActInstToStack(wfEngine, stack, checkedSet, parentActInstId);
                    continue;
                }
                WfMessageUtil.addPreActInstToStack(wfEngine, stack, checkedSet, preInstId);
            }
        }
        finally {
            checkedSet.clear();
        }
        return list;
    }

    private static void addPreActInstToStack(WfEngine wfEngine, List stack, Set checkedSet, String actInstId) throws WfException {
        if (actInstId == null) {
            return;
        }
        ActivityInstInfo actInstInfoTmp = wfEngine.getActivityInst(actInstId).getMeta();
        String[] preActInstIdsTmp = actInstInfoTmp.getPreActInstList();
        if (preActInstIdsTmp == null) {
            return;
        }
        int i = 0;
        while (i < preActInstIdsTmp.length) {
            if (!checkedSet.contains(preActInstIdsTmp[i])) {
                stack.add(preActInstIdsTmp[i]);
                checkedSet.add(preActInstIdsTmp[i]);
            }
            ++i;
        }
    }

    private static String getEndActivityId(WfEngine wfEngine, String procInstId) throws WfException {
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        List actInsts = procInst.getActivitiesInState(WfState.COMPLETED);
        WfActivity last = null;
        for (WfActivity actInst : actInsts) {
            if (last == null) {
                last = actInst;
                continue;
            }
            Timestamp t1 = last.getMeta().getCompleteTime();
            Timestamp t2 = actInst.getMeta().getCompleteTime();
            if (t1 != null && t2 != null && t1.compareTo(t2) >= 0) continue;
            last = actInst;
        }
        return last == null ? null : last.getId();
    }

    public static void fillAssignmentCreationEvent(WfActivity activity, AssignmentInfo assignment, AssignmentCreationEvent event) throws WfException {
        if (assignment == null) {
            return;
        }
        WfEngine wfEngine = activity.getWfEngine();
        ActivityDef def = activity.getDefinition();
        Context context = activity.getWfEngine().context();
        WfProcess process = activity.container();
        ProcessInstInfo procInstInfo = process.getProcessMeta();
        Locale[] locales = ApplicationUtil.getContextLocales((Context)context);
        String grandParentDefId = "";
        try {
            grandParentDefId = WfMessageUtil.getGrandParentProcessDefId(wfEngine, activity.getId());
        }
        catch (Exception _) {
            logger.warn((Object)_.getMessage(), (Throwable)_);
        }
        event.activityDefId = def.getID();
        event.actvityInstId = activity.getId();
        event.assignmentId = assignment.getAssignmentId();
        event.bizObjId = assignment.getBizObjectIds();
        event.bizPackage = assignment.getBizPackage();
        event.databaseCenter = context.getAIS();
        event.functionName = assignment.getBizFunction();
        event.grandProcessDefId = grandParentDefId;
        event.initiatorId = procInstInfo.getInitiatorId();
        event.operationName = String.valueOf(assignment.getBizFunction()) + "." + assignment.getBizOperation();
        event.actBizType = def.getBizType();
        event.processDefHashValue = process.getData().getProcDefHashValue();
        event.processDefId = process.getData().getProcDefId();
        event.processInstId = process.getId();
        event.receiver = assignment.getPerformerUserId();
        event.solution = context.getSolution();
        int p = activity.getDefinition().getActivityHeader().getpriority();
        p = p == -2 || p == -3 ? 0 : (p == -1 || p == 0 || p == 1 ? 10 : (p == 2 || p == 3 || p == 4 || p == 5 ? 20 : 10));
        event.priority = p;
        event.initiatorName = new HashMap();
        int i = 0;
        int n = locales.length;
        while (i < n) {
            String initiatorName = procInstInfo.getInitiatorName(locales[i]);
            event.initiatorName.put(locales[i], initiatorName);
            ++i;
        }
        if (!WfMessageUtil.isOrgIsolationMessage(def)) {
            event.orgId = process.getOrgIdByHoldedBizObjId(assignment.getBizObjectIds());
        } else if (WfMessageUtil.getAssignOrgIdVariableName(def) != null) {
            event.orgId = process.getOrgIdByVariable(WfMessageUtil.getAssignOrgIdVariableName(def));
            if (WfMessageUtil.getAssignOrgTypeVariableName(def) != null) {
                event.orgType = process.getOrgTypeByVariable(WfMessageUtil.getAssignOrgTypeVariableName(def));
            }
        }
        if (event.receiver == null) {
            event.receiver = assignment.getUserId();
        }
    }

    private static String getGrandParentProcessDefId(WfEngine wfEngine, String actInstId) throws WfException {
        String curProcInstId = wfEngine.getActivityInst(actInstId).getProcInstId();
        ProcessInstInfo procInstInfo = wfEngine.getProcessInst(curProcInstId).getProcessMeta();
        String parentActInstId = procInstInfo.getParentActInstId();
        if (!StringUtils.isEmpty((String)parentActInstId)) {
            return WfMessageUtil.getGrandParentProcessDefId(wfEngine, parentActInstId);
        }
        return procInstInfo.getProcDefId();
    }

    private static boolean isOrgIsolationMessage(ActivityDef actDefine) {
        ActivityHeaderDef activityHeaderDef = actDefine.getActivityHeader();
        ExtendedAttributeCollection extendedAttributeCollection = activityHeaderDef.getExtendedAttributes();
        ExtendedAttributeDef extendedAttributeDef = extendedAttributeCollection.get("orgIsolation");
        if (extendedAttributeDef != null) {
            return "true".equalsIgnoreCase(extendedAttributeDef.getValue());
        }
        return false;
    }

    private static String getAssignOrgIdVariableName(ActivityDef actDefine) {
        ActivityHeaderDef activityHeaderDef = actDefine.getActivityHeader();
        ExtendedAttributeCollection extendedAttributeCollection = activityHeaderDef.getExtendedAttributes();
        ExtendedAttributeDef extendedAttributeDef = extendedAttributeCollection.get("assignOrgIdVariableName");
        if (extendedAttributeDef != null) {
            return extendedAttributeDef.getValue();
        }
        return null;
    }

    private static String getAssignOrgTypeVariableName(ActivityDef actDefine) {
        ActivityHeaderDef activityHeaderDef = actDefine.getActivityHeader();
        ExtendedAttributeCollection extendedAttributeCollection = activityHeaderDef.getExtendedAttributes();
        ExtendedAttributeDef extendedAttributeDef = extendedAttributeCollection.get("assignOrgTypeVariableName");
        if (extendedAttributeDef != null) {
            return extendedAttributeDef.getValue();
        }
        return null;
    }

    public static String filterSmsReceivers(Context ctx, String userIds) {
        if (smsFilter == null) {
            return userIds;
        }
        String filtered = smsFilter.filter(ctx, userIds);
        if (filtered != null && filtered.length() == 0) {
            filtered = null;
        }
        return filtered;
    }
}

