/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.affair.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.web.util.PassPortCommonUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.affair.web.handler.EmpPreEntryEditHandler;
import com.kingdee.shr.affair.web.handler.util.EmployeeUtil;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ImportException;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.preentry.FileStateEnum;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class EmpPreEntryEditHandlerEx
extends EmpPreEntryEditHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.affair.web.handler.EmpPreEntryEditHandlerEx");

    protected void beforeSave(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        PreEntryInfo billInfo = (PreEntryInfo)model;
        if (billInfo.getTalent().getPassportNO() != null) {
            PassPortCommonUtil.checkPassPortContainsChinese((String)billInfo.getTalent().getPassportNO());
        }
        try {
            Context ctx = SHRContext.getInstance().getContext();
            HRUtilExtend.checkGlobalRoamingExists((Context)ctx, (String)billInfo.getGlobalRoaming());
        }
        catch (EmployeeException var6) {
            throw new ShrWebBizException(var6.getMessage());
        }
        catch (BOSException var7) {
            var7.printStackTrace();
        }
        super.beforeSave(request, response, model);
        if (billInfo.getBillState() == null) {
            billInfo.setBillState(HRBillStateEnum.SAVED);
        }
        if (billInfo.getTalent() != null && billInfo.getTalent().getFileState() == null) {
            billInfo.getTalent().setFileState(FileStateEnum.TempStorage);
        }
        try {
            if (ObjectUtils.isEmpty((Object)billInfo.get("empNumber"))) {
                EmployeeUtil employeeUtil = new EmployeeUtil();
                int fnumber = employeeUtil.getFnumber();
                billInfo.put("empNumber", (Object)fnumber);
            }
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void verifyModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        PreEntryInfo preEntryInfo = (PreEntryInfo)model;
        try {
            EmployeeUtil employeeUtil = new EmployeeUtil();
            PreEntryPersonInfo prePersonInfo = preEntryInfo.getTalent();
            String fid = model.getString("id");
            employeeUtil.checkIsReEntry(prePersonInfo.getIdCardNO(), preEntryInfo.getName(), prePersonInfo.getBirthday());
            Boolean isUniqueCheck = employeeUtil.checkUserName(preEntryInfo.get("userName").toString(), fid, null);
            if (!isUniqueCheck.booleanValue()) {
                throw new ImportException("This user name\uff1a" + preEntryInfo.get("userName") + "already exists");
            }
            Boolean emailCheck = employeeUtil.checkEmail(preEntryInfo.get("workemail").toString(), fid, null);
            if (!emailCheck.booleanValue()) {
                throw new ImportException("The work email\uff1a" + preEntryInfo.get("userName") + "already exists");
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        super.verifyModel(request, response, model);
    }

    public String checkIdEntityAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String idCardNo = request.getParameter("idCardNo");
        String birthday = request.getParameter("birthday");
        String name = request.getParameter("name");
        logger.error((Object)("\u8eab\u4efd\u8bc1\u53f7:" + idCardNo));
        logger.error((Object)("\u51fa\u751f\u65e5\u671f:" + birthday + ",\u540d\u79f0\uff1a" + name));
        Context ctx = SHRContext.getInstance().getContext();
        try {
            IRowSet rs;
            String checkSql;
            if (StringUtils.isNotBlank((CharSequence)idCardNo)) {
                checkSql = "select FIDCardNO from t_bd_person where FIDCardNO = '" + idCardNo + "'";
                logger.error((Object)("\u67e5\u8be2\u8eab\u4efd\u8bc1SQL\uff1a" + checkSql));
                rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                if (rs.next()) {
                    modelMap.put((Object)"resultMessage", (Object)("Employee is re-entry employee, ID number\uff1a" + rs.getString("FIDCardNO")));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)birthday) && StringUtils.isNotBlank((CharSequence)name)) {
                checkSql = "select FPASSPORTNO from t_bd_person where to_char(FBirthday,'yyyy-MM-dd') = '" + birthday + "' and UPPER(FName_L1) = UPPER('" + name + "')";
                logger.error((Object)("\u67e5\u8be2\u8bc1\u4ef6SQL\uff1a" + checkSql));
                rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                if (rs.next()) {
                    modelMap.put((Object)"resultMessage", (Object)("Employee is re-entry employee, passport number\uff1a" + rs.getString("FPASSPORTNO")));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
        return null;
    }
}

