/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.eas.base.message.app.ITaskHandler;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HandlerContainer {
    private static final Logger logger = Logger.getLogger(HandlerContainer.class);
    private static HandlerContainer ourInstance = new HandlerContainer();
    private HashMap<String, Object> map = new HashMap();

    public static HandlerContainer getInstance() {
        return ourInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HandlerContainer() {
        try {
            String className1 = "com.kingdee.eas.base.message.app.DynamicAppendActHandler";
            Object obj = Class.forName(className1).newInstance();
            String className2 = "com.kingdee.bos.workflow.handler.EmailApproveHandler";
            Object obj2 = Class.forName(className2).newInstance();
            this.map.put(className2, obj2);
            this.map.put(className1, obj);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        String root = System.getProperty("EAS_INSTANCE_CONFIG_PATH");
        String handlersconfig = root + File.separator + "handlersconfig.properties";
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(handlersconfig);
            prop.load(in);
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        String handlers = prop.getProperty("handlers");
        if (StringUtils.isEmpty((String)handlers)) {
            logger.error((Object)"handlers for assignread are empty!!!");
            return;
        }
        String[] name = handlers.split(",");
        for (int i = 0; i < name.length; ++i) {
            String className = prop.getProperty(name[i]);
            Object o = null;
            try {
                o = Class.forName(className).newInstance();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            if (o == null) continue;
            this.map.put(name[i], o);
        }
        logger.info((Object)("initial handler container map --->" + this.map.toString()));
    }

    public void multiHandlersExecute(AssignmentCreationEvent ed) {
        if (this.map.size() > 0) {
            for (Object next : this.map.values()) {
                if (!(next instanceof ITaskHandler)) continue;
                ITaskHandler handler = (ITaskHandler)next;
                long startTime = System.currentTimeMillis();
                logger.info((Object)(handler.getClass().getName() + " is running--" + startTime));
                try {
                    handler.execute(ed);
                }
                catch (Throwable ex) {
                    logger.error((Object)(handler.getClass().getName() + " catch exception when running!!"));
                    logger.error((Object)ex);
                }
                logger.info((Object)(handler.getClass().getName() + " end--costTime:" + (System.currentTimeMillis() - startTime)));
            }
        } else {
            logger.warn((Object)"handler container map is null");
        }
    }
}

