/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.ServerConfigServiceInitializer;
import com.kingdee.bos.framework.PluginMethodProviderManager;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kd.isc.iscb.util.dt.D;

public class InvokeProxy {
    private Context ctx;
    private IMetaDataPK pk;
    private BOSObjectType type;

    InvokeProxy(Context ctx, IMetaDataPK pk, BOSObjectType type) {
        this.ctx = ctx;
        this.pk = pk;
        this.type = type;
    }

    public BizController getBusinessController() throws BOSException {
        return EJBFactory.getBusinessController((Context)this.ctx, (BOSObjectType)this.type, null);
    }

    public Object callCmethod(String methodSignature, Object[] args) {
        BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getBusinessObject(this.pk);
        MethodInfo method = null;
        MethodCollection mc = bo.getAllMethodsRuntime();
        int i = 0;
        while (i < mc.size()) {
            MethodInfo mi = mc.get(i);
            if (mi.toString().equals(methodSignature)) {
                method = mi;
                break;
            }
            ++i;
        }
        if (method != null) {
            return this.callCmethod(method, args);
        }
        return null;
    }

    public Object callCmethod(MethodInfo method, Object[] args) {
        try {
            return this.innerCallMethod(method, args);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    private Object innerCallMethod(MethodInfo method, Object[] args) throws ClassNotFoundException, BOSException, IllegalAccessException, InvocationTargetException, ServiceExecutionException {
        if (method == null) {
            return null;
        }
        Class<?>[] parameterTypes = this.getParamTypes(method);
        Object[] args2 = this.prepareArgs(args, parameterTypes);
        BizController bc = this.getBusinessController();
        try {
            Method md = bc.getClass().getMethod(method.getName(), parameterTypes);
            return md.invoke((Object)bc, args2);
        }
        catch (NoSuchMethodException nsm) {
            BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getBusinessObject(this.pk);
            return this.callCmethod(args, bo, method, args2);
        }
    }

    private Object[] prepareArgs(Object[] args, Class<?>[] parameterTypes) {
        Object[] args2 = new Object[parameterTypes.length];
        args2[0] = this.ctx;
        int i = 0;
        while (i < args.length) {
            args2[i + 1] = args[i];
            ++i;
        }
        return args2;
    }

    private Class<?>[] getParamTypes(MethodInfo method) throws ClassNotFoundException {
        ParameterCollection pc = method.getParameters();
        Class[] parameterTypes = new Class[pc.size() + 1];
        parameterTypes[0] = Context.class;
        int i = 0;
        while (i < pc.size()) {
            TypeReference tr = pc.get(i).getParameterType();
            String className = this.toClassName(tr);
            this.setParamType(parameterTypes, i, className);
            ++i;
        }
        return parameterTypes;
    }

    private void setParamType(Class<?>[] parameterTypes, int i, String className) throws ClassNotFoundException {
        parameterTypes[i + 1] = "short".equals(className) ? Short.TYPE : ("int".equals(className) ? Integer.TYPE : ("long".equals(className) ? Long.TYPE : ("float".equals(className) ? Float.TYPE : ("double".equals(className) ? Double.TYPE : ("char".equals(className) ? Character.TYPE : ("byte".equals(className) ? Byte.TYPE : ("boolean".equals(className) ? Boolean.TYPE : Class.forName(className))))))));
    }

    private String toClassName(TypeReference tr) {
        String className = null;
        className = tr.getArrayDimension() == 0 ? tr.toString() : this.getArrayClassName(tr);
        return className;
    }

    private String getArrayClassName(TypeReference tr) {
        String className = "";
        int j = 0;
        while (j < tr.getArrayDimension()) {
            className = String.valueOf(className) + "[";
            ++j;
        }
        if (tr.isSimpleType()) {
            String type = tr.getArrayElementType().getBaseType();
            className = this.appendSimpleType(className, type);
        } else {
            TypeReference arrayElementType = tr.getArrayElementType();
            className = arrayElementType.toString().contains("java.lang") && !arrayElementType.getBaseType().contains("java.lang") ? String.valueOf(className) + "L" + arrayElementType + ";" : String.valueOf(className) + "L" + arrayElementType.getBaseType() + ";";
        }
        return className;
    }

    private String appendSimpleType(String className, String type) {
        if (type.equalsIgnoreCase("byte")) {
            className = String.valueOf(className) + "B";
        } else if (type.equalsIgnoreCase("char")) {
            className = String.valueOf(className) + "C";
        } else if (type.equalsIgnoreCase("double")) {
            className = String.valueOf(className) + "D";
        } else if (type.equalsIgnoreCase("float")) {
            className = String.valueOf(className) + "F";
        } else if (type.equalsIgnoreCase("int")) {
            className = String.valueOf(className) + "I";
        } else if (type.equalsIgnoreCase("long")) {
            className = String.valueOf(className) + "J";
        } else if (type.equalsIgnoreCase("short")) {
            className = String.valueOf(className) + "S";
        } else if (type.equalsIgnoreCase("boolean")) {
            className = String.valueOf(className) + "Z";
        }
        return className;
    }

    private Object callCmethod(Object[] args, BusinessObjectInfo bo, MethodInfo method, Object[] args2) throws ServiceExecutionException, BOSException {
        if (PluginMethodProviderManager.getProvider() == null) {
            return null;
        }
        try {
            ServiceContext svcCtx = this.createServiceContext(bo, MetaDataPK.create((String)method.getInnerID()), args2);
            this.invokeServiceBefore(svcCtx);
            this.invokeServiceAfter(svcCtx);
            Object object = svcCtx.getMethodReturnValue();
            return object;
        }
        finally {
            ServiceStateManager.getInstance().finishCall();
        }
    }

    private ServiceContext createServiceContext(BusinessObjectInfo bo, MetaDataPK methodPK, Object[] params) {
        return new ServiceContext(bo.getBOSType(), bo.getType(), (IMetaDataPK)methodPK, params);
    }

    private void invokeServiceBefore(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(0);
        ServiceStateManager.getInstance().setServiceState(this.getServiceState());
        this.checkPluginService();
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    private void checkPluginService() throws CannotCreateServiceManagerException {
        if (!ServiceManagerFactory.getServiceManager().contains("PLUGIN_SERVICE_EP")) {
            ServerConfigServiceInitializer.initPluginService(null);
        }
    }

    private void invokeServiceAfter(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(1);
        this.checkPluginService();
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    private ServiceStateManager.ServiceState getServiceState() {
        ServiceStateManager.ServiceState state = new ServiceStateManager.ServiceState();
        state.enableSpecialService("ALL_SERVICE");
        return state;
    }

    public static InvokeProxy getProxy(Context ctx, IMetaDataPK pk, BOSObjectType type) {
        return new InvokeProxy(ctx, pk, type);
    }
}

