/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.jms.TextMessage;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.message.WfMessageUtil;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailApproveHtmlDTO;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailDigestField;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailEntriesArea;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailEntriesField;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailHisApprove;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailTextArea;
import com.kingdee.bos.workflow.extscheme.mailApprove.mailConfig.MailConfigInfo;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.bos.workflow.metas.MailApproveAgentFactory;
import com.kingdee.bos.workflow.metas.MailApproveAgentInfo;
import com.kingdee.bos.workflow.metas.MailApprovePageFactory;
import com.kingdee.bos.workflow.metas.MailApprovePageInfo;
import com.kingdee.bos.workflow.metas.MailApproveState;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.thirdInvoke.ApprovalRecordInfo;
import com.kingdee.bos.workflow.thirdInvoke.WfInvokeTool;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.eas.base.message.app.ITaskHandler;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmailApproveHandler
implements ITaskHandler {
    protected static final Logger logger = Logger.getLogger(EmailApproveHandler.class);

    public void execute(AssignmentCreationEvent ed) {
        Context ctx = this.getContext(ed.solution, ed.databaseCenter);
        if (!ed.isMailApprove) {
            return;
        }
        List list = this.mailConfig(ctx);
        if (list.size() == 0) {
            return;
        }
        Map config = (Map)list.get(0);
        try {
            MailApprovePageInfo page = MailApprovePageFactory.getLocalInstance((Context)ctx).getValue(" where procdefId ='" + ed.processDefId + "' and actdefId ='" + ed.activityDefId + "' " + "and id ='" + ed.mailApprovePageId + "'");
            if (page == null) {
                return;
            }
            MailApproveAgentInfo agent = this.initAgent(ctx, ed);
            try {
                MailApproveHtmlDTO dto = (MailApproveHtmlDTO)JSON.parseObject((String)page.getJsonInfo(), MailApproveHtmlDTO.class);
                String preNidInfo = String.valueOf(ed.databaseCenter) + "&" + agent.getId().toString() + "&" + ed.assignmentId + "&" + ed.bizObjId + "&" + ed.receiver;
                dto.setPreNidInfo(preNidInfo);
                dto.setAddressInfo(MailConfigInfo.decrypt((String)config.get("fmailaddr")));
                String title = dto.getMailTitleArea().getTitleName();
                WfActivity act = WfEngine.getEngine(ctx).getActivityInst(ed.actvityInstId);
                Locale l = new Locale(page.getLanguage());
                ctx.setLocale(l);
                String titleVal = WfMessageUtil.parseMessage(title, act, l);
                dto.getMailTitleArea().setTitleName(titleVal);
                List<MailTextArea> textAreas = dto.getMailTextAreas();
                if (textAreas != null) {
                    for (MailTextArea area : textAreas) {
                        String content = area.getTextAreaContent();
                        if (content == null || content.length() <= 0) continue;
                        area.setTextAreaContent(WfMessageUtil.parseMessage(content, act, l));
                    }
                }
                WfProcess process = WfEngine.getEngine(ctx).getProcessInst(ed.processInstId);
                List<Object> digestFieldsTemp = new ArrayList();
                if (dto.getMailDigestArea() != null) {
                    digestFieldsTemp = dto.getMailDigestArea().getBillDigestFields();
                }
                ArrayList<MailDigestField> digestFields = new ArrayList<MailDigestField>();
                int i = 0;
                while (i < digestFieldsTemp.size()) {
                    MailDigestField field = (MailDigestField)digestFieldsTemp.get(i);
                    if (this.checkIfDisplay(field.getDisplayVar(), process)) {
                        digestFields.add(field);
                    }
                    ++i;
                }
                if (dto.getMailDigestArea() != null) {
                    dto.getMailDigestArea().setBillDigestFields(digestFields);
                }
                ArrayList<MailEntriesField> allEntryFields = new ArrayList<MailEntriesField>();
                List<MailEntriesArea> entriesArea = dto.getMailEntriesAreas();
                if (entriesArea == null) {
                    entriesArea = new ArrayList<MailEntriesArea>();
                }
                int i2 = 0;
                while (i2 < entriesArea.size()) {
                    MailEntriesArea area = entriesArea.get(i2);
                    List<MailEntriesField> temp = area.getEntriesFieldList();
                    ArrayList<MailEntriesField> fields = new ArrayList<MailEntriesField>();
                    for (MailEntriesField field : temp) {
                        if (!this.checkIfDisplay(field.getDisplayVar(), process)) continue;
                        fields.add(field);
                    }
                    area.setEntriesFieldList(fields);
                    allEntryFields.addAll(fields);
                    ++i2;
                }
                if (digestFields.size() > 0 || allEntryFields.size() > 0) {
                    IObjectValue bill = this.getBizObj(ctx, digestFields, allEntryFields, ed.bizObjId);
                    String jsonStr = JSONUtils.convertObjectToJson((Context)ctx, (Object)bill);
                    JSONObject jsonObj = JSON.parseObject((String)jsonStr);
                    WfAssignment assign = WfEngine.getEngine(ctx).getAssignment(ed.assignmentId);
                    for (MailDigestField df : digestFields) {
                        if ("procField.creater".equals(df.getDigestFieldCode())) {
                            Person person = WfEngine.getEngine(ctx).getPariticipantProvider().getPersonByUserId(ctx, process.getProcessMeta().getInitiatorId());
                            df.setDigestFieldValue(person.getEmployeeName(ctx.getLocale()));
                            continue;
                        }
                        if ("procField.priorPerformer".equals(df.getDigestFieldCode())) {
                            df.setDigestFieldValue(assign.getAssignmentInfo().getAssignInfo().getPriorPerformName(ctx.getLocale()));
                            continue;
                        }
                        String val = null;
                        Object obj = this.val(jsonObj, this.cutBillName(df.getDigestFieldCode()), 1, page.getLanguage());
                        if (obj instanceof List) {
                            List coll = (List)obj;
                            if (coll.size() > 0) {
                                val = (String)coll.get(0);
                            }
                        } else {
                            val = (String)obj;
                        }
                        val = this.prepareVal(df.getDigestFieldType(), val, df.getEnumPk(), page.getLanguage());
                        df.setDigestFieldValue(val);
                    }
                    int MAX_SIZE = 500;
                    int i3 = 0;
                    while (i3 < entriesArea.size()) {
                        MailEntriesArea area = entriesArea.get(i3);
                        List<MailEntriesField> fields = area.getEntriesFieldList();
                        ArrayList<Object[]> filedValues = new ArrayList<Object[]>();
                        boolean dataListInited = false;
                        int j = 0;
                        while (j < fields.size()) {
                            MailEntriesField entryField = fields.get(j);
                            List data = (List)this.val(jsonObj, this.cutBillName(entryField.getThCode()), MAX_SIZE, page.getLanguage());
                            if (!dataListInited && data.size() > 0) {
                                int m = 0;
                                while (m < data.size()) {
                                    filedValues.add(new Object[fields.size()]);
                                    ++m;
                                }
                                dataListInited = true;
                            }
                            int k = 0;
                            while (k < data.size()) {
                                String val = (String)data.get(k);
                                val = this.prepareVal(entryField.getDigestFieldType(), val, entryField.getEnumPK(), page.getLanguage());
                                ((Object[])filedValues.get((int)k))[j] = val;
                                ++k;
                            }
                            ++j;
                        }
                        area.setDataList(filedValues);
                        ++i3;
                    }
                }
                if (dto.getMailHisApproveArea() != null) {
                    dto.getMailHisApproveArea().setApproveList(this.approveRecord(ctx, ed.bizObjId));
                }
                if (config.get("fsysapproveurl") != null) {
                    String pcApproveURL = "/easweb/webviews/workflow/transferApprove.jsp?AssignmentId=" + ed.assignmentId;
                    String base = (String)config.get("fsysapproveurl");
                    dto.getMailApproveUrlArea().setSysApproveUrl(String.valueOf(base) + pcApproveURL);
                }
                this.sendMail(ctx, ed, dto);
                agent.setState(MailApproveState.Add_MO_MAIL);
            }
            catch (Throwable t) {
                logger.error((Object)"send EmailApprove Error", t);
                agent.setErrorInfo(StringUtils.stackToString((Throwable)t));
                agent.setState(MailApproveState.BUILD_HTML_ERROR);
            }
            MailApproveAgentFactory.getLocalInstance((Context)ctx).addnew(agent);
        }
        catch (Exception e) {
            logger.error((Object)"EmailApproveHandler execute Error", (Throwable)e);
        }
    }

    private String prepareVal(String dataType, String val, String enumPk, String language) {
        String[] varArray;
        if (val == null || val.length() == 0 || val.equals("{}")) {
            return "";
        }
        if (dataType != null && dataType.toLowerCase().equals("enum")) {
            Map map = (Map)JSON.parseObject((String)val, Map.class);
            val = (String)map.get("alias");
        } else if (val.contains("l1") || val.contains("l2") || val.contains("l3")) {
            val = (String)((Map)JSON.parseObject((String)val, Map.class)).get(language);
        }
        if (val != null && (varArray = val.split(" ")).length == 2 && varArray[0].indexOf("-") > 0 && varArray[1].equals("00:00:00")) {
            val = varArray[0];
        }
        return val;
    }

    private boolean isSend(Context ctx, AssignmentCreationEvent ed) {
        if (!ed.isMailApprove) {
            return false;
        }
        List list = this.mailConfig(ctx);
        return list.size() > 0;
    }

    private List mailConfig(Context ctx) {
        String sql = "select FRENTERID,FAPPID,FSECRET,FMAILADDR,FSYSAPPROVEURL,FMOBAPPROVEURL  from t_wfr_mailconf where fkey = 'approve'";
        ArrayList list = new ArrayList();
        try {
            list = SQL.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return list;
    }

    private MailApproveAgentInfo initAgent(Context ctx, AssignmentCreationEvent ed) throws BOSException {
        PersonInfo person = AppMsgUtil.getPersonByUserId(ctx, ed.receiver);
        MailApproveAgentInfo info = new MailApproveAgentInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setAssignid(ed.assignmentId);
        info.setUserId(ed.receiver);
        info.setSendmail(person.getEmail());
        info.setReceivermail("");
        info.setTime(new Timestamp(System.currentTimeMillis()));
        return info;
    }

    private void sendMail(Context ctx, AssignmentCreationEvent ed, MailApproveHtmlDTO dto) {
        Message message = this.getInitialMessage(ed);
        String html = MailApproveHtmlDTO.buildHtml(dto);
        String title = dto.getMailTitleArea().getTitleName();
        int i = 1;
        while (i < 4) {
            String localString = "L" + i;
            Locale locale = new Locale(localString);
            message.setLocaleStringHeader("title", title, locale);
            message.setLocaleStringHeader("body", html, locale);
            ++i;
        }
        AppMsgUtil.sendBOSMessage(ctx, message);
    }

    private Message getInitialMessage(AssignmentCreationEvent ed) {
        TextMessage message = new TextMessage();
        message.setStringHeader("databaseCenter", ed.databaseCenter);
        message.setStringHeader("solution", ed.solution);
        message.setStringHeader("ProcessInstId", ed.processInstId);
        message.setStringHeader("activityInstId", ed.actvityInstId);
        message.setStringHeader("processDefHashValue", ed.processDefHashValue);
        message.setStringHeader("operation", ed.operationName);
        message.setStringHeader("function", ed.functionName);
        message.setStringHeader("bizPackage", ed.bizPackage);
        message.setStringHeader("processDefHashValue", ed.processDefHashValue);
        message.setIntHeader("type", 10);
        message.setIntHeader("priority", 10);
        message.setStringHeader("receiver", ed.receiver);
        message.setStringHeader("sourceID", ed.assignmentId);
        message.setStringHeader("isSendEmail", "true");
        message.setStringHeader("isSendMobile", "false");
        return message;
    }

    private List<MailHisApprove> approveRecord(Context ctx, String billId) throws Exception {
        String curProcInstId = new WfUtil(ctx).getProcInstId(billId);
        HashSet<String> curProcInstIdSet = WfInvokeTool.findParentAndChild(ctx, curProcInstId);
        List<ApprovalRecordInfo> curList = WfInvokeTool.getApprovalRecord(ctx, curProcInstIdSet);
        ArrayList<MailHisApprove> mailHisApproves = new ArrayList<MailHisApprove>();
        for (ApprovalRecordInfo info : curList) {
            this.dealWithLocale(ctx, info);
            MailHisApprove approve = new MailHisApprove();
            approve.setApproveDefName(info.getActivityNode());
            approve.setApproveResult(info.getApproveDecisionItem());
            approve.setApproveTime(info.getApproveTime());
            approve.setApproveUser(info.getApprover());
            approve.setApproveOpinion(info.getApproveOpinion());
            approve.setResultType(info.isPass() ? 1 : 0);
            mailHisApproves.add(approve);
        }
        return mailHisApproves;
    }

    private void dealWithLocale(Context ctx, ApprovalRecordInfo info) {
        if (StringUtils.isEmpty((String)info.getApproveOpinion())) {
            return;
        }
        if (ctx.getLocale().getLanguage().equalsIgnoreCase("l1") && info.getApproveOpinion().equals("\u540c\u610f\uff08\u81ea\u52a8\u5ba1\u6279\uff09")) {
            info.setApproveOpinion("Approve(auto approve)");
            info.setApproveResult("Approve");
        }
    }

    public String prepareKey(String key) {
        return String.valueOf(key.substring(0, 1).toLowerCase()) + key.substring(1);
    }

    public Object val(Object jsonObj, String keyExpression, int MAX_SIZE, String language) {
        String[] keys = keyExpression.split("\\.");
        int i = 0;
        while (i < keys.length) {
            if (i == keys.length - 1) {
                if (jsonObj instanceof JSONArray) {
                    JSONArray array = (JSONArray)jsonObj;
                    ArrayList<String> values = new ArrayList<String>();
                    if (array.size() == 0) {
                        return values;
                    }
                    if (MAX_SIZE == 1) {
                        JSONObject obj = (JSONObject)array.get(0);
                        if (obj == null) {
                            values.add("");
                        } else {
                            Object v = obj.get((Object)this.prepareKey(keys[i]));
                            if (v instanceof Map) {
                                Object temp = ((Map)v).get(language);
                                values.add(String.valueOf(temp));
                            } else {
                                values.add(String.valueOf(v));
                            }
                        }
                        return values;
                    }
                    if (array.size() < MAX_SIZE) {
                        MAX_SIZE = array.size();
                    }
                    int r = 0;
                    while (r < MAX_SIZE) {
                        JSONObject jo = (JSONObject)array.get(r);
                        if (jo != null) {
                            String v = jo.getString(this.prepareKey(keys[i]));
                            if (v != null) {
                                values.add(jo.getString(this.prepareKey(keys[i])));
                            } else {
                                values.add("");
                            }
                        }
                        ++r;
                    }
                    return values;
                }
                if (jsonObj instanceof JSONObject) {
                    return ((JSONObject)jsonObj).getString(this.prepareKey(keys[i]));
                }
            } else {
                if (jsonObj instanceof JSONObject) {
                    Object obj = ((JSONObject)jsonObj).get((Object)this.prepareKey(keys[i]));
                    return this.val(obj, this.rebuildExp(i, keys), MAX_SIZE, language);
                }
                if (jsonObj instanceof JSONArray) {
                    JSONArray temp = new JSONArray();
                    JSONArray array = (JSONArray)jsonObj;
                    if (array.size() < MAX_SIZE) {
                        MAX_SIZE = array.size();
                    }
                    int r = 0;
                    while (r < MAX_SIZE) {
                        if (array.get(r) instanceof JSONArray) {
                            temp = (JSONArray)array.get(r);
                        } else {
                            JSONObject jo = (JSONObject)array.get(r);
                            if (jo != null) {
                                Object obj = jo.get((Object)this.prepareKey(keys[i]));
                                if (obj instanceof JSONArray) {
                                    temp = (JSONArray)obj;
                                } else {
                                    temp.add((Object)((JSONObject)obj));
                                }
                            }
                        }
                        ++r;
                    }
                    return this.val(temp, this.rebuildExp(i, keys), MAX_SIZE, language);
                }
            }
            ++i;
        }
        return null;
    }

    private String rebuildExp(int i, String[] keys) {
        String exp = "";
        int j = i + 1;
        while (j < keys.length) {
            if (exp.length() > 0) {
                exp = String.valueOf(exp) + ".";
            }
            exp = String.valueOf(exp) + keys[j];
            ++j;
        }
        return exp;
    }

    private IObjectValue getBizObj(Context ctx, List<MailDigestField> digestFields, List<MailEntriesField> entriesFields, String billId) throws WfException {
        String code;
        SelectorItemCollection selectors = new SelectorItemCollection();
        for (MailDigestField mailDigestField : digestFields) {
            code = this.cutBillName(mailDigestField.getDigestFieldCode());
            selectors.add(new SelectorItemInfo(code));
        }
        for (MailEntriesField mailEntriesField : entriesFields) {
            code = this.cutBillName(mailEntriesField.getThCode());
            selectors.add(new SelectorItemInfo(code));
        }
        IObjectValue iObjectValue = ScriptUtil.getBizObject((Context)ctx, (String)billId, (SelectorItemCollection)selectors);
        return iObjectValue;
    }

    private boolean checkIfDisplay(String dispalyVar, WfProcess process) throws WfException {
        Object obj;
        if (dispalyVar != null && dispalyVar.trim().length() > 0 && (obj = process.getProcessContext().getDataFieldValue(dispalyVar)) instanceof Boolean) {
            return (Boolean)obj;
        }
        return true;
    }

    private String cutBillName(String fieldExpr) {
        int i = fieldExpr.indexOf(".");
        return fieldExpr.substring(i + 1);
    }

    private Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }
}

