/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.DataPusher;
import kd.isc.iscb.util.connector.RemoteEventPusher;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.connector.server.param.CallApiRequest;
import kd.isc.iscb.util.connector.server.param.CreateDataCopyExecutionServiceRequest;
import kd.isc.iscb.util.connector.server.param.CreateDataFlowRequest;
import kd.isc.iscb.util.connector.server.param.CreateFlowInstServiceRequest;
import kd.isc.iscb.util.connector.server.param.EventHandleServiceRequest;
import kd.isc.iscb.util.connector.server.param.PublishEntityEventDataServiceRequest;
import kd.isc.iscb.util.connector.server.param.ServiceRequest;
import kd.isc.iscb.util.connector.server.param.SignalFlowInstServiceRequest;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.ConnectionException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class EventBindingUtil {
    public static final String CREATED = "C";
    public static final String FAILED = "F";
    public static final String REPUSHING = "R";
    public static final String IGNORE = "I";
    public static final String SELF = "{self}";
    public static final String EVENT_BINDING_TABLE = "T_ISCB_CON_EVT_BND";
    public static final String EVENT_QUEUE_TABLE = "T_ISCB_CON_EVT_QUE";
    private static final Map<String, Map<String, String>> loginInfos = new ReadLockFreeMap<String, Map<String, String>>();

    public static void deleteEvents(Connection cn, String iscHub, String entity, TriggerType type, long trigger_id) {
        EventBindingUtil.deleteExistsData(cn, trigger_id, type, iscHub);
    }

    public static void saveEvents(Connection cn, String iscHub, String entity, TriggerType type, long trigger_id, String[] events, Map<String, Object> required_fields) {
        EventBindingUtil.checkParams(events, required_fields);
        EventBindingUtil.deleteExistsData(cn, trigger_id, type, iscHub);
        String id = EventBindingUtil.generateId(iscHub, entity, type, trigger_id);
        EventBindingUtil.insertEventData(cn, id, type, trigger_id, iscHub, events, entity, required_fields);
    }

    private static void checkParams(String[] events, Map<String, Object> required_fields) {
        if (events.length == 0) {
            throw new IscBizException(ResManager.loadKDString("\u4e8b\u4ef6\u4e3a\u7a7a\u3002", "EventBindingUtil_7", "isc-iscb-util", new Object[0]));
        }
        if (required_fields.isEmpty()) {
            throw new IscBizException(String.valueOf(ResManager.loadKDString("1.\u82e5\u5f53\u524d\u4f7f\u7528\u7684\u662f\u96c6\u6210\u65b9\u6848/\u542f\u52a8\u65b9\u6848\uff0c\u662f\u56e0\u4e3a\u96c6\u6210\u65b9\u6848\u7684\u5b57\u6bb5\u6620\u5c04\u6ca1\u6709\u914d\u7f6e\u6e90\u5b57\u6bb5\u3002", "EventBindingUtil_11", "isc-iscb-util", new Object[0])) + "\n" + ResManager.loadKDString("2.\u82e5\u5f53\u524d\u4f7f\u7528\u7684\u662f\u670d\u52a1\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u5f00\u59cb\u8282\u70b9\u7684\u53d6\u503c\u5b57\u6bb5\u662f\u5426\u4e3a\u7a7a", "EventBindingUtil_13", "isc-iscb-util", new Object[0]));
        }
    }

    public static void checkParams(String[] events, Map<String, Object> required_fields, String type, String number, String name) {
        if (events.length == 0) {
            throw new IscBizException(String.format(ResManager.loadKDString("%1$s\u89e6\u53d1\u4e8b\u4ef6\u4e3a\u7a7a\uff0c\u3010\u7f16\u7801\uff1a%2$s\uff0c\u540d\u79f0\uff1a%3$s\u3011\u3002\u8bf7\u5148\u4fee\u6539\u65b9\u6848\uff0c\u518d\u53ef\u8fdb\u884c\u73af\u5883\u521d\u59cb\u5316\u3002", "EventBindingUtil_16", "isc-iscb-util", new Object[0]), type, number, name));
        }
        if (required_fields.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString("%1$s\u6e90\u5b57\u6bb5/\u53d6\u503c\u5b57\u6bb5/\u53d1\u5e03\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u3010\u7f16\u7801\uff1a%2$s\uff0c\u540d\u79f0\uff1a%3$s\u3011\u3002\u8bf7\u5148\u4fee\u6539\u65b9\u6848\uff0c\u518d\u53ef\u8fdb\u884c\u73af\u5883\u521d\u59cb\u5316\u3002", "EventBindingUtil_17", "isc-iscb-util", new Object[0]), type, number, name));
        }
    }

    private static String generateId(String iscHub, String entity, TriggerType type, long trigger_id) {
        String id = Hash.md5(String.valueOf(iscHub) + ";" + entity + ";" + (Object)((Object)type) + ";" + trigger_id);
        return id;
    }

    private static void insertEventData(Connection cn, String id, TriggerType type, long trigger_id, String iscHub, String[] events, String entity, Map<String, Object> required_fields) {
        String sql = "INSERT INTO T_ISCB_CON_EVT_BND(fid, fisc_hub, fentity, ftrigger_type,ftrigger_id,fevents,frequired_fields,fcreated_time)VALUES(?,?,?,?,?,?,?,?)";
        List<Object> params = Arrays.asList(id, iscHub, entity, type.toString(), String.valueOf(trigger_id), StringUtil.join(events), Json.toString(required_fields), BigDecimal.valueOf(System.currentTimeMillis()));
        List<Integer> types = Arrays.asList(12, 12, 12, 12, 12, 12, 12, 3);
        DbUtil.executeUpdate(cn, sql, params, types);
    }

    private static void deleteExistsData(Connection cn, long triggerId, TriggerType type, String iscHub) {
        String sql = "delete from T_ISCB_CON_EVT_BND where ftrigger_id=? and ftrigger_type = ? and fisc_hub = ?";
        DbUtil.executeUpdate(cn, sql, Arrays.asList(String.valueOf(triggerId), type.toString(), iscHub), Arrays.asList(12, 12, 12));
    }

    public static void createEventBindingTable(Connection cn, String typeOfClob) {
        String sql = "create table T_ISCB_CON_EVT_BND(fid varchar(32) not null,fcreated_time decimal(19,0) not null,fisc_hub varchar(32) not null,fentity varchar(100) not null,ftrigger_type char(1) not null,ftrigger_id varchar(20) not null,fevents varchar(1024) not null,frequired_fields " + typeOfClob + " not null," + "CONSTRAINT UK_ISCB_CON_EVT_BND unique(ftrigger_id,ftrigger_type,fisc_hub,fentity)," + "CONSTRAINT PK_ISCB_CON_EVT_BND primary key(fid)" + ")";
        DbUtil.executeUpdate(cn, sql);
    }

    public static String saveEventArgs(Connection cn, String entity, String event, String boid, String isc_hub, String trigger_type, String trigger_id, String data, String error) {
        String sql = "INSERT INTO T_ISCB_CON_EVT_QUE(fid,fcreated_time,fentity,fevent,fboid,fisc_hub,ftrigger_type,ftrigger_id,fstate,fmodified_time,fdata,ferror)VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        params.add(id);
        types.add(12);
        params.add(BigDecimal.valueOf(System.currentTimeMillis()));
        types.add(3);
        params.add(entity);
        types.add(12);
        params.add(event);
        types.add(12);
        params.add(boid);
        types.add(12);
        params.add(isc_hub);
        types.add(12);
        params.add(trigger_type);
        types.add(12);
        params.add(trigger_id);
        types.add(12);
        if (error != null) {
            params.add(FAILED);
        } else {
            params.add(data == null ? IGNORE : CREATED);
        }
        types.add(12);
        params.add(null);
        types.add(3);
        params.add(data == null ? "{}" : data);
        types.add(12);
        params.add(error);
        types.add(12);
        int i = DbUtil.executeUpdate(cn, sql, params, types);
        return i == 1 ? id : null;
    }

    public static void pushAll(Connection cn, String dataCenter) {
        EventBindingUtil.pushAll(cn, dataCenter, new RemoteEventPusher());
    }

    public static void pushAll(Connection cn, String dataCenter, DataPusher pusher) {
        String sql = "SELECT fid, fisc_hub, ftrigger_type,ftrigger_id, fboid,fdata FROM T_ISCB_CON_EVT_QUE WHERE fstate in('C','R') ORDER BY fisc_hub, ftrigger_type, ftrigger_id, fcreated_time";
        ObjectReader<DataRow> reader = DbUtil.executeQuery(cn, sql, new ArrayList<Object>(), new ArrayList<Integer>(0));
        try {
            String trigger_type = null;
            String trigger_id = null;
            String isc_hub = null;
            HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
            HashMap<String, List<Object>> eventIdsMap = new HashMap<String, List<Object>>();
            String currentIscHub = ConnectorCallback.getIscHub(dataCenter);
            DataRow row = reader.read();
            while (row != null) {
                String isc_hub0 = D.s(row.get("fisc_hub"));
                if (SELF.equals(isc_hub0) || isc_hub0.equals(currentIscHub)) {
                    String trigger_id0;
                    String trigger_type0 = D.s(row.get("ftrigger_type"));
                    if (EventBindingUtil.isNotSaveBatch(trigger_type, trigger_id, trigger_type0, trigger_id0 = D.s(row.get("ftrigger_id")))) {
                        EventBindingUtil.pushData(cn, isc_hub, trigger_type, trigger_id, dataMap, eventIdsMap, pusher);
                        isc_hub = isc_hub0;
                        trigger_type = trigger_type0;
                        trigger_id = trigger_id0;
                        dataMap.clear();
                        eventIdsMap.clear();
                    }
                    EventBindingUtil.collectData(pusher, cn, dataMap, eventIdsMap, row);
                } else {
                    BigDecimal now = BigDecimal.valueOf(System.currentTimeMillis());
                    EventBindingUtil.setFailed(cn, now, row.get("fid"), String.format(ResManager.loadKDString("\u6b64\u4e8b\u4ef6\u4e0d\u662f\u5f53\u524d\u96c6\u6210\u4e91\u4e8b\u4ef6\uff0c\u6545\u4e0d\u8fdb\u884c\u63a8\u9001\uff08\u5f53\u524d\u96c6\u6210\u4e91\u7f16\u7801\uff1a%s)", "EventBindingUtil_14", "isc-iscb-util", new Object[0]), currentIscHub), FAILED);
                }
                row = reader.read();
            }
            EventBindingUtil.pushData(cn, isc_hub, trigger_type, trigger_id, dataMap, eventIdsMap, pusher);
        }
        finally {
            reader.close();
        }
    }

    private static void collectData(DataPusher pusher, Connection cn, Map<String, Map<String, Object>> dataMap, Map<String, List<Object>> eventIdsMap, DataRow row) {
        Object eventId = row.get("fid");
        try {
            Object json = Json.toObject(D.s(row.get("fdata")));
            if (json instanceof List) {
                String isc_hub = D.s(row.get("fisc_hub"));
                String trigger_type = D.s(row.get("ftrigger_type"));
                String trigger_id = D.s(row.get("ftrigger_id"));
                EventBindingUtil.pushData(cn, isc_hub, trigger_type, trigger_id, pusher, (List)json, D.asList(eventId));
            } else {
                String boid = D.s(row.get("fboid"));
                Map data = (Map)json;
                dataMap.put(boid, data);
                List<Object> list = eventIdsMap.get(boid);
                if (list == null) {
                    list = new ArrayList<Object>(2);
                    eventIdsMap.put(boid, list);
                }
                list.add(eventId);
            }
        }
        catch (Throwable e) {
            BigDecimal now = BigDecimal.valueOf(System.currentTimeMillis());
            EventBindingUtil.setFailed(cn, now, eventId, e, FAILED);
        }
    }

    private static boolean isNotSaveBatch(String trigger_type, String trigger_id, String trigger_type0, String trigger_id0) {
        return !trigger_id0.equals(trigger_id) || !trigger_type0.equals(trigger_type);
    }

    private static void pushData(Connection cn, String isc_hub, String trigger_type, String trigger_id, Map<String, Map<String, Object>> dataMap, Map<String, List<Object>> eventIdsMap, DataPusher pusher) {
        if (dataMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> e : dataMap.entrySet()) {
            Map<String, Object> data = e.getValue();
            String boid = e.getKey();
            List<Object> eventIds = eventIdsMap.get(boid);
            EventBindingUtil.pushData(cn, isc_hub, trigger_type, trigger_id, pusher, data, eventIds);
        }
    }

    public static void pushData(Connection cn, String isc_hub, String trigger_type, String trigger_id, DataPusher pusher, Map<String, Object> data, List<Object> eventIds) {
        EventBindingUtil.pushData(cn, isc_hub, trigger_type, trigger_id, pusher, Collections.singletonList(data), eventIds);
    }

    public static void pushData(Connection cn, String isc_hub, String trigger_type, String trigger_id, DataPusher pusher, List<Map<String, Object>> data, List<Object> eventIds) {
        try {
            if (!EventBindingUtil.setWaiting(cn, eventIds)) {
                return;
            }
            try {
                pusher.push(cn, isc_hub, trigger_type, trigger_id, data);
                BigDecimal now = BigDecimal.valueOf(System.currentTimeMillis());
                EventBindingUtil.setSuccess(cn, now, eventIds);
            }
            catch (Throwable err) {
                String state;
                BigDecimal now = BigDecimal.valueOf(System.currentTimeMillis());
                String string = state = err.getCause() instanceof IOException || err instanceof ConnectionException ? REPUSHING : FAILED;
                if (eventIds.size() > 1) {
                    EventBindingUtil.setFailed(cn, now, eventIds, state);
                }
                EventBindingUtil.setFailed(cn, now, eventIds.get(0), err, state);
                if (REPUSHING.equals(state)) {
                    throw new ConnectionException(err);
                }
            }
        }
        finally {
            EventBindingUtil.commit(cn);
        }
    }

    private static void commit(Connection cn) {
        try {
            if (!cn.getAutoCommit()) {
                cn.commit();
            }
        }
        catch (SQLException e) {
            throw DatabaseError.TRANS_COMMIT_FAILURE.wrap(e);
        }
    }

    private static boolean setWaiting(Connection cn, List<Object> eventIds) {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(EVENT_QUEUE_TABLE);
        sql.append(" SET fstate='W'");
        sql.append(" WHERE fstate in ('C','R') AND fid in(");
        for (Object id : eventIds) {
            if (params.size() > 0) {
                sql.append(',');
            }
            sql.append('?');
            params.add(id);
            types.add(12);
        }
        sql.append(')');
        int affected = DbUtil.executeUpdate(cn, sql.toString(), params, types);
        return affected == eventIds.size();
    }

    public static void repush(Connection cn, List<Object> eventIds) {
        ArrayList<Object> params = new ArrayList<Object>(eventIds.size());
        ArrayList<Integer> types = new ArrayList<Integer>(eventIds.size());
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_ISCB_CON_EVT_QUE SET fstate='C' WHERE fid in(");
        for (Object id : eventIds) {
            if (params.size() > 0) {
                sql.append(',');
            }
            sql.append('?');
            params.add(id);
            types.add(12);
        }
        sql.append(')');
        DbUtil.executeUpdate(cn, sql.toString(), params, types);
    }

    public static void removeLog(Connection cn, List<Object> eventIds) {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        String sql = EventBindingUtil.generateRemoveLogSQL(eventIds, params, types);
        DbUtil.executeUpdate(cn, sql, params, types);
    }

    public static String generateRemoveLogSQL(List<Object> eventIds, ArrayList<Object> params, ArrayList<Integer> types) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(EVENT_QUEUE_TABLE);
        sql.append(" WHERE fid in(");
        for (Object id : eventIds) {
            if (params.size() > 0) {
                sql.append(',');
            }
            sql.append('?');
            params.add(id);
            types.add(12);
        }
        sql.append(')');
        return sql.toString();
    }

    public static int removeLog(Connection cn, int keepdays, String iscHub) {
        ArrayList<Object> params = new ArrayList<Object>(2);
        ArrayList<Integer> types = new ArrayList<Integer>(2);
        params.add(System.currentTimeMillis() - (long)keepdays * 86400000L);
        types.add(3);
        String sql = null;
        if (iscHub != null) {
            params.add(iscHub);
            types.add(12);
            sql = "DELETE from T_ISCB_CON_EVT_QUE where fmodified_time < ? and fisc_hub = ? ";
        } else {
            sql = "DELETE from T_ISCB_CON_EVT_QUE where fmodified_time < ? ";
        }
        return DbUtil.executeUpdate(cn, sql, params, types);
    }

    private static void setSuccess(Connection cn, BigDecimal now, List<Object> eventIds) {
        ArrayList<Object> params = new ArrayList<Object>(eventIds.size() + 1);
        ArrayList<Integer> types = new ArrayList<Integer>(eventIds.size() + 1);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(EVENT_QUEUE_TABLE);
        sql.append(" SET fstate='S', fmodified_time=?, ferror=null");
        sql.append(" WHERE fid in(");
        params.add(now);
        types.add(3);
        for (Object id : eventIds) {
            if (params.size() > 1) {
                sql.append(',');
            }
            sql.append('?');
            params.add(id);
            types.add(12);
        }
        sql.append(')');
        DbUtil.executeUpdate(cn, sql.toString(), params, types);
    }

    private static void setFailed(Connection cn, BigDecimal now, Object id, Throwable e, String state) {
        EventBindingUtil.setFailed(cn, now, id, StringUtil.toString(e), state);
    }

    private static void setFailed(Connection cn, BigDecimal now, Object id, String errorMes, String state) {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        params.add(state);
        types.add(12);
        params.add(now);
        types.add(3);
        params.add(errorMes);
        types.add(12);
        params.add(id);
        types.add(12);
        String sql = "UPDATE T_ISCB_CON_EVT_QUE SET fstate=?, fmodified_time=?, ferror=? WHERE fid =?";
        DbUtil.executeUpdate(cn, sql, params, types);
    }

    public static void setFailed(Connection cn, BigDecimal now, List<Object> eventIds, String state) {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(EVENT_QUEUE_TABLE);
        sql.append(" SET fstate='");
        sql.append(state);
        sql.append("', fmodified_time=?, ferror=null");
        sql.append(" WHERE fid in(");
        params.add(now);
        types.add(3);
        for (Object id : eventIds) {
            if (params.size() > 1) {
                sql.append(',');
            }
            sql.append('?');
            params.add(id);
            types.add(12);
        }
        sql.append(')');
        DbUtil.executeUpdate(cn, sql.toString(), params, types);
    }

    public static void dropEventQueueTable(Connection cn) {
        String sql = "DROP TABLE T_ISCB_CON_EVT_QUE";
        DbUtil.executeUpdate(cn, sql);
    }

    public static void createEventQueueTable(Connection cn, String typeOfClob) {
        String sql = "CREATE TABLE T_ISCB_CON_EVT_QUE(fid varchar(32) not null,fcreated_time decimal(19,0) not null,fentity varchar(150) not null,fevent varchar(50) not null,fboid varchar(100) not null,fisc_hub varchar(32) not null,ftrigger_type char(1) not null,ftrigger_id varchar(20) not null,fstate char(1) not null,fmodified_time decimal(19,0),fdata  " + typeOfClob + "," + "ferror " + typeOfClob + "," + "CONSTRAINT PK_ISCB_CON_EV_QUE primary key(fid)" + ")";
        DbUtil.executeUpdate(cn, sql);
    }

    public static void registerLoginInfo(Map<String, String> loginInfo) {
        String isc_hub = D.s(loginInfo.get("isc_hub"));
        loginInfos.put(isc_hub, loginInfo);
    }

    public static Map<String, String> getLoginInfo(String isc_hub) {
        Map<String, String> loginInfo = loginInfos.get(isc_hub);
        if (loginInfo != null) {
            return loginInfo;
        }
        throw new IscBizException(String.format(ResManager.loadKDString("\u627e\u4e0d\u5230ID\u662f(%s)\u7684\u96c6\u6210\u4e91\u670d\u52a1\u7684\u767b\u5f55\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5connector.ini\u7684\u914d\u7f6e\u4fe1\u606f\u4e0e\u96c6\u6210\u4e91\u8fde\u63a5\u4fe1\u606f\u662f\u5426\u4e00\u81f4\uff01", "EventBindingUtil_15", "isc-iscb-util", new Object[0]), isc_hub));
    }

    private static void removeLoginInfo(String isc_hub) {
        loginInfos.remove(isc_hub);
    }

    public static boolean existsLoginInfo(String isc_hub) {
        return loginInfos.containsKey(isc_hub);
    }

    public static void deleteIscHub(Connection cn) {
        String sql = "delete from T_ISC_HUB_SERVER";
        DbUtil.executeUpdate(cn, sql);
    }

    public static void batchDeleteEventBind(Connection cn, String iscHub) {
        String sql = "delete from T_ISCB_CON_EVT_BND where fisc_hub=?";
        DbUtil.executeUpdate(cn, sql, Collections.singletonList(iscHub), Collections.singletonList(12));
    }

    public static void batchDeleteEventQue(Connection cn, String iscHub) {
        String sql = "delete from T_ISCB_CON_EVT_QUE where fisc_hub=?";
        DbUtil.executeUpdate(cn, sql, Collections.singletonList(iscHub), Collections.singletonList(12));
    }

    public static enum TriggerType {
        DataCopyTrigger{

            @Override
            public ServiceRequest<?> buildRequest(String trigger, Collection<Map<String, Object>> data) {
                return CreateDataCopyExecutionServiceRequest.build(trigger, data);
            }

            public String toString() {
                return "D";
            }
        }
        ,
        EntityEventTrigger{

            @Override
            public ServiceRequest<?> buildRequest(String trigger, Collection<Map<String, Object>> data) {
                return PublishEntityEventDataServiceRequest.build(trigger, data);
            }

            public String toString() {
                return "E";
            }
        }
        ,
        ServiceFlowTrigger{

            @Override
            public ServiceRequest<?> buildRequest(String trigger, Collection<Map<String, Object>> data) {
                return CreateFlowInstServiceRequest.build(trigger, data);
            }

            public String toString() {
                return "S";
            }
        }
        ,
        ServiceFlowEventWaiting{

            @Override
            public ServiceRequest<?> buildRequest(String trigger, Collection<Map<String, Object>> data) {
                return SignalFlowInstServiceRequest.build(trigger, data);
            }

            public String toString() {
                return "W";
            }
        }
        ,
        APITrigger{

            @Override
            public ServiceRequest<?> buildRequest(String trigger, Collection<Map<String, Object>> data) {
                return CallApiRequest.build(trigger, data);
            }

            public String toString() {
                return "A";
            }
        }
        ,
        DataFlowTrigger{

            @Override
            public ServiceRequest<?> buildRequest(String trigger, Collection<Map<String, Object>> data) {
                return CreateDataFlowRequest.build(trigger, data);
            }

            public String toString() {
                return EventBindingUtil.FAILED;
            }
        }
        ,
        Event_Mesh{

            @Override
            public ServiceRequest<?> buildRequest(String trigger, Collection<Map<String, Object>> data) {
                return EventHandleServiceRequest.build("M", trigger, data);
            }

            public String toString() {
                return "M";
            }
        };


        public static TriggerType get(String name) {
            if ("D".equals(name)) {
                return DataCopyTrigger;
            }
            if ("E".equals(name)) {
                return EntityEventTrigger;
            }
            if ("S".equals(name)) {
                return ServiceFlowTrigger;
            }
            if ("A".equals(name)) {
                return APITrigger;
            }
            if ("W".equals(name)) {
                return ServiceFlowEventWaiting;
            }
            if (EventBindingUtil.FAILED.equals(name)) {
                return DataFlowTrigger;
            }
            if ("M".equals(name)) {
                return Event_Mesh;
            }
            return TriggerType.valueOf(name);
        }

        public abstract ServiceRequest<?> buildRequest(String var1, Collection<Map<String, Object>> var2);
    }
}

