/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.i.DecimalType;
import kd.isc.iscb.util.dt.i.IntegerType;
import kd.isc.iscb.util.dt.i.LongType;
import kd.isc.iscb.util.dt.i.StringType;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;

public class TableUtil {
    public static Response doAction(Connection cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        if (actions.size() != 1) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u53ea\u5141\u8bb8\u6307\u5b9a1\u4e2a\u64cd\u4f5c\u7c7b\u578b\uff0c\u5f53\u524d\u7684\u64cd\u4f5c\u5217\u8868\u662f\uff1a%s", "TableUtil_22", "isc-iscb-util", new Object[0]), actions));
        }
        TableAction action = TableAction.find(actions.get(0));
        if (action == null) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u64cd\u4f5c\u7c7b\u578b %s \u4e0d\u7b26\u5408\u8981\u6c42\u3002", "TableUtil_23", "isc-iscb-util", new Object[0]), actions));
        }
        return TableUtil.doAction(cn, data, mainTable, entryTables, judgeFields, action);
    }

    public static Response doAction(Connection cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, TableAction action) {
        if (mainTable.getPrimaryKey() == null) {
            return TableUtil.doActionWithMultiPKs(cn, data, mainTable, entryTables, judgeFields.get("$"), action);
        }
        return TableUtil.doActionWithSinglePK(cn, data, mainTable, entryTables, judgeFields, action);
    }

    private static Response doActionWithSinglePK(Connection cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, TableAction action) {
        Object id = TableUtil.queryPrimaryKey(data, mainTable, null, judgeFields.get("$"), cn);
        HashMap<String, String> entry_mapping = new HashMap<String, String>();
        if (id == null) {
            if (action == TableAction._INSERT || action == TableAction._SAVE) {
                id = TableUtil.insert(cn, data, mainTable, entryTables, entry_mapping, judgeFields.get("$"));
                return new Response(D.s(id), SaveDataType.INSERT, entry_mapping);
            }
            return new Response(null, SaveDataType.NOP, null);
        }
        if (action == TableAction._UPDATE || action == TableAction._SAVE) {
            TableUtil.update(cn, data, id, mainTable, entryTables, judgeFields, entry_mapping);
            return new Response(id.toString(), SaveDataType.UPDATE, entry_mapping);
        }
        if (action == TableAction._DELETE) {
            TableUtil.delete(cn, data, id, mainTable, entryTables);
            return new Response(id.toString(), SaveDataType.DELETE, null);
        }
        return new Response(id.toString(), SaveDataType.NOP, null);
    }

    private static Response doActionWithMultiPKs(Connection cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, List<String> judgeFields, TableAction action) {
        int count = TableUtil.queryRowCount(data, mainTable, judgeFields, cn);
        if (count == 0) {
            if (action == TableAction._INSERT || action == TableAction._SAVE) {
                TableUtil.insert(cn, mainTable, data);
                return new Response(null, SaveDataType.INSERT, null);
            }
            return new Response(null, SaveDataType.NOP, null);
        }
        if (count == 1) {
            if (action == TableAction._UPDATE || action == TableAction._SAVE) {
                boolean affected = TableUtil.update(cn, mainTable, data, judgeFields);
                if (affected) {
                    return new Response(null, SaveDataType.UPDATE, null);
                }
                return new Response(null, SaveDataType.NOP, null);
            }
            if (action == TableAction._DELETE) {
                TableUtil.delete(cn, mainTable, data, judgeFields);
                return new Response(null, SaveDataType.DELETE, null);
            }
            return new Response(null, SaveDataType.NOP, null);
        }
        StringBuilder condition = new StringBuilder();
        for (String name : judgeFields) {
            if (condition.length() > 0) {
                condition.append(" AND ");
            }
            condition.append(name).append('=').append(data.get(name));
        }
        throw new IscBizException(String.format(ResManager.loadKDString("\u6839\u636e\u5019\u9009\u952e\u5b57\u6bb5\u503c\u67e5\u8be2\u5230%1$s\u884c\u6570\u636e\uff0c\u6761\u4ef6\u662f\uff1a%2$s", "TableUtil_24", "isc-iscb-util", new Object[0]), count, condition));
    }

    private static void delete(Connection cn, Map<String, Object> data, Object id, Table mainTable, Map<String, Pair<Table, String>> entryTables) {
        String pk = mainTable.getPrimaryKey().getName();
        TableUtil.delete(cn, mainTable, pk, id);
        for (Pair<Table, String> p : entryTables.values()) {
            Table entryTable = p.getA();
            String master_field = p.getB();
            TableUtil.delete(cn, entryTable, master_field, id);
        }
    }

    private static Object insert(Connection cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, String> entry_mapping, List<String> judgeFields) {
        String pk = mainTable.getPrimaryKey().getName();
        Object id = data.get(pk);
        if (id == null && !TableUtil.useStrict(data)) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u76ee\u6807\u8868\u4e3b\u952e\u5b57\u6bb5\uff08%s\uff09\u503c\u4e0d\u53ef\u4e3a\u7a7a\uff01", "TableUtil_25", "isc-iscb-util", new Object[0]), mainTable.getPrimaryKey()));
        }
        TableUtil.insert(cn, mainTable, data);
        if (id == null) {
            id = TableUtil.queryPrimaryKey(data, mainTable, null, judgeFields, cn);
            data.put(pk, id);
        }
        TableUtil.setId(data, id, mainTable, entryTables);
        for (Map.Entry<String, Pair<Table, String>> e : entryTables.entrySet()) {
            Pair<Table, String> p = e.getValue();
            Table entryTable = p.getA();
            for (Map<String, Object> entry : TableUtil.getEntries(data, e.getKey())) {
                TableUtil.insert(cn, entryTable, entry);
                TableUtil.recordEntryMapping(entry, entry_mapping, entryTable);
            }
        }
        return id;
    }

    private static void recordEntryMapping(Map<String, Object> entry, Map<String, String> entry_mapping, Table entryTable) {
        String source_oid = D.s(entry.get("$id"));
        String entry_id = D.s(entry.get(entryTable.getPrimaryKeyName()));
        entry_mapping.put(source_oid, entry_id);
    }

    private static void update(Connection cn, Map<String, Object> data, Object id, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, Map<String, String> entry_mapping) {
        TableUtil.setId(data, id, mainTable, entryTables);
        TableUtil.update(cn, mainTable, data);
        for (Map.Entry<String, Pair<Table, String>> e : entryTables.entrySet()) {
            Pair<Table, String> p = e.getValue();
            Table entryTable = p.getA();
            String master_field = p.getB();
            String entryName = e.getKey();
            List<Map<String, Object>> entries = TableUtil.getEntries(data, entryName);
            TableUtil.update(cn, entryTable, entries, master_field, id, judgeFields.get(entryName), entry_mapping);
        }
    }

    private static void update(Connection cn, Table entryTable, List<Map<String, Object>> entries, String master_field, Object id, List<String> judgeFields, Map<String, String> entry_mapping) {
        if (judgeFields == null) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u5fc5\u987b\u6307\u5b9a\u5206\u5f55\u8868\uff08%s\uff09\u7684\u5019\u9009\u952e\u5b57\u6bb5\uff01", "TableUtil_26", "isc-iscb-util", new Object[0]), entryTable.getName()));
        }
        HashSet<String> fields = new HashSet<String>(judgeFields);
        fields.add(entryTable.getPrimaryKey().getName());
        int i = 0;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        for (String jf : fields) {
            if (++i > 1) {
                sql.append(", ");
            }
            sql.append(entryTable.getField(jf).getBinding());
        }
        sql.append(" FROM ").append(entryTable.getQuotedName());
        Column mf = entryTable.getField(master_field);
        sql.append(" WHERE ").append(mf.getBinding()).append("=?");
        List<DataRow> exists = DbUtil.executeList(cn, sql.toString(), Collections.singletonList(mf.toSqlParam(id)), Collections.singletonList(mf.getSqlType()));
        HashMap<String, DataRow> mapping = new HashMap<String, DataRow>(exists.size());
        for (DataRow row : exists) {
            String keys = TableUtil.calcKeys(row, judgeFields);
            mapping.put(keys, row);
        }
        String pk = entryTable.getPrimaryKey().getName();
        ArrayList<Map<String, Object>> for_insert = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> for_update = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> entry : entries) {
            String keys = TableUtil.calcKeys(entry, judgeFields);
            DataRow original = (DataRow)mapping.remove(keys);
            if (original == null) {
                for_insert.add(entry);
                continue;
            }
            entry.put(pk, original.get(pk));
            for_update.add(entry);
        }
        for (Map<String, Object> entry : mapping.values()) {
            TableUtil.delete(cn, entryTable, entry);
        }
        for (Map<String, Object> entry : for_update) {
            TableUtil.update(cn, entryTable, entry);
            TableUtil.recordEntryMapping(entry, entry_mapping, entryTable);
        }
        for (Map<String, Object> entry : for_insert) {
            TableUtil.insert(cn, entryTable, entry);
            TableUtil.recordEntryMapping(entry, entry_mapping, entryTable);
        }
    }

    private static void delete(Connection cn, Table entryTable, Map<String, Object> entry) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(entryTable.getQuotedName());
        Column pk = entryTable.getPrimaryKey();
        sql.append(" WHERE ").append(pk.getBinding()).append("=?");
        Object id = pk.toSqlParam(entry.get(pk.getName()));
        DbUtil.executeUpdate(cn, sql.toString(), Collections.singletonList(id), Collections.singletonList(pk.getSqlType()));
    }

    private static void delete(Connection cn, Table mainTable, String field, Object value) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(mainTable.getQuotedName());
        Column f = mainTable.getField(field);
        sql.append(" WHERE ").append(f.getBinding()).append("=?");
        Object id = f.toSqlParam(value);
        DbUtil.executeUpdate(cn, sql.toString(), Collections.singletonList(id), Collections.singletonList(f.getSqlType()));
    }

    public static boolean update(Connection cn, Table table, Map<String, Object> data) {
        Column pk = table.getPrimaryKey();
        Object id = data.remove(pk.getName());
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(table.getQuotedName());
        sql.append(" SET ");
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            Column f = table.findField(e.getKey());
            if (f == null) continue;
            if (values.size() > 0) {
                sql.append(", ");
            }
            sql.append(f.getBinding()).append("=?");
            values.add(f.toSqlParam(e.getValue()));
            types.add(f.getSqlType());
        }
        sql.append(" WHERE ").append(pk.getBinding()).append("=?");
        values.add(pk.toSqlParam(id));
        types.add(pk.getSqlType());
        data.put(pk.getName(), id);
        int afftected = DbUtil.executeUpdate(cn, sql.toString(), values, types);
        return afftected > 0;
    }

    public static void insert(Connection cn, Table table, Map<String, Object> data) {
        if (TableUtil.useStrict(data)) {
            List<String> fields = TableUtil.selectFields(table, data);
            String sql = TableUtil.prepareInsertSQL(table, fields);
            PreparedStatement ps = null;
            try {
                try {
                    ps = cn.prepareStatement(sql);
                    TableUtil.setParamsForInsert(table, ps, data, fields);
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    throw DatabaseError.SQL_INSERT_FAILURE.wrap(e);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
        } else {
            String sql = TableUtil.prepareInsertSQL(table);
            PreparedStatement ps = null;
            try {
                try {
                    ps = cn.prepareStatement(sql);
                    TableUtil.setParamsForInsert(table, ps, data);
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    throw DatabaseError.SQL_INSERT_FAILURE.wrap(e);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
            DbUtil.close(ps);
        }
    }

    public static boolean useStrict(Map<String, Object> data) {
        return data.containsKey("use strict");
    }

    public static List<String> selectFields(Table table, Map<String, Object> row) {
        ArrayList<String> fields = new ArrayList<String>(row.size());
        for (String name : row.keySet()) {
            if (!table.hasField(name)) continue;
            fields.add(name);
        }
        return fields;
    }

    private static List<Map<String, Object>> getEntries(Map<String, Object> o, String entryName) {
        Object value = o.get(entryName);
        if (value == null) {
            return Collections.emptyList();
        }
        List<Object> entries = value instanceof List ? (List<Object>)value : Collections.singletonList(value);
        return entries;
    }

    public static void setId(Map<String, Object> data, Object id, Table mainTable, Map<String, Pair<Table, String>> entryTables) {
        data.put(mainTable.getPrimaryKey().getName(), id);
        for (Map.Entry<String, Pair<Table, String>> e : entryTables.entrySet()) {
            Pair<Table, String> p = e.getValue();
            String master_field = p.getB();
            for (Map entry : (List)data.get(e.getKey())) {
                entry.put(master_field, id);
            }
        }
    }

    public static Object queryPrimaryKey(Map<String, Object> data, Table table, String judgeField, List<String> judgeFields, Connection cn) {
        String pk = table.getPrimaryKeyName();
        if (pk == null) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u6570\u636e\u8868%s\u4e3b\u952e\u5b57\u6bb5\u672a\u8bbe\u7f6e!", "TableUtil_27", "isc-iscb-util", new Object[0]), table.getName()));
        }
        return TableUtil.querySingleValue(cn, table, pk, data, judgeField, judgeFields);
    }

    public static Object querySingleValue(Connection cn, Table table, String fieldName, Map<String, Object> data, String judgeField, List<String> judgeFields) {
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        String sql = TableUtil.generateQuerySingleValueSQL(table, fieldName, data, judgeField, judgeFields, values, types);
        return DbUtil.executeScalar(cn, sql, values, types);
    }

    private static int queryRowCount(Map<String, Object> data, Table table, List<String> judgeFields, Connection cn) {
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) AS C FROM ");
        sql.append(table.getQuotedName()).append(" WHERE ");
        for (String name : judgeFields) {
            TableUtil.appendJudgeField(sql, table, data, values, types, name, values.isEmpty());
        }
        return D.i(DbUtil.executeScalar(cn, sql.toString(), values, types));
    }

    public static boolean update(Connection cn, Table table, Map<String, Object> data, List<String> judgeFields) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(table.getQuotedName());
        sql.append(" SET ");
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            TableUtil.appendSetField(sql, table, e, values, types, judgeFields);
        }
        if (values.isEmpty()) {
            return false;
        }
        sql.append(" WHERE ");
        boolean first = true;
        for (String name : judgeFields) {
            TableUtil.appendJudgeField(sql, table, data, values, types, name, first);
            first = false;
        }
        int afftected = DbUtil.executeUpdate(cn, sql.toString(), values, types);
        return afftected > 0;
    }

    public static boolean delete(Connection cn, Table table, Map<String, Object> data, List<String> judgeFields) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(table.getQuotedName());
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        sql.append(" WHERE ");
        for (String name : judgeFields) {
            TableUtil.appendJudgeField(sql, table, data, values, types, name, values.isEmpty());
        }
        int afftected = DbUtil.executeUpdate(cn, sql.toString(), values, types);
        return afftected > 0;
    }

    private static void appendSetField(StringBuilder sql, Table table, Map.Entry<String, Object> e, List<Object> values, List<Integer> types, List<String> judgeFields) {
        Column f = table.findField(e.getKey());
        if (f == null) {
            return;
        }
        if (f.isPrimaryKey()) {
            return;
        }
        if (judgeFields.contains(f.getName())) {
            return;
        }
        if (values.size() > 0) {
            sql.append(", ");
        }
        sql.append(f.getBinding()).append("=?");
        values.add(f.toSqlParam(e.getValue()));
        types.add(f.getSqlType());
    }

    public static String generateQuerySingleValueSQL(Table table, String fieldName, Map<String, Object> data, String judgeField, List<String> judgeFields, List<Object> values, List<Integer> types) {
        Column field = table.getField(fieldName);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(field.getBinding());
        sql.append(" FROM ").append(table.getQuotedName());
        sql.append(" WHERE ");
        if (judgeField != null) {
            TableUtil.appendJudgeField(sql, table, data, values, types, judgeField, true);
        } else {
            for (String name : judgeFields) {
                TableUtil.appendJudgeField(sql, table, data, values, types, name, values.isEmpty());
            }
        }
        return sql.toString();
    }

    private static void appendJudgeField(StringBuilder sql, Table table, Map<String, Object> o, List<Object> values, List<Integer> types, String field, boolean first) {
        Object value = o.get(field);
        if (value == null) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u76ee\u6807\u5b57\u6bb5\uff08%s\uff09\u503c\u4e3a\u7a7a\uff01", "TableUtil_28", "isc-iscb-util", new Object[0]), field));
        }
        if (!first) {
            sql.append(" AND ");
        }
        Column f = table.getField(field);
        sql.append(f.getBinding()).append("=?");
        values.add(f.toSqlParam(value));
        types.add(f.getSqlType());
    }

    public static String prepareInsertSQL(Table table) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(table.getQuotedName());
        sql.append('(');
        int i = 0;
        while (i < table.getFieldCount()) {
            Column c = table.getField(i);
            if (i > 0) {
                sql.append(',');
            }
            sql.append(c.getBinding());
            ++i;
        }
        sql.append(")VALUES(");
        i = 0;
        while (i < table.getFieldCount()) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append('?');
            ++i;
        }
        sql.append(')');
        return sql.toString();
    }

    public static String prepareInsertSQL(Table table, List<String> fields) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(table.getQuotedName());
        sql.append('(');
        StringBuilder values = new StringBuilder();
        boolean first = true;
        for (String name : fields) {
            if (first) {
                first = false;
            } else {
                sql.append(',');
                values.append(',');
            }
            Column c = table.getField(name);
            sql.append(c.getBinding());
            values.append('?');
        }
        sql.append(")VALUES(").append((CharSequence)values).append(')');
        return sql.toString();
    }

    public static void setParamsForInsert(Table table, PreparedStatement ps, Map<String, Object> data) {
        int i = 0;
        while (i < table.getFieldCount()) {
            Column f = table.getField(i);
            TableUtil.setParameter(ps, data, f, i);
            ++i;
        }
    }

    public static void setParamsForInsert(Table table, PreparedStatement ps, Map<String, Object> data, List<String> fields) {
        int i = 0;
        for (String name : fields) {
            Column f = table.getField(name);
            TableUtil.setParameter(ps, data, f, i);
            ++i;
        }
    }

    public static Object getValue(Map<String, Object> data, Column f) {
        try {
            Object value = f.getDataType().narrow(data.get(f.getName()));
            Object raw = f.getDataType().forSave(value);
            if (raw != null) {
                return raw;
            }
            return TableUtil.getDefaultValue(f);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u8bbe\u7f6e\u5b57\u6bb5[%1$s]\u53c2\u6570\u503c\u5f02\u5e38\uff0c\u5b57\u6bb5\u7c7b\u578b[%2$s],\u539f\u503c:[%3$s],\u539f\u56e0: %4$s", "TableUtil_29", "isc-iscb-util", new Object[0]), f.getName(), f.getDataType(), data.get(f.getName()), e.getMessage()), e);
        }
    }

    private static Object getDefaultValue(Column f) {
        if (f.isNullable()) {
            return null;
        }
        DataType t = f.getDataType();
        if (t instanceof StringType) {
            return " ";
        }
        if (t instanceof IntegerType) {
            return 0;
        }
        if (t instanceof LongType) {
            return 0L;
        }
        if (t instanceof DecimalType) {
            return BigDecimal.ZERO;
        }
        throw new IscBizException(String.format(ResManager.loadKDString("\u5b57\u6bb5\uff08%s\uff09\u8d4b\u503c\u4e0d\u53ef\u4e3a\u7a7a\uff01", "TableUtil_30", "isc-iscb-util", new Object[0]), f.getName()));
    }

    public static void setParameter(PreparedStatement ps, Map<String, Object> data, Column f, int i) {
        try {
            Object value = f.getDataType().narrow(data.get(f.getName()));
            Object raw = f.getDataType().forSave(value);
            if (raw == null) {
                if (!f.isNullable()) {
                    TableUtil.setDefaultValue(ps, f, i);
                } else {
                    ps.setNull(i + 1, f.getSqlType());
                }
            } else {
                ps.setObject(i + 1, raw, f.getSqlType());
            }
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u8bbe\u7f6e\u5b57\u6bb5[%1$s]\u53c2\u6570\u503c\u5f02\u5e38\uff0c\u5b57\u6bb5\u7c7b\u578b[%2$s],\u539f\u503c:[%3$s],\u5f02\u5e38: %4$s", "TableUtil_31", "isc-iscb-util", new Object[0]), f.getName(), f.getDataType(), data.get(f.getName()), e.getMessage()), e);
        }
    }

    private static void setDefaultValue(PreparedStatement ps, Column f, int i) throws SQLException {
        if (f.getDataType() instanceof StringType) {
            ps.setObject(i + 1, (Object)" ", f.getSqlType());
        } else if (f.getDataType() instanceof IntegerType) {
            ps.setObject(i + 1, (Object)0, f.getSqlType());
        } else if (f.getDataType() instanceof LongType) {
            ps.setObject(i + 1, (Object)0L, f.getSqlType());
        } else if (f.getDataType() instanceof DecimalType) {
            ps.setObject(i + 1, (Object)BigDecimal.ZERO, f.getSqlType());
        } else {
            ps.setNull(i + 1, f.getSqlType());
        }
    }

    public static String calcKeys(Map<String, Object> tar, List<String> judgeFields) {
        StringBuilder sb = new StringBuilder();
        for (String key : judgeFields) {
            Object value = tar.get(key);
            if (value == null) {
                throw new IscBizException(String.format(ResManager.loadKDString("\u5019\u9009\u952e\u5b57\u6bb5(%s)\u672a\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e\u548c\u6e90\u8868\u6570\u636e\u3002", "TableUtil_32", "isc-iscb-util", new Object[0]), key));
            }
            sb.append(value).append('\n');
        }
        return sb.toString();
    }

    public static String createTableSQL(Table table, DbType db) {
        StringBuilder sql = new StringBuilder();
        String tableName = db.qualifyTableName(table.getName());
        char quotChar = db.getQuotChar();
        sql.append("CREATE TABLE ").append(quotChar).append(tableName).append(quotChar).append(" (");
        int i = 0;
        while (i < table.getFieldCount()) {
            Column c = table.getField(i);
            if (i > 0) {
                sql.append(',');
            }
            sql.append("\r\n    ");
            sql.append(quotChar).append(db.qualifyColumnName(c.getName())).append(quotChar);
            sql.append(' ').append(db.getDataType(c));
            if (!c.isNullable()) {
                sql.append(" NOT NULL");
            } else {
                sql.append("  NULL  ");
            }
            ++i;
        }
        List<Column> pks = table.getPrimaryKeys();
        if (!pks.isEmpty()) {
            sql.append(",\r\n    CONSTRAINT ");
            String tmp = tableName.toUpperCase(Locale.ENGLISH);
            String constraint = "PK_" + (tmp.startsWith("T_") ? tmp.substring(2) : tmp);
            sql.append(constraint);
            sql.append(" PRIMARY KEY(");
            for (Column c : pks) {
                if (sql.charAt(sql.length() - 1) != '(') {
                    sql.append(", ");
                }
                sql.append(quotChar).append(db.qualifyColumnName(c.getName())).append(quotChar);
            }
            sql.append(" )");
        }
        sql.append("\r\n)");
        return sql.toString();
    }
}

