/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.err.DatabaseError;

public class DbInfo {
    private Connection cn;
    private DatabaseMetaData meta;
    private String schema;
    private String catalog;

    public DbInfo(Connection cn) {
        this.cn = cn;
        try {
            this.init(cn);
        }
        catch (SQLException e) {
            throw DatabaseError.META_QUERY_FAILURE.wrap(e);
        }
    }

    private void init(Connection cn) throws SQLException {
        this.meta = cn.getMetaData();
        String className = this.meta.getClass().getName();
        if (this.isApusicServer(className)) {
            if (this.meta.getDatabaseProductName().equalsIgnoreCase("oracle")) {
                this.schema = (String)DbUtil.executeScalar(cn, "/*dialect*/SELECT USER FROM DUAL");
            }
        } else {
            Connection original = this.meta.getConnection();
            this.schema = Table.getSchema(this.meta);
            this.catalog = original.getCatalog();
        }
    }

    private boolean isApusicServer(String className) {
        return "com.apusic.jdbc.adapter.DatabaseMetaDataHandle".equals(className);
    }

    public Connection getConnection() {
        return this.cn;
    }

    public DatabaseMetaData getMeta() {
        return this.meta;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCatalog() {
        return this.catalog;
    }
}

