/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.server.AbstractSqlCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.err.DatabaseError;

public class ExecuteUpdate
extends AbstractSqlCommandExecutor {
    @Override
    public String getCommand() {
        return "execute_update";
    }

    @Override
    protected ConnectorContext.Operation getOperation() {
        return ConnectorContext.Operation.WRITE;
    }

    @Override
    protected Object exec(ConnectorContext ctx, Connection cn, String sql, Map<String, Object> params) {
        try {
            List values = (List)params.get("values");
            if (values != null) {
                return ExecuteUpdate.execute(cn, sql, values, (List)params.get("types"));
            }
            return ExecuteUpdate.execute(cn, sql);
        }
        catch (SQLException e) {
            throw DatabaseError.SQL_UPDATE_FAILURE.wrap(e);
        }
    }

    private static int execute(Connection cn, String sql) throws SQLException {
        Statement smt = cn.createStatement();
        try {
            int n = smt.executeUpdate(sql);
            return n;
        }
        finally {
            DbUtil.close(smt);
        }
    }

    private static int execute(Connection cn, String sql, List<Object> values, List<Integer> types) throws SQLException {
        PreparedStatement ps = cn.prepareStatement(sql);
        try {
            DbUtil.ensureParameters(values, types);
            DbUtil.setParameters(ps, values, types);
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            DbUtil.close(ps);
        }
    }
}

