/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class Heap<T extends Comparable<?>>
implements Collection<T> {
    public static final String SEPERATOR = ",";
    private ArrayList<T> list = new ArrayList();

    @Override
    public boolean add(T e) {
        this.push(e);
        return true;
    }

    public void push(T e) {
        this.list.add(e);
        Heap.shiftL(this.list, this.list.size() - 1);
    }

    public T pop() {
        Comparable top = (Comparable)this.list.get(0);
        int size = this.list.size() - 1;
        if (size == 0) {
            this.list.clear();
        } else {
            this.list.set(0, (Comparable)this.list.remove(size));
            Heap.shiftR(this.list, 0);
        }
        return (T)top;
    }

    public T top() {
        return (T)(this.list.size() == 0 ? null : (Comparable)this.list.get(0));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (Comparable e : c) {
            this.add((T)e);
        }
        return c.size() > 0;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableCollection(this.list).iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    private static boolean shiftL(ArrayList<Comparable<Object>> list, int i) {
        Comparable<Object> current = list.get(i);
        int index = i;
        while (index > 0) {
            int j = index - 1 >> 1;
            Comparable<Object> node = list.get(j);
            if (current.compareTo(node) > 0) break;
            list.set(index, node);
            index = j;
        }
        list.set(index, current);
        return index != i;
    }

    private static boolean shiftR(ArrayList<Comparable<Object>> list, int i) {
        Comparable<Object> current = list.get(i);
        int index = i;
        int j = (index << 1) + 1;
        int size = list.size();
        while (j < size) {
            Comparable<Object> node2;
            Comparable<Object> node = list.get(j);
            if (j + 1 < size && (node2 = list.get(j + 1)).compareTo(node) < 0) {
                ++j;
                node = node2;
            }
            if (current.compareTo(node) < 0) break;
            list.set(index, node);
            index = j;
            j = (index << 1) + 1;
        }
        list.set(index, current);
        return index != i;
    }
}

