/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReadLockFreeMap<K, V>
implements Map<K, V> {
    private volatile HashMap<K, V> map;

    public ReadLockFreeMap() {
        this(16);
    }

    public ReadLockFreeMap(Map<K, V> map) {
        this.map = new HashMap(map.size() * 2);
        this.map.putAll(map);
    }

    public ReadLockFreeMap(int capacity) {
        this.map = new HashMap(capacity);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    private HashMap<K, V> cloneMap() {
        HashMap<K, V> map = new HashMap<K, V>(this.map.size() + 1);
        map.putAll(this.map);
        return map;
    }

    @Override
    public synchronized V put(K key, V value) {
        HashMap<K, V> map = this.cloneMap();
        V v = map.put(key, value);
        this.map = map;
        return v;
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        V old = this.map.get(key);
        if (old != null) {
            return old;
        }
        this.put(key, value);
        return value;
    }

    public synchronized V intern(K key, V value) {
        V old = this.map.get(key);
        if (old == null) {
            this.put(key, value);
            return value;
        }
        if (old.equals(value)) {
            return old;
        }
        throw new IllegalArgumentException("Key '" + key + "' exists.");
    }

    @Override
    public synchronized V remove(Object key) {
        HashMap<K, V> map = this.cloneMap();
        V v = map.remove(key);
        this.map = map;
        return v;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        HashMap<? extends K, ? extends V> map = this.cloneMap();
        map.putAll(m);
        this.map = map;
    }

    public synchronized void removeAll(Collection<? extends K> keys) {
        HashMap<K, V> map = this.cloneMap();
        for (K key : keys) {
            map.remove(key);
        }
        this.map = map;
    }

    public synchronized void replace(Map<? extends K, ? extends V> m) {
        HashMap<? extends K, ? extends V> map = new HashMap<K, V>();
        map.putAll(m);
        this.map = map;
    }

    @Override
    public synchronized void clear() {
        this.map = new HashMap();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public String toString() {
        return this.map.toString();
    }
}

