/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.dt.i;

import java.nio.charset.Charset;

public class Hex {
    private static byte[] _hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static int[] bits = new int[256];

    static {
        int i = 0;
        while (i < 256) {
            Hex.bits[i] = 255;
            ++i;
        }
        i = 0;
        while (i <= 9) {
            Hex.bits[48 + i] = i;
            ++i;
        }
        i = 0;
        int j = 10;
        while (i <= 5) {
            Hex.bits[97 + i] = j;
            Hex.bits[65 + i] = j++;
            ++i;
        }
    }

    public static boolean isHexString(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumber(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String encode(byte[] data) {
        byte[] buffer = new byte[data.length << 1];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            buffer[j++] = _hex[data[i] >> 4 & 0xF];
            buffer[j++] = _hex[data[i] & 0xF];
            ++i;
        }
        return new String(buffer, Charset.forName("UTF-8"));
    }

    public static byte[] decode(String s) {
        if ((s.length() & 1) != 0) {
            s = "0" + s;
        }
        byte[] data = s.getBytes(Charset.forName("UTF-8"));
        byte[] buffer = new byte[data.length >> 1];
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            int k = bits[data[j++]] << 4;
            if ((k += bits[data[j++]]) > 255) {
                throw new IllegalArgumentException("Invalid hex string! s=" + s);
            }
            buffer[i] = (byte)k;
            ++i;
        }
        return buffer;
    }
}

