/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.c.app;

import java.util.Collection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.flow.core.Logger;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.c.DebuggerBreakpoint;
import kd.isc.iscb.util.flow.core.i.c.app.TraceUtil;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.feature.op.compare.Equals;

public class InvokeApplication
extends Command
implements DebuggerBreakpoint {
    private Application app;

    public InvokeApplication(Application app) {
        super(5000000);
        this.app = app;
    }

    @Override
    public int invoke(ExecutionImpl e) {
        VariableImpl[] vars = this.getVariables(e);
        Object[] values = this.backupVariables(e, vars);
        try {
            TraceUtil.setTag(e);
            this.app.invoke(e);
            return 1;
        }
        catch (Throwable error) {
            e.getRuntime().pushError(error);
            e.bizFailed();
            return 0;
        }
        finally {
            this.checkVariables(e, vars, values);
        }
    }

    private VariableImpl[] getVariables(ExecutionImpl e) {
        Collection<VariableImpl> list = e.getDefine().getAvailableVariables().values();
        VariableImpl[] vars = list.toArray(new VariableImpl[list.size()]);
        return vars;
    }

    private void checkVariables(ExecutionImpl e, VariableImpl[] vars, Object[] values) {
        Logger logger = e.getRuntime().getFlow().getLogger();
        if (!this.needsVariableLog(e, logger)) {
            return;
        }
        int i = 0;
        while (i < vars.length) {
            Object original = values[i];
            VariableImpl v = vars[i];
            Object current = e.get(v);
            if (!Equals.equals(original, current).booleanValue()) {
                DataType type = v.getType();
                String text = String.valueOf(String.format(ResManager.loadKDString("\u53d8\u91cf\uff08%s\uff09\u7684\u5185\u5bb9\u6539\u53d8\u4e86\u3002", "InvokeApplication_3", "isc-iscb-util", new Object[0]), v.getName())) + "\r\n" + String.format(ResManager.loadKDString("\u65b0\u503c\uff1a%s", "InvokeApplication_4", "isc-iscb-util", new Object[0]), StringUtil.trim(type.forJson(current), 8000)) + "\r\n" + String.format(ResManager.loadKDString("\u539f\u503c\uff1a%s", "InvokeApplication_5", "isc-iscb-util", new Object[0]), StringUtil.trim(type.forJson(original), 8000));
                logger.info(e, text);
            }
            ++i;
        }
    }

    private Object[] backupVariables(ExecutionImpl e, VariableImpl[] vars) {
        Logger logger = e.getRuntime().getFlow().getLogger();
        if (!this.needsVariableLog(e, logger)) {
            return null;
        }
        Object[] values = new Object[vars.length];
        int i = 0;
        while (i < vars.length) {
            VariableImpl v = vars[i];
            values[i] = e.get(v);
            ++i;
        }
        return values;
    }

    private boolean needsVariableLog(ExecutionImpl e, Logger logger) {
        return logger != null && e.getRuntime().getLoggerLevel() == Logger.Level.INFO;
    }

    @Override
    public String toString() {
        String name = this.app.toString();
        if (name.startsWith(this.app.getClass().getName())) {
            name = this.app.getClass().getSimpleName();
        }
        return name;
    }
}

