/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.c.trans;

import java.util.ArrayList;
import java.util.List;
import kd.isc.iscb.util.flow.core.Transition;
import kd.isc.iscb.util.flow.core.i.c.trans.AbstractTransit;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.core.i.model.TransitionImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;

public class XorChoice
extends AbstractTransit {
    private TransitionImpl other;
    private List<TransitionImpl> candidates = new ArrayList<TransitionImpl>();

    public XorChoice(NodeImpl node) {
        super(20000000);
        for (TransitionImpl tran : node.getOutGoing()) {
            if (tran.getType() != Transition.Type.NORMAL) continue;
            if (tran.getCondition() != null) {
                this.candidates.add(tran);
                continue;
            }
            this.other = tran;
        }
    }

    @Override
    List<TransitionImpl> findNext(ExecutionImpl e) {
        List<TransitionImpl> targets = XorChoice.testConditions(e, this.candidates);
        return XorChoice.handleOther(targets, this.other);
    }

    static List<TransitionImpl> handleOther(List<TransitionImpl> targets, TransitionImpl other) {
        if (targets.size() == 0) {
            if (other == null) {
                targets = null;
            } else {
                targets.add(other);
            }
        }
        return targets;
    }

    static List<TransitionImpl> testConditions(ExecutionImpl e, List<TransitionImpl> candidates) {
        ArrayList<TransitionImpl> targets = new ArrayList<TransitionImpl>(1);
        for (TransitionImpl tran : candidates) {
            if (!tran.getCondition().test(e)) continue;
            targets.add(tran);
            break;
        }
        return targets;
    }
}

