/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.profile;

import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.FlowTrace;
import kd.isc.iscb.util.flow.core.ProfileLogger;
import kd.isc.iscb.util.flow.core.i.c.Command;

public final class Performance
implements FlowTrace {
    private Command current;
    private long startTime;
    private long beginTime;
    private FlowRuntime runtime;

    public Performance(FlowRuntime runtime) {
        this.runtime = runtime;
        this.beginTime = System.nanoTime();
        ProfileLogger.REF.get().logBegin(runtime);
    }

    @Override
    public void begin(Execution e) {
        this.current = e.current();
        this.startTime = System.nanoTime();
    }

    @Override
    public boolean end(Execution e, boolean success) {
        long endTime = System.nanoTime();
        String message = e + ": \t" + this.current + ", " + (endTime - this.startTime) / 1000L + "us.";
        ProfileLogger.REF.get().logExecute(e, message, success);
        return false;
    }

    @Override
    public void endFlow() {
        long now = System.nanoTime();
        String message = "total: " + (now - this.beginTime) / 1000L + " us.";
        ProfileLogger.REF.get().logEnd(this.runtime, message);
    }
}

