/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.trace;

import java.util.ArrayList;
import java.util.List;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.c.DebuggerBreakpoint;
import kd.isc.iscb.util.flow.core.i.c.composite.CallSubFlow;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.trace.Line;

public class NodeLineCollector {
    public static List<Line> collectLines(Flow flow) {
        ArrayList<Line> lines = new ArrayList<Line>();
        NodeLineCollector.collectLines((NodeImpl)flow.getRoot(), 0, lines);
        return lines;
    }

    private static void collectLines(NodeImpl node, int tab, List<Line> lines) {
        if (node.getParent() == null) {
            lines.add(new Line(String.valueOf(node.getFlow().getTitle()) + " {", node, 0, tab));
            NodeLineCollector.collectChildrenLines(node, tab + 1, lines);
            lines.add(new Line("}", tab));
        } else {
            NodeLineCollector.collectCommandLines(node, tab, lines);
            NodeLineCollector.collectSubFlowLines(node, tab + 1, lines);
            NodeLineCollector.collectChildrenLines(node, tab + 1, lines);
        }
    }

    private static void collectCommandLines(NodeImpl node, int tab, List<Line> lines) {
        int i = 0;
        int j = node.getCommandCount();
        while (i < j) {
            Command cmd = node.getCommand(i);
            if (cmd instanceof DebuggerBreakpoint) {
                String text = String.valueOf(node.getTitle()) + "@" + node.getId() + ";";
                lines.add(new Line(text, node, i, tab));
                break;
            }
            ++i;
        }
    }

    private static void collectChildrenLines(NodeImpl node, int tab, List<Line> lines) {
        for (String id : node.getGraph().wfsVisit()) {
            NodeImpl child = node.getFlow().getNode(id);
            NodeLineCollector.collectLines(child, tab, lines);
        }
    }

    private static void collectSubFlowLines(NodeImpl node, int tab, List<Line> lines) {
        int i = 0;
        int j = node.getCommandCount();
        while (i < j) {
            Flow flow;
            Command cmd = node.getCommand(i);
            if (cmd instanceof CallSubFlow && (flow = ((CallSubFlow)cmd).getLoader().getFlow(null)) != null) {
                NodeLineCollector.collectLines((NodeImpl)flow.getRoot(), tab, lines);
            }
            ++i;
        }
    }
}

