/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.misc.Hash;

public class Cipher {
    public static final String DEFAULT_KEY = System.getProperty("__ISC_DEFAULT_KEY", "9E678DAA");
    public static final String DEFAULT_ALGO = System.getProperty("__ISC_DEFAULT_ALGO", "AES");

    private Cipher() {
    }

    public static String encrypt(String s) {
        return Cipher.encrypt(s, DEFAULT_KEY);
    }

    public static String decrypt(String c) {
        return Cipher.decrypt(c, DEFAULT_KEY);
    }

    public static String encrypt(String s, String key) {
        try {
            byte[] tmp = Cipher.encrypt(s.getBytes(D.UTF_8), key);
            return new String(Base64.encode(tmp), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IscBizException(e);
        }
    }

    public static String decrypt(String c, String key) {
        try {
            byte[] tmp = Base64.decode(c.getBytes(D.UTF_8));
            return new String(Cipher.decrypt(tmp, key), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IscBizException(e);
        }
    }

    public static byte[] encrypt(byte[] data, String key) {
        return Cipher.transform(data, key, 1);
    }

    public static byte[] decrypt(byte[] data, String key) {
        return Cipher.transform(data, key, 2);
    }

    private static byte[] transform(byte[] data, String key, int mode) {
        try {
            javax.crypto.Cipher ci = Cipher.getCipher(mode, key);
            return ci.doFinal(data);
        }
        catch (Exception e) {
            if (e instanceof BadPaddingException) {
                throw new IscBizException(ResManager.loadKDString("\u5bc6\u7801\u9519\u8bef\uff01", "Cipher_0", "isc-iscb-util", new Object[0]), e);
            }
            throw D.e(e);
        }
    }

    private static javax.crypto.Cipher getCipher(int mode, String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        SecretKeySpec spec = Cipher.string2key(key);
        javax.crypto.Cipher ci = javax.crypto.Cipher.getInstance(DEFAULT_ALGO);
        ci.init(mode, spec);
        return ci;
    }

    private static SecretKeySpec string2key(String key) {
        try {
            byte[] bkey = Hash.md5(key.getBytes(D.UTF_8));
            return new SecretKeySpec(bkey, DEFAULT_ALGO);
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }
}

