/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc.mem.c;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.misc.mem.ClassSizeInfo;
import kd.isc.iscb.util.misc.mem.ObjectSizeCalculator;
import kd.isc.iscb.util.misc.mem.c.DefaultClassSizeInfo;

public class SetClassSizeInfo
implements ClassSizeInfo {
    private final long fixedObjectSize;
    private final long elementExtObjectSize;
    private final Class<?> clazz;

    public SetClassSizeInfo(Class<?> clazz) {
        if (!(HashSet.class.isAssignableFrom(clazz) || LinkedHashSet.class.isAssignableFrom(clazz) || TreeSet.class.isAssignableFrom(clazz))) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString("\u7c7b\uff08%s\uff09\u4e0d\u662f\u652f\u6301\u7684Set\u7c7b\u578b\u3002", "SetClassSizeInfo_2", "isc-iscb-util", new Object[0]), clazz.getName()));
        }
        this.clazz = clazz;
        this.fixedObjectSize = this.getFixedObjectSize(clazz);
        this.elementExtObjectSize = this.getElementExtObjectSize(clazz);
    }

    @Override
    public Class<?> forClass() {
        return this.clazz;
    }

    @Override
    public void visit(Object obj, ObjectSizeCalculator calc, int level) {
        Set c = (Set)obj;
        long objectSize = (long)c.size() * this.elementExtObjectSize + this.fixedObjectSize;
        calc.increaseSize(objectSize);
        this.visitComponents(c, calc, level + 1);
    }

    private void visitComponents(Set<?> c, ObjectSizeCalculator calc, int level) {
        calc.checkLevel(level);
        for (Object e : c) {
            calc.visit(e, level);
        }
    }

    private long getElementExtObjectSize(Class<?> clazz) {
        if (LinkedHashSet.class.isAssignableFrom(clazz)) {
            return (long)(ObjectSizeCalculator.OBJECT_HEADER_SIZE * 2 + ObjectSizeCalculator.REFERENCE_SIZE * 5) + ObjectSizeCalculator.getPrimitiveFieldSize(Integer.TYPE);
        }
        if (TreeSet.class.isAssignableFrom(clazz)) {
            return (long)(ObjectSizeCalculator.OBJECT_HEADER_SIZE * 2 + ObjectSizeCalculator.REFERENCE_SIZE * 4) + ObjectSizeCalculator.getPrimitiveFieldSize(Boolean.TYPE);
        }
        return (long)(ObjectSizeCalculator.OBJECT_HEADER_SIZE * 2 + ObjectSizeCalculator.REFERENCE_SIZE * 3) + ObjectSizeCalculator.getPrimitiveFieldSize(Integer.TYPE);
    }

    private long getFixedObjectSize(Class<?> clazz) {
        long objectSize = new DefaultClassSizeInfo(clazz).getObjectSize();
        objectSize = LinkedHashSet.class.isAssignableFrom(clazz) ? (objectSize += new DefaultClassSizeInfo(LinkedHashMap.class).getObjectSize()) : (TreeSet.class.isAssignableFrom(clazz) ? (objectSize += new DefaultClassSizeInfo(TreeMap.class).getObjectSize()) : (objectSize += new DefaultClassSizeInfo(HashMap.class).getObjectSize()));
        return objectSize + (long)ObjectSizeCalculator.OBJECT_HEADER_SIZE + (long)ObjectSizeCalculator.REFERENCE_SIZE;
    }
}

