/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script;

import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import kd.isc.iscb.util.debugger.DebuggableResource;
import kd.isc.iscb.util.debugger.DebuggableRuntime;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.mem.MemoryControl;
import kd.isc.iscb.util.misc.mem.MemoryUtil;
import kd.isc.iscb.util.misc.mem.RuntimeContext;
import kd.isc.iscb.util.script.CancelSignal;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.ScriptBinding;
import kd.isc.iscb.util.script.TimeoutException;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.context.MapContext;
import kd.isc.iscb.util.script.context.ReadOnlyContext;
import kd.isc.iscb.util.script.parser.Program;

public class LifeScriptContext
implements ScriptContext,
RuntimeContext,
DebuggableRuntime {
    private boolean isMemCtrlEnabled;
    private Map<String, Object> bindings;
    private Program program;
    private long startTime;
    private int signal = 0;

    public LifeScriptContext() {
        this.bindings = new HashMap<String, Object>();
        this.isMemCtrlEnabled = MemoryControl.REF.get().isEnabled();
    }

    public LifeScriptContext(boolean memoryControlEnabled) {
        this.bindings = new HashMap<String, Object>();
        this.isMemCtrlEnabled = memoryControlEnabled;
    }

    public LifeScriptContext(Map<String, Object> bindings) {
        this.bindings = bindings;
        this.isMemCtrlEnabled = MemoryControl.REF.get().isEnabled();
    }

    public LifeScriptContext(Map<String, Object> bindings, boolean memoryControlEnabled) {
        this.bindings = bindings;
        this.isMemCtrlEnabled = memoryControlEnabled;
    }

    public LifeScriptContext(Context ctx) {
        this.bindings = new ScriptBinding(ctx);
        this.isMemCtrlEnabled = MemoryControl.REF.get().isEnabled();
    }

    public LifeScriptContext(Context ctx, boolean memoryControlEnabled) {
        this.bindings = new ScriptBinding(ctx);
        this.isMemCtrlEnabled = memoryControlEnabled;
    }

    @Override
    public Object getAttribute(String name) {
        return this.getAttribute(name, 0);
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this.bindings.get(name);
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        return this.bindings.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        this.bindings.put(name, value);
    }

    @Override
    public int getAttributesScope(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    @Override
    public Bindings getBindings(int scope) {
        if (this.bindings instanceof Bindings) {
            return (Bindings)this.bindings;
        }
        return new ScriptBinding(new MapContext(this.bindings));
    }

    @Override
    public Writer getErrorWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer getWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Integer> getScopes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setErrorWriter(Writer writer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReader(Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWriter(Writer writer) {
        throw new UnsupportedOperationException();
    }

    public void setProgram(Program program) {
        if (this.program != null) {
            throw new UnsupportedOperationException("Program is set.");
        }
        this.program = program;
        this.startTime = LifeScriptEngine.getNow();
    }

    public void checkTimeout() {
        CancelSignal.REF.get().check();
        this.innerCheckTimeout();
        MemoryUtil.checkContextMemorySize(this);
    }

    public void setMemoryControlEnabled(boolean b) {
        this.isMemCtrlEnabled = b;
    }

    @Override
    public boolean isMemoryControlEnabled() {
        return this.isMemCtrlEnabled;
    }

    private void innerCheckTimeout() {
        Program program = this.program;
        if (program == null) {
            return;
        }
        long timeout = program.getTimeout();
        if (timeout == Long.MAX_VALUE) {
            return;
        }
        long now = LifeScriptEngine.getNow();
        long executeTime = now - this.startTime;
        if (executeTime > timeout) {
            throw new TimeoutException(executeTime, timeout);
        }
    }

    public void unsetProgram(Program program) {
        if (this.program != program) {
            throw new UnsupportedOperationException("Program is unmatched.");
        }
        this.program = null;
    }

    public Program getProgram() {
        return this.program;
    }

    void setSignal(int signal) {
        if (this.signal != 0) {
            throw new IscBizException("signal=" + signal);
        }
        this.signal = signal;
    }

    void clearSignal() {
        this.signal = 0;
    }

    int getSignal() {
        return this.signal;
    }

    int takeSignal() {
        if (this.signal == 0) {
            return 0;
        }
        if (this.signal < 0) {
            return ++this.signal;
        }
        return this.signal--;
    }

    @Override
    public DebuggableResource getResource() {
        return this.program;
    }

    @Override
    public Context getContext() {
        return new ReadOnlyContext(new MapContext(this.bindings));
    }
}

