/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.date;

import java.text.ParseException;
import java.util.Date;
import javax.script.ScriptContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DataTypeError;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.core.AbstractToolKit;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.feature.tool.date.DateAdd;
import kd.isc.iscb.util.script.feature.tool.date.DateDiff;
import kd.isc.iscb.util.script.feature.tool.date.DateFormat;
import kd.isc.iscb.util.script.feature.tool.date.DateNew;
import kd.isc.iscb.util.script.feature.tool.date.DatePart;
import kd.isc.iscb.util.script.feature.tool.date.DateRange;
import kd.isc.iscb.util.script.feature.tool.date.Days;
import kd.isc.iscb.util.script.feature.tool.date.FirstDay;
import kd.isc.iscb.util.script.feature.tool.date.GetTime;
import kd.isc.iscb.util.script.feature.tool.date.HalfYear;
import kd.isc.iscb.util.script.feature.tool.date.Hours;
import kd.isc.iscb.util.script.feature.tool.date.LastDay;
import kd.isc.iscb.util.script.feature.tool.date.Milliseconds;
import kd.isc.iscb.util.script.feature.tool.date.Minutes;
import kd.isc.iscb.util.script.feature.tool.date.Months;
import kd.isc.iscb.util.script.feature.tool.date.Now;
import kd.isc.iscb.util.script.feature.tool.date.Quarters;
import kd.isc.iscb.util.script.feature.tool.date.Seconds;
import kd.isc.iscb.util.script.feature.tool.date.ToTimeStamp;
import kd.isc.iscb.util.script.feature.tool.date.Today;
import kd.isc.iscb.util.script.feature.tool.date.Weeks;
import kd.isc.iscb.util.script.feature.tool.date.Years;
import kd.isc.iscb.util.script.util.DummyIdentifier;

public class DateToolKit
extends AbstractToolKit
implements NativeFunction {
    public static final Identifier YEAR = new DummyIdentifier("YEAR");
    public static final Identifier QUARTER = new DummyIdentifier("QUARTER");
    public static final Identifier HALFYEAR = new DummyIdentifier("HALFYEAR");
    public static final Identifier MONTH = new DummyIdentifier("MONTH");
    public static final Identifier DAY = new DummyIdentifier("DAY");
    public static final Identifier HOUR = new DummyIdentifier("HOUR");
    public static final Identifier MINUTE = new DummyIdentifier("MINUTE");
    public static final Identifier SECOND = new DummyIdentifier("SECOND");
    public static final Identifier MILLISECOND = new DummyIdentifier("MILLISECOND");
    public static final Identifier WEEK_OF_YEAR = new DummyIdentifier("WEEK_OF_YEAR");
    public static final Identifier WEEK_OF_MONTH = new DummyIdentifier("WEEK_OF_MONTH");
    public static final Identifier DAY_OF_YEAR = new DummyIdentifier("DAY_OF_YEAR");
    public static final Identifier DAY_OF_WEEK = new DummyIdentifier("DAY_OF_WEEK");
    public static final Identifier WEEK = new DummyIdentifier("WEEK");

    public DateToolKit() {
        this.register(new DateNew());
        this.register(DateDiff.INS);
        this.register(DateAdd.INS);
        this.register(DatePart.INS);
        this.register(new DateFormat());
        this.register(new Now());
        this.register(new Today());
        this.register(FirstDay.INS);
        this.register(LastDay.INS);
        this.register(DateRange.INS);
        this.register(new GetTime());
    }

    @Override
    public boolean isFor(Object object) {
        return object instanceof Date;
    }

    @Override
    public void registerOtherElements(LifeScriptEngine engine) {
        super.registerOtherElements(engine);
        engine.register("$R", (Object)DateRange.INS);
        engine.register("$\u4eca\u5929", (Object)DateRange.RANGE_TODAY);
        engine.register("$TODAY", (Object)DateRange.RANGE_TODAY);
        engine.register("$\u6628\u5929", (Object)DateRange.RANGE_YESTERDAY);
        engine.register("$YESTERDAY", (Object)DateRange.RANGE_YESTERDAY);
        engine.register("$\u660e\u5929", (Object)DateRange.RANGE_TOMORROW);
        engine.register("$TOMORROW", (Object)DateRange.RANGE_TOMORROW);
        engine.register("$\u672c\u5468", (Object)DateRange.RANGE_THIS_WEEK);
        engine.register("$\u672c\u9031", (Object)DateRange.RANGE_THIS_WEEK);
        engine.register("$THIS_WEEK", (Object)DateRange.RANGE_THIS_WEEK);
        engine.register("$\u4e0a\u5468", (Object)DateRange.RANGE_LAST_WEEK);
        engine.register("$\u4e0a\u9031", (Object)DateRange.RANGE_LAST_WEEK);
        engine.register("$LAST_WEEK", (Object)DateRange.RANGE_LAST_WEEK);
        engine.register("$NEXT_WEEK", (Object)DateRange.RANGE_NEXT_WEEK);
        engine.register("$\u4e0b\u5468", (Object)DateRange.RANGE_NEXT_WEEK);
        engine.register("$\u4e0b\u9031", (Object)DateRange.RANGE_NEXT_WEEK);
        engine.register("$\u672c\u6708", (Object)DateRange.RANGE_THIS_MONTH);
        engine.register("$THIS_MONTH", (Object)DateRange.RANGE_THIS_MONTH);
        engine.register("$\u4e0a\u6708", (Object)DateRange.RANGE_LAST_MONTH);
        engine.register("$LAST_MONTH", (Object)DateRange.RANGE_LAST_MONTH);
        engine.register("$\u4e0b\u6708", (Object)DateRange.RANGE_NEXT_MONTH);
        engine.register("$NEXT_MONTH", (Object)DateRange.RANGE_NEXT_MONTH);
        engine.register("$\u4eca\u5e74", (Object)DateRange.RANGE_THIS_YEAR);
        engine.register("$THIS_YEAR", (Object)DateRange.RANGE_THIS_YEAR);
        engine.register("$\u53bb\u5e74", (Object)DateRange.RANGE_LAST_YEAR);
        engine.register("$LAST_YEAR", (Object)DateRange.RANGE_LAST_YEAR);
        engine.register("$\u660e\u5e74", (Object)DateRange.RANGE_NEXT_YEAR);
        engine.register("$NEXT_YEAR", (Object)DateRange.RANGE_NEXT_YEAR);
        engine.register("$\u672c\u5b63\u5ea6", (Object)DateRange.RANGE_THIS_QUARTER);
        engine.register("$THIS_QUARTER", (Object)DateRange.RANGE_THIS_QUARTER);
        engine.register("$\u4e0a\u5b63\u5ea6", (Object)DateRange.RANGE_LAST_QUARTER);
        engine.register("$LAST_QUARTER", (Object)DateRange.RANGE_LAST_QUARTER);
        engine.register("$\u4e0b\u5b63\u5ea6", (Object)DateRange.RANGE_NEXT_QUARTER);
        engine.register("$NEXT_QUARTER", (Object)DateRange.RANGE_NEXT_QUARTER);
        engine.register("NOW", (Object)Now.SYS_VARIABLE);
        engine.register("\u73b0\u5728", (Object)Now.SYS_VARIABLE);
        engine.register("TODAY", (Object)Today.SYS_VARIABLE);
        engine.register("\u4eca\u5929", (Object)Today.SYS_VARIABLE);
        Years years = new Years();
        engine.register("Years", (Object)years);
        engine.register("Year", (Object)years);
        engine.register("\u5e74", (Object)years);
        Months months = new Months();
        engine.register("Months", (Object)months);
        engine.register("Month", (Object)months);
        engine.register("\u6708", (Object)months);
        Quarters quarters = new Quarters();
        engine.register("Quarters", (Object)quarters);
        engine.register("Quarter", (Object)quarters);
        engine.register("\u5b63\u5ea6", (Object)quarters);
        HalfYear halfYear = new HalfYear();
        engine.register("HalfYears", (Object)halfYear);
        engine.register("HalfYear", (Object)halfYear);
        engine.register("\u534a\u5e74", (Object)halfYear);
        engine.register("Days", (Object)Days.INS);
        engine.register("Day", (Object)Days.INS);
        engine.register("\u5929", (Object)Days.INS);
        engine.register("\u65e5", (Object)Days.INS);
        engine.register("Weeks", (Object)Weeks.INS);
        engine.register("Week", (Object)Weeks.INS);
        engine.register("\u661f\u671f", (Object)Weeks.INS);
        engine.register("\u5468", (Object)Weeks.INS);
        engine.register("\u9031", (Object)Weeks.INS);
        Hours hours = new Hours();
        engine.register("Hours", (Object)hours);
        engine.register("Hour", (Object)hours);
        engine.register("\u5c0f\u65f6", (Object)hours);
        engine.register("\u65f6", (Object)hours);
        Minutes minutes = new Minutes();
        engine.register("Minutes", (Object)minutes);
        engine.register("Minute", (Object)minutes);
        engine.register("\u5206\u949f", (Object)minutes);
        engine.register("\u5206", (Object)minutes);
        Seconds seconds = new Seconds();
        engine.register("Seconds", (Object)seconds);
        engine.register("Second", (Object)seconds);
        engine.register("\u79d2\u949f", (Object)seconds);
        engine.register("\u79d2", (Object)seconds);
        Milliseconds milliseconds = new Milliseconds();
        engine.register("Milliseconds", (Object)milliseconds);
        engine.register("Millisecond", (Object)milliseconds);
        engine.register("\u6beb\u79d2", (Object)milliseconds);
        engine.register(YEAR);
        engine.register(HALFYEAR);
        engine.register(QUARTER);
        engine.register(MONTH);
        engine.register(WEEK);
        engine.register(DAY);
        engine.register("DATE", (Object)DAY);
        engine.register(HOUR);
        engine.register(MINUTE);
        engine.register(SECOND);
        engine.register(WEEK_OF_YEAR);
        engine.register(WEEK_OF_MONTH);
        engine.register(DAY_OF_WEEK);
        engine.register(DAY_OF_YEAR);
        engine.register(MILLISECOND);
        engine.register(new ToTimeStamp());
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        try {
            return DateNew.parse(args);
        }
        catch (ParseException e) {
            throw DataTypeError.INVALID_DATE_STRING.create(e, D.s(args[0]));
        }
    }
}

