/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.hash.mac;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.script.feature.tool.hash.mac.HmacFuntion;

public enum HmacAlgorithm {
    HmacMD5("HmacMD5"),
    HmacSHA1("HmacSHA1"),
    HmacSHA256("HmacSHA256"),
    HmacSHA384("HmacSHA384"),
    HmacSHA512("HmacSHA512");

    private final String value;

    private HmacAlgorithm(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public HmacFuntion function() {
        return new HmacFuntion(this);
    }

    public byte[] digest(byte[] data, byte[] key) {
        Mac mac = this.createMac(this.getValue());
        SecretKeySpec signingKey = new SecretKeySpec(key, this.getValue());
        this.initMac(mac, signingKey);
        return mac.doFinal(data);
    }

    private void initMac(Mac mac, SecretKeySpec signingKey) {
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw CommonError.INVALID_HASH_INIT_KEY.wrap(e);
        }
    }

    private Mac createMac(String algorithm) {
        try {
            return Mac.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw CommonError.NO_SUCH_HASH_ALGO.create(e, algorithm);
        }
    }
}

