/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.core.NativeFunction;

public class Abs
implements NativeFunction {
    @Override
    public String name() {
        return "abs";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Number n = (Number)args[0];
        if (n == null) {
            return null;
        }
        if (n instanceof Integer) {
            return Math.abs(n.intValue());
        }
        if (n instanceof Double) {
            return Math.abs(n.doubleValue());
        }
        if (n instanceof Long) {
            return Math.abs(n.longValue());
        }
        if (n instanceof Float) {
            return Float.valueOf(Math.abs(n.floatValue()));
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).abs();
        }
        if (n instanceof BigInteger) {
            return ((BigInteger)n).abs();
        }
        throw new UnsupportedOperationException(n.getClass().getName());
    }
}

