/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.CryptException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.ACL;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.EventLogCleaner;
import kd.isc.connector.eas.IscLoggerFactory;
import kd.isc.connector.eas.QueryStringCacheCleaner;
import kd.isc.connector.eas.ResultCleaner;
import kd.isc.connector.eas.Util;
import kd.isc.connector.eas.e.CallService;
import kd.isc.connector.eas.e.CheckInitState;
import kd.isc.connector.eas.e.CreateAttachment;
import kd.isc.connector.eas.e.DoBatchBizActionService;
import kd.isc.connector.eas.e.DoBizAction;
import kd.isc.connector.eas.e.DoDataAction;
import kd.isc.connector.eas.e.EasAttachEvents;
import kd.isc.connector.eas.e.EasCallDataHandler;
import kd.isc.connector.eas.e.EasCallbackHandler;
import kd.isc.connector.eas.e.EasDetachEvents;
import kd.isc.connector.eas.e.EasEventHandler;
import kd.isc.connector.eas.e.GetEntityInfo;
import kd.isc.connector.eas.e.GetEntityList;
import kd.isc.connector.eas.e.GetEnumInfo;
import kd.isc.connector.eas.e.GetEnumList;
import kd.isc.connector.eas.e.GetIndexInfo;
import kd.isc.connector.eas.e.GetMetaList;
import kd.isc.connector.eas.e.GetServiceInfo;
import kd.isc.connector.eas.e.GetTableInfo;
import kd.isc.connector.eas.e.GetWorkflowState;
import kd.isc.connector.eas.e.InitEnv;
import kd.isc.connector.eas.e.InitiateWorkflow;
import kd.isc.connector.eas.e.InvokeBotp;
import kd.isc.connector.eas.e.IsAttachmentChanged;
import kd.isc.connector.eas.e.IscBizListener;
import kd.isc.connector.eas.e.PushDataJobHandler;
import kd.isc.connector.eas.e.PushPermission;
import kd.isc.connector.eas.e.QueryWorkflowState;
import kd.isc.connector.eas.e.RemoteDeploy;
import kd.isc.connector.eas.e.RemoteUndeploy;
import kd.isc.connector.eas.e.RepushEventData;
import kd.isc.connector.eas.e.RetrieveAttachList;
import kd.isc.connector.eas.e.RetrieveAttachment;
import kd.isc.connector.eas.e.RetrieveData;
import kd.isc.connector.eas.e.TestCommand;
import kd.isc.connector.eas.notify.NotifyUtil;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.server.CommandDispatcher;
import kd.isc.iscb.util.connector.server.CommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectionProxy;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.ContextFactory;
import kd.isc.iscb.util.connector.server.DefaultTaskExecutor;
import kd.isc.iscb.util.connector.server.SerializableResultManager;
import kd.isc.iscb.util.connector.server.TaskExecutor;
import kd.isc.iscb.util.data.Counter;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Logger;
import kd.isc.iscb.util.script.encoding.EncryptUtil;
import kd.isc.iscb.util.script.misc.log.LoggerFactory;

public class EasContextFactory
implements ContextFactory {
    private static final String ERROR_MESSAGE = "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u3002";
    public static final int TOKEN_TIME_OUT = 300000;
    private static final Counter DEPLOY_COUNTER = new Counter(720000, 120);
    private static Map<String, String> cache = Collections.synchronizedMap(new HashMap());
    private static final Map<String, EventLogCleaner> eventLogCleaners = new HashMap<String, EventLogCleaner>();
    private static final Map<String, ResultCleaner> cleaners = new HashMap<String, ResultCleaner>();

    static {
        TaskExecutor.INSTANCE.set((Object)new DefaultTaskExecutor());
        IscBizListener listener = new IscBizListener();
        EasContextFactory.initQueryCacheCleaner();
        try {
            ServiceManagerFactory.getServiceManager().registerService((IServiceAdapter)listener);
            ServiceManagerFactory.getServiceManager().enableService(listener.getName());
            EasContext.getErrLogger().info((Object)"kd.isc.connector.eas.e.IscBizListener \u4e8b\u4ef6\u76d1\u542c\u542f\u7528\u6210\u529f!");
        }
        catch (CannotCreateServiceManagerException e) {
            EasContext.getErrLogger().warn((Object)"kd.isc.connector.eas.e.IscBizListener \u4e8b\u4ef6\u76d1\u542c\u542f\u7528\u5931\u8d25!", (Throwable)e);
        }
    }

    public ConnectorContext parseURL(String URL2, String queryString, Map<String, Object> params) {
        String protocal = URL2.substring(0, URL2.indexOf("://"));
        if (queryString.startsWith("deploy.")) {
            String dataCenter = URL2.substring(URL2.lastIndexOf(47) + 1);
            String hash = EasContextFactory.checkForDeploy(dataCenter, queryString);
            return new EasContext(dataCenter, "00000000-0000-0000-0000-00000000000013B7DE7F", queryString, protocal, hash, null);
        }
        Map<String, Object> auth = EasContextFactory.parseURL(URL2, queryString);
        EasContextFactory.checkTimestamp(auth, params);
        String dataCenter = D.s((Object)auth.get("d"));
        String userId = EasContextFactory.checkLoginInfo(auth, dataCenter);
        String key = D.s((Object)auth.get("key"));
        return new EasContext(dataCenter, userId, queryString, protocal, null, key);
    }

    public List<CommandExecutor> init(Map<String, String> config) {
        cache.clear();
        this.setLogger();
        ACL.init(config);
        ACL.initFromDB();
        return this.getExecutors();
    }

    private void setLogger() {
        CommandDispatcher.setLogger((Logger)new Logger(){

            public void error(String message, Throwable e) {
                EasContext.getErrLogger().error((Object)message, e);
            }
        });
        if (!LoggerFactory.REF.isInitiated()) {
            LoggerFactory.REF.set((Object)new IscLoggerFactory());
        }
    }

    private List<CommandExecutor> getExecutors() {
        ArrayList<CommandExecutor> list = new ArrayList<CommandExecutor>();
        list.add((CommandExecutor)new TestCommand());
        list.add((CommandExecutor)new GetEntityList());
        list.add((CommandExecutor)new GetEntityInfo());
        list.add((CommandExecutor)new GetEnumList());
        list.add((CommandExecutor)new GetEnumInfo());
        list.add((CommandExecutor)new GetMetaList());
        list.add((CommandExecutor)new GetTableInfo());
        list.add((CommandExecutor)new GetServiceInfo());
        list.add((CommandExecutor)new GetIndexInfo());
        list.add(new RetrieveData());
        list.add((CommandExecutor)new DoBizAction());
        list.add((CommandExecutor)new DoDataAction());
        list.add((CommandExecutor)new EasAttachEvents());
        list.add((CommandExecutor)new EasDetachEvents());
        list.add((CommandExecutor)new EasCallDataHandler());
        list.add((CommandExecutor)new RemoteDeploy());
        list.add((CommandExecutor)new PushPermission());
        list.add((CommandExecutor)new CallService());
        list.add((CommandExecutor)new RepushEventData());
        list.add((CommandExecutor)new InitEnv());
        list.add((CommandExecutor)new CheckInitState());
        list.add((CommandExecutor)new EasCallbackHandler());
        list.add((CommandExecutor)new EasEventHandler());
        list.add(new RetrieveAttachment());
        list.add((CommandExecutor)new CreateAttachment());
        list.add((CommandExecutor)new IsAttachmentChanged());
        list.add((CommandExecutor)new RetrieveAttachList());
        list.add((CommandExecutor)new InvokeBotp());
        list.add((CommandExecutor)new QueryWorkflowState());
        list.add((CommandExecutor)new InitiateWorkflow());
        list.add((CommandExecutor)new GetWorkflowState());
        list.add((CommandExecutor)new RemoteUndeploy());
        list.add((CommandExecutor)new DoBatchBizActionService());
        return list;
    }

    public static boolean checkUrlValid(String dataCenter, String queryString) {
        try {
            if (queryString.startsWith("deploy.")) {
                EasContextFactory.checkForDeploy(dataCenter, queryString);
            } else {
                EasContextFactory.checkUserInfo(dataCenter, queryString);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String checkForDeploy(String dataCenter, String queryString) {
        EasContextFactory.checkDeployFrequency();
        String data = queryString.substring(queryString.indexOf(46) + 1);
        cache.clear();
        String key = EasContextFactory.getDeployKey(dataCenter);
        Map m = (Map)Json.toObject((String)Cipher.decrypt((String)data, (String)key));
        EasContextFactory.checkTimestamp(D.l(m.get("t")));
        return D.s(m.get("h"));
    }

    private static void checkDeployFrequency() {
        DEPLOY_COUNTER.inc(1);
        if (DEPLOY_COUNTER.get() > 120) {
            throw new IscBizException("\u90e8\u7f72\u6b21\u6570\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\uff08\u6bcf\u5929\u4e0d\u8d85\u8fc7120\u6b21\uff09\uff01");
        }
    }

    public static String getDeployKey(String dataCenter) {
        String[] info = EasContextFactory.getUserInfo("00000000-0000-0000-0000-00000000000013B7DE7F", dataCenter);
        String key = info.length == 1 ? Cipher.DEFAULT_KEY : info[1];
        return key;
    }

    private static boolean checkUserInfo(String dataCenter, String queryString) throws IllegalAccessException, BOSException, CryptException {
        String key = ACL.getAccessKey(dataCenter);
        String text = Cipher.decrypt((String)queryString, (String)key);
        Map auth = (Map)Json.toObject((String)text);
        String user = D.s(auth.get("u"));
        String password = D.s(auth.get("p"));
        String[] info = EasContextFactory.getUserInfo(user, dataCenter);
        if (info.length == 1) {
            if (password == null) {
                return true;
            }
            throw new IscBizException(ERROR_MESSAGE);
        }
        return EasContextFactory.isEncrytPwdEqual(password, info, dataCenter);
    }

    private static String checkLoginInfo(Map<String, Object> auth, String dataCenter) {
        String user = D.s((Object)auth.get("u"));
        String password = D.s((Object)auth.get("p"));
        String[] info = EasContextFactory.getUserInfo(user, dataCenter);
        if (info.length == 1) {
            if (password == null) {
                return info[0];
            }
            throw new IscBizException(ERROR_MESSAGE);
        }
        if (!EasContextFactory.isEncrytPwdEqual(password, info, dataCenter)) {
            throw new IscBizException(ERROR_MESSAGE);
        }
        return info[0];
    }

    public static boolean isEncrytPwdEqual(String password, String[] info, String dataCenter) {
        boolean isEqual = EasContextFactory.checkPwdWithoutException(password, info, dataCenter);
        if (isEqual) {
            return true;
        }
        String user = info[0];
        if (user != null) {
            int length = user.length();
            int avg = length / 3;
            int hidden = length - avg * 2;
            String beginStr = user.substring(0, avg);
            String endStr = user.substring(avg + hidden);
            user = String.valueOf(beginStr) + "******" + endStr;
        }
        throw new IscBizException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u5f53\u524d\u7528\u6237" + user + "\u6240\u7528\u52a0\u5bc6\u7b97\u6cd5\u4e3a\uff1a" + Util.getAlgorithm(dataCenter, info[0]));
    }

    public static boolean checkPwdWithoutException(String password, String[] info, String dataCenter) {
        if (info[1].length() == 24 || !Util.isUserTableHasPwdType(dataCenter)) {
            String encrypt = EncryptUtil.encrypt((String)(String.valueOf(info[0]) + password), (String)"MD5");
            return encrypt.equals(info[1]);
        }
        String encryptPwdBySha = EncryptUtil.encrypt((String)(String.valueOf(info[0]) + password), (String)"SHA-256");
        if (encryptPwdBySha.equals(info[1])) {
            return true;
        }
        return EasContextFactory.checkPwdBySm3(password, info, dataCenter);
    }

    private static boolean checkPwdBySm3(String password, String[] info, String dataCenter) {
        String encryptPwdBySm3 = EasContextFactory.encryptPwdBySm3(password, info);
        return encryptPwdBySm3.equals(info[1]);
    }

    private static String encryptPwdBySm3(String password, String[] info) {
        try {
            Class<?> cls = Class.forName("com.kingdee.eas.base.permission.util.strategy.SM3Encrypter");
            Object inst = cls.newInstance();
            Method method = cls.getMethod("encrypt", String.class, String.class);
            return (String)method.invoke(inst, info[0], password);
        }
        catch (Exception e) {
            throw EasSideError.UNKNOWN_ERROR.wrap((Throwable)e);
        }
    }

    public static String[] getUserInfo(String user, String dataCenter) {
        String value = EasContextFactory.innerGetUserInfo(user, dataCenter);
        if (value.length() == 0) {
            throw new IscBizException("\u7528\u6237(" + user + ")\u5728(" + dataCenter + ")\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        return value.split(",");
    }

    public static String innerGetUserInfo(String user, String dataCenter) {
        String key = String.valueOf(user) + "," + dataCenter;
        String value = cache.get(key);
        if (value == null) {
            try {
                value = EasContextFactory.loadUserInfo(dataCenter, user, key);
            }
            catch (BOSException e) {
                throw DatabaseError.SQL_QUERY_FAILURE.wrap((Throwable)e);
            }
        }
        return value;
    }

    private static String loadUserInfo(String dataCenter, String user, String key) throws BOSException {
        String value;
        String sql = "select fid,fpassword from T_PM_USER where fnumber=? or fid=?";
        ArrayList list = SQL.executeQuery((String)dataCenter, (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{user, user});
        if (list.size() == 0) {
            value = "";
        } else {
            if (list.size() > 1) {
                throw new IscBizException("\u5728(" + dataCenter + ")\u4e2d\u627e\u5230\u4e86" + list.size() + "\u4e2a\u7f16\u7801\u4e3a(" + user + ")\u7684\u7528\u6237,\u8bf7\u4fee\u590d\u6570\u636e\u6216\u4f7f\u7528\u522b\u7684\u7528\u6237\u8fdb\u884c\u767b\u5f55,\u4fdd\u8bc1\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u8be5\u7f16\u7801\u7528\u6237");
            }
            Map data = (Map)list.get(0);
            String p = D.s(data.get("fpassword"));
            value = p == null ? (String)data.get("fid") : data.get("fid") + "," + p;
        }
        cache.put(key, value);
        return value;
    }

    private static void checkTimestamp(Map<String, Object> auth, Map<String, Object> params) {
        if ("get_result".equals(params.get("command"))) {
            return;
        }
        EasContextFactory.checkTimestamp(D.l((Object)auth.get("t")));
    }

    private static void checkTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long now = ConnectionProxy.getInvokeTime();
        long diff = now - timestamp;
        if (Math.abs(diff) > 300000L) {
            throw new IscBizException("EAS\u670d\u52a1\u5668\u65f6\u95f4\u4e3a\uff1a" + sdf.format(now) + "\uff0c\u82cd\u7a79\u670d\u52a1\u5668\u65f6\u95f4\u4e3a\uff1a" + sdf.format(timestamp) + "\uff0c" + "\u4e24\u8005\u65f6\u95f4\u5dee\u4e3a\uff1a " + diff + "\u6beb\u79d2\uff0c\u8d85\u8fc7\u4e86\u6700\u5927\u5141\u8bb8\u8bef\u5dee\uff0c\u8bf7\u5c06\u4e24\u8005\u65f6\u95f4\u8c03\u4e3a\u4e00\u81f4\u3002");
        }
    }

    private static Map<String, Object> parseURL(String URI2, String queryString) {
        int i = URI2.lastIndexOf(47);
        String dataCenter = URI2.substring(i + 1);
        String key = ACL.getAccessKey(dataCenter);
        String text = ACL.decrypt(queryString, key);
        Map auth = (Map)Json.toObject((String)text);
        auth.put("key", key);
        return auth;
    }

    public static void initEachDC(String dataCenter) {
        EasContext ctx = new EasContext(dataCenter);
        try {
            EasContextFactory.ensureTable(ctx);
            EasContextFactory.createCleanerJob(dataCenter);
            PushDataJobHandler.init(dataCenter);
            EasContextFactory.createEventLogCleanerJob(dataCenter);
        }
        catch (Throwable e) {
            ctx.logger("\u6570\u636e\u4e2d\u5fc3\uff08" + dataCenter + "\uff09\u521d\u59cb\u5316\u5931\u8d25\uff01", e);
        }
    }

    private static synchronized void createEventLogCleanerJob(String dataCenter) throws BOSException {
        if (!eventLogCleaners.containsKey(dataCenter)) {
            EventLogCleaner cleaner = new EventLogCleaner(dataCenter);
            Job job = new Job(null, (IJobHandler)cleaner, null, false);
            NotifyUtil.submitJob(job);
            eventLogCleaners.put(dataCenter, cleaner);
        }
    }

    private static synchronized void createCleanerJob(String dataCenter) throws BOSException {
        if (!cleaners.containsKey(dataCenter)) {
            ResultCleaner cleaner = new ResultCleaner(dataCenter);
            Job job = new Job(null, (IJobHandler)cleaner, null, false);
            NotifyUtil.submitJob(job);
            cleaners.put(dataCenter, cleaner);
        }
    }

    private static void ensureTable(EasContext ctx) {
        Connection cn = ctx.getConnection();
        try {
            if (!EasContextFactory.exists(cn, "T_ISCB_TMP_MAIN")) {
                SerializableResultManager.createTmpMainTable((Connection)cn);
            }
            SerializableResultManager.createIndexOnTmpMain((Connection)cn);
            if (!EasContextFactory.exists(cn, "T_ISCB_TMP_RETURNS")) {
                SerializableResultManager.createResultTable((Connection)cn, (String)"BLOB(5000000)");
            }
            SerializableResultManager.addHasMoreFieldToReturnTable((Connection)cn);
            if (!EasContextFactory.exists(cn, "T_ISCB_CON_EVT_BND")) {
                EventBindingUtil.createEventBindingTable((Connection)cn, (String)"CLOB");
            }
            if (!EasContextFactory.exists(cn, "T_ISCB_CON_EVT_QUE")) {
                EventBindingUtil.createEventQueueTable((Connection)cn, (String)"CLOB");
            }
            EventBindingCache.init((String)ctx.getDataCenter(), (Connection)cn);
        }
        finally {
            ctx.dispose(cn);
        }
    }

    public static boolean exists(Connection cn, String table_name) {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(table_name);
        ArrayList<Integer> types = new ArrayList<Integer>(1);
        types.add(12);
        String sql = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME =?";
        int count = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, values, types));
        return count == 1;
    }

    private static void initQueryCacheCleaner() {
        try {
            QueryStringCacheCleaner cleaner = new QueryStringCacheCleaner();
            Job job = new Job(null, (IJobHandler)cleaner, null, false);
            JobManager.instance().add(job);
            EasContext.getErrLogger().info((Object)"QueryCacheCleaner init success\uff01");
        }
        catch (Throwable e) {
            EasContext.getErrLogger().warn((Object)"QueryCacheCleaner init failed\uff01", e);
        }
    }
}

