/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.util.DbConnector;
import java.sql.Connection;
import kd.isc.connector.eas.e.GetTableInfo;
import kd.isc.iscb.util.data.LocalCache;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.err.DatabaseError;

public class TableUtil {
    private static final LocalCache<String, Table> cache = new LocalCache(128);

    public static Table getTable(String dataCenter, String table_name) {
        String key = String.valueOf(table_name) + '@' + dataCenter;
        Table table = (Table)cache.get((Object)key);
        if (table == null) {
            table = TableUtil.innerGetTable(dataCenter, table_name);
            cache.put((Object)key, (Object)table);
        }
        return table;
    }

    private static Table innerGetTable(String dataCenter, String table_name) {
        Connection cn = TableUtil.getConnection(dataCenter);
        try {
            Table table = GetTableInfo.getTable(cn, table_name);
            return table;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    public static Connection getConnection(String dataCenter) {
        try {
            return DbConnector.getConnection((String)dataCenter);
        }
        catch (BOSException e) {
            throw DatabaseError.CONNECTION_FAILURE.create((Throwable)e, new String[]{dataCenter});
        }
    }
}

