/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachmentHandleFacade;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.EasThreadParamUtil;
import kd.isc.connector.eas.LogUtil;
import kd.isc.connector.eas.Util;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;

public class DoBizAction
extends AbstractCommandExecutor {
    protected Object exec(ConnectorContext ctx, Map<String, Object> params) {
        String entity = D.s((Object)params.get("entity"));
        if (!ctx.isValid(entity, ConnectorContext.Operation.WRITE)) {
            throw EasSideError.OUT_OF_PERMISSION.create(new String[]{entity});
        }
        String proxy_user = D.s((Object)params.get("proxy_user"));
        Context bos_context = Util.generateBosCtx(ctx, proxy_user);
        String full_name = D.s((Object)params.get("entity"));
        Map data = (Map)params.get("data");
        Map judgeFields = (Map)params.get("judgeFields");
        List actions = (List)params.get("actions");
        if (((String)actions.get(0)).equals(TableAction._SAVE.name())) {
            actions.set(0, "save");
        }
        Util.checkJudgeFields(data, judgeFields);
        try {
            EasThreadParamUtil.setThreadCtx(bos_context);
            EasThreadParamUtil.setJudgeFields(judgeFields);
            ICoreBase finder = Util.createFinder(bos_context, full_name);
            CoreBaseInfo info = Util.retrieveInfoByPk(data, (List)judgeFields.get("$"), finder);
            boolean needInsert = info == null;
            Method m = DoBizAction.class.getMethod("callBizAction", String.class, List.class, ICoreBase.class, Map.class, CoreBaseInfo.class);
            Response res = (Response)ObjectFactory.invokeRequired((Object)((Object)this), (Method)m, (Object[])new Object[]{bos_context.getAIS(), actions, finder, data, info});
            String boid = res.getId();
            this.checkBillHasInsert(finder, boid, needInsert);
            this.handleAttachment(bos_context, data, boid);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("id", boid);
            result.put("type", res.getType().name());
            result.put("$entry_mapping", res.getEntryMappings());
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            String err = "\u8c03\u7528\u5b9e\u4f53" + full_name + "\u64cd\u4f5c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a";
            EasContext.getErrLogger().error((Object)err, (Throwable)e);
            throw EasSideError.BIZ_ERROR.wrap(Util.unpackageEx(e));
        }
        finally {
            EasThreadParamUtil.removeThreadCtx();
            EasThreadParamUtil.removeJudgeFields();
        }
    }

    public void handleAttachment(Context bos_context, Map<String, Object> data, String boid) throws BOSException {
        Object fileList = data.get("$file_list");
        if (fileList == null || fileList instanceof Map) {
            return;
        }
        Set<String> oldAttachSet = this.getAllAttachIdsByBoid(bos_context, boid);
        List<String> tarAttachIds = this.getTarAttachIds(data);
        ArrayList<String> needBindAttachIds = new ArrayList();
        if (oldAttachSet.size() == 0) {
            needBindAttachIds = tarAttachIds;
        } else {
            for (String attachId : tarAttachIds) {
                if (oldAttachSet.contains(attachId)) {
                    oldAttachSet.remove(attachId);
                    continue;
                }
                needBindAttachIds.add(attachId);
            }
        }
        this.addAttachAssociation(bos_context, boid, needBindAttachIds);
        if (oldAttachSet.size() > 0) {
            this.deleteAttachAssociation(bos_context, boid, new ArrayList<String>(oldAttachSet));
        }
    }

    private void deleteAttachAssociation(Context bos_context, String boid, List<String> oldAttachIds) {
        try {
            IAttachmentHandleFacade facade = AttachmentHandleFacadeFactory.getLocalInstance((Context)bos_context);
            facade.deleteAttachment(boid, oldAttachIds);
        }
        catch (Exception e) {
            throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
        }
    }

    public Set<String> getAllAttachIdsByBoid(Context bos_context, String boid) throws BOSException {
        AttachmentServerManager serverManager = AttachmentManagerFactory.getServerManager((Context)bos_context);
        HashSet<String> oldAttachSet = new HashSet<String>();
        String[] oldAttachIds = serverManager.getAttachmentIDsByBoID(boid);
        if (oldAttachIds != null) {
            String[] stringArray = oldAttachIds;
            int n = oldAttachIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                oldAttachSet.add(id);
                ++n2;
            }
        }
        return oldAttachSet;
    }

    public List<String> getTarAttachIds(Map<String, Object> data) {
        List fileList = (List)data.get("$file_list");
        ArrayList<String> attachIds = new ArrayList<String>();
        for (Map o : fileList) {
            String attachid = D.s(o.get("attachId"));
            if (attachid == null) continue;
            attachIds.add(attachid);
        }
        return attachIds;
    }

    private void addAttachAssociation(Context bos_context, String boid, List<String> attId) {
        if (boid == null || attId.size() == 0) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(12);
        values.add(boid);
        types.add(12);
        values.add(BOSUuid.read((String)boid).getType().toString());
        StringBuilder sb = new StringBuilder("update T_BAS_BOATTCHASSO set FBoID = ?, FASSOBUSOBJTYPE = ? where FATTACHMENTID in (");
        int i = 0;
        while (i < attId.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
            types.add(12);
            values.add(attId.get(i));
            ++i;
        }
        sb.append(")");
        Connection connection = this.getConnection(bos_context);
        try {
            DbUtil.executeUpdate((Connection)connection, (String)sb.toString(), values, types);
        }
        finally {
            DbUtil.close((Connection)connection, (boolean)false);
        }
    }

    private Connection getConnection(Context bos_context) {
        try {
            return DbConnector.getConnection((Context)bos_context);
        }
        catch (BOSException e) {
            throw DatabaseError.CONNECTION_FAILURE.create((Throwable)e, new String[]{bos_context.getAIS()});
        }
    }

    public Response callBizAction(String dataCenter, List<String> actions, ICoreBase finder, Map<String, Object> data, CoreBaseInfo info) {
        try {
            String firstAction = actions.get(0);
            if ("delete".equals(firstAction)) {
                return this.deleteInfo(finder, info);
            }
            if (info == null) {
                return this.insertInfo(dataCenter, data, finder, actions);
            }
            return this.updateInfo(dataCenter, data, finder, actions, info);
        }
        catch (Exception e) {
            throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
        }
    }

    private Response updateInfo(String dataCenter, Map<String, Object> data, ICoreBase finder, List<String> actions, CoreBaseInfo info) throws EASBizException, BOSException, InvocationTargetException, IllegalAccessException {
        HashMap<String, IObjectValue> entries = new HashMap<String, IObjectValue>();
        Util.setValues(dataCenter, info, data, false, entries);
        this.invokeActions(finder, actions, info);
        return new Response(D.s((Object)info.getId()), SaveDataType.UPDATE, this.toEntryMapping(entries));
    }

    private Response insertInfo(String dataCenter, Map<String, Object> data, ICoreBase finder, List<String> actions) throws EASBizException, BOSException, InvocationTargetException, IllegalAccessException {
        CoreBaseInfo info = Util.newInstance(finder);
        HashMap<String, IObjectValue> entries = new HashMap<String, IObjectValue>();
        Util.setValues(dataCenter, info, data, true, entries);
        this.invokeActions(finder, actions, info);
        return new Response(D.s((Object)info.getId()), SaveDataType.INSERT, this.toEntryMapping(entries));
    }

    private void checkBillHasInsert(ICoreBase finder, String boid, boolean needInsert) {
        if (!needInsert || boid == null) {
            return;
        }
        try {
            boolean exists = finder.exists((IObjectPK)new ObjectUuidPK(boid));
            if (!exists) {
                throw new IscBizException("\u8bf7\u68c0\u67e5\u4e1a\u52a1\u64cd\u4f5c\u4ee3\u7801\u662f\u5426\u5403\u6389\u4e86\u5f02\u5e38\u5e76\u53d1\u751f\u4e86\u6570\u636e\u5e93\u4e8b\u52a1\u56de\u6eda\uff0c\u96c6\u6210\u5728\u8c03\u7528\u76ee\u6807\u64cd\u4f5c\u8fc7\u7a0b\u6ca1\u6709\u53d1\u751f\u5f02\u5e38\uff0c\u4f46\u6570\u636e\u5e93\u4e2did\u8bb0\u5f55\u4e0d\u5b58\u5728\uff1a" + boid);
            }
        }
        catch (Exception e) {
            String errMsg = "\u68c0\u67e5id[" + boid + "]\u662f\u5426\u5b58\u5728\u65f6\u53d1\u751f\u5f02\u5e38";
            EasContext.getErrLogger().error((Object)errMsg, (Throwable)e);
            throw new IscBizException(errMsg, (Throwable)e);
        }
    }

    private Map<String, String> toEntryMapping(Map<String, IObjectValue> entries) {
        if (entries.size() == 0) {
            return null;
        }
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (Map.Entry<String, IObjectValue> e : entries.entrySet()) {
            mapping.put(e.getKey(), e.getValue().getString("id"));
        }
        return mapping;
    }

    private void invokeActions(ICoreBase finder, List<String> actions, CoreBaseInfo info) throws BOSException, EASBizException, InvocationTargetException, IllegalAccessException {
        int i = 0;
        while (i < actions.size()) {
            String action = actions.get(i);
            LogUtil.debugLog("\u5f00\u59cb\u8c03\u7528\u6570\u636e\u4e2d\u5fc3[" + finder.getContext().getAIS() + "],\u5b9e\u4f53[" + finder + "]\u76ee\u6807\u64cd\u4f5c\u7684\u7b2c" + i + "\u4e2a\u64cd\u4f5c" + action + ",id:" + info.getId());
            this.invokeAction(finder, info, action);
            LogUtil.debugLog("\u7ed3\u675f\u8c03\u7528\u6570\u636e\u4e2d\u5fc3[" + finder.getContext().getAIS() + "],\u5b9e\u4f53[" + finder + "]\u76ee\u6807\u64cd\u4f5c\u7684\u7b2c" + i + "\u4e2a\u64cd\u4f5c" + action + ",id:" + info.getId());
            ++i;
        }
    }

    private void handleExtendMethod(ICoreBase finder, CoreBaseInfo info, String action) throws IllegalAccessException, InvocationTargetException {
        Method method = this.findMethodByIObjectPK(finder, action);
        if (this.isMethodValid(method)) {
            method.invoke((Object)finder, new ObjectUuidPK(info.getId()));
        } else {
            this.invokeExtendAction(finder, info, action);
        }
    }

    private void invokeExtendAction(ICoreBase finder, CoreBaseInfo info, String action) throws IllegalAccessException, InvocationTargetException {
        Method method = this.findMethodByCoreBaseInfo(finder, action);
        if (this.isMethodValid(method)) {
            method.invoke((Object)finder, info);
        } else {
            this.invokeIObjectMethod(finder, info, action);
        }
    }

    private void invokeIObjectMethod(ICoreBase finder, CoreBaseInfo info, String action) throws IllegalAccessException, InvocationTargetException {
        Method method = this.findMethodByIObjectPKArr(finder, action);
        if (this.isMethodValid(method)) {
            IObjectPK[] args = new IObjectPK[]{new ObjectUuidPK(info.getId())};
            method.invoke((Object)finder, new Object[]{args});
        } else {
            this.invokeIObjectMethodPKAndInfo(finder, info, action);
        }
    }

    private void invokeIObjectMethodPKAndInfo(ICoreBase finder, CoreBaseInfo info, String action) throws IllegalAccessException, InvocationTargetException {
        Method method = this.findMethodByIObjectPKAndInfo(finder, action);
        if (!this.isMethodValid(method)) {
            throw new UnsupportedOperationException(action);
        }
        method.invoke((Object)finder, new ObjectUuidPK(info.getId()), info);
    }

    private boolean isMethodValid(Method method) {
        return method != null;
    }

    private Method findMethodByIObjectPKArr(ICoreBase finder, String action) {
        Method method;
        try {
            method = finder.getClass().getMethod(action, IObjectPK[].class);
        }
        catch (NoSuchMethodException ignore) {
            method = null;
        }
        return method;
    }

    private Method findMethodByIObjectPK(ICoreBase finder, String action) {
        Method method;
        try {
            method = finder.getClass().getMethod(action, IObjectPK.class);
        }
        catch (NoSuchMethodException ignore) {
            method = null;
        }
        return method;
    }

    private Method findMethodByIObjectPKAndInfo(ICoreBase finder, String action) {
        Method method;
        try {
            method = finder.getClass().getMethod(action, IObjectPK.class, CoreBaseInfo.class);
        }
        catch (NoSuchMethodException ignore) {
            try {
                method = finder.getClass().getMethod(action, IObjectPK.class, CoreBillBaseInfo.class);
            }
            catch (NoSuchMethodException ignore2) {
                method = this.findExtMethodByPkAndObjectValue(finder, action);
            }
        }
        return method;
    }

    private Method findMethodByCoreBaseInfo(ICoreBase finder, String action) {
        Method method;
        try {
            method = finder.getClass().getMethod(action, CoreBaseInfo.class);
        }
        catch (NoSuchMethodException ignore) {
            try {
                method = finder.getClass().getMethod(action, CoreBillBaseInfo.class);
            }
            catch (NoSuchMethodException ignore2) {
                method = this.findExtMethodByObjectValue(finder, action);
            }
        }
        return method;
    }

    private Response deleteInfo(ICoreBase finder, CoreBaseInfo info) throws EASBizException, BOSException {
        if (info == null) {
            return new Response(null, SaveDataType.NOP, null);
        }
        finder.delete((IObjectPK)new ObjectUuidPK(info.getId()));
        return new Response(D.s((Object)info.getId()), SaveDataType.DELETE, null);
    }

    private Method findExtMethodByPkAndObjectValue(ICoreBase finder, String action) {
        Method method;
        try {
            method = finder.getClass().getMethod(action, IObjectPK.class, IObjectValue.class);
        }
        catch (NoSuchMethodException ignore3) {
            method = null;
        }
        return method;
    }

    private Method findExtMethodByObjectValue(ICoreBase finder, String action) {
        Method method;
        try {
            method = finder.getClass().getMethod(action, IObjectValue.class);
        }
        catch (NoSuchMethodException ignore3) {
            method = null;
        }
        return method;
    }

    private void invokeAction(ICoreBase finder, CoreBaseInfo info, String action) throws BOSException, EASBizException, IllegalAccessException, InvocationTargetException {
        if ("submit".equals(action)) {
            finder.submit(info);
        } else if ("update".equals(action)) {
            finder.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
        } else if ("cancel".equals(action)) {
            finder.cancel((IObjectPK)new ObjectUuidPK(info.getId()), info);
        } else if ("uncancel".equals(action)) {
            finder.cancelCancel((IObjectPK)new ObjectUuidPK(info.getId()), info);
        } else if ("revise".equals(action)) {
            finder.revise((IObjectPK)new ObjectUuidPK(info.getId()), info);
        } else if ("addnew".equals(action)) {
            finder.addnew(info);
        } else if ("save".equals(action)) {
            finder.save(info);
        } else if ("delete".equals(action)) {
            finder.delete((IObjectPK)new ObjectUuidPK(info.getId()));
        } else {
            this.handleExtendMethod(finder, info, action);
        }
    }

    public List<Response> doBatchAction(Context bos_context, String entity, List<Map<String, Object>> batch, Map<String, List<String>> judgeFields, String action) {
        ICoreBase finder = Util.createFinder(bos_context, entity);
        ArrayList<Response> responses = new ArrayList<Response>();
        for (Map<String, Object> data : batch) {
            Response resp = this.invokeAction(bos_context, judgeFields, action, finder, data);
            responses.add(resp);
        }
        return responses;
    }

    private Response invokeAction(Context bos_context, Map<String, List<String>> judgeFields, String action, ICoreBase finder, Map<String, Object> data) {
        try {
            CoreBaseInfo info = Util.retrieveInfoByPk(data, judgeFields.get("$"), finder);
            if ("delete".equals(action)) {
                return this.deleteInfo(finder, info);
            }
            if (info == null) {
                info = Util.newInstance(finder);
                return this.saveInfoAndBindAttachment(bos_context, data, finder, action, info, true);
            }
            return this.saveInfoAndBindAttachment(bos_context, data, finder, action, info, false);
        }
        catch (Throwable e) {
            return new Response(null, e);
        }
    }

    private Response saveInfoAndBindAttachment(Context bosContext, Map<String, Object> data, ICoreBase finder, String action, CoreBaseInfo info, boolean addNew) {
        HashMap<String, IObjectValue> entries = new HashMap<String, IObjectValue>();
        Util.setValues(bosContext.getAIS(), info, data, addNew, entries);
        try {
            this.invokeAction(finder, info, action);
            String boid = D.s((Object)info.getId());
            this.handleAttachment(finder.getContext(), data, boid);
            SaveDataType type = addNew ? SaveDataType.INSERT : SaveDataType.UPDATE;
            return new Response(boid, type, this.toEntryMapping(entries));
        }
        catch (Throwable e) {
            return new Response(D.s((Object)info.getId()), e);
        }
    }

    public String getCommand() {
        return "do_biz_action";
    }
}

