/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.util.DbConnector;
import java.sql.Connection;
import java.util.Map;
import kd.isc.connector.eas.ACL;
import kd.isc.connector.eas.ClearCacheUtil;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasContextFactory;
import kd.isc.connector.eas.Util;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Hash;

public class RemoteDeploy
extends AbstractCommandExecutor {
    public String getCommand() {
        return "remote_deploy";
    }

    protected Boolean exec(ConnectorContext ctx, Map<String, Object> params) {
        EasContext easContext = (EasContext)ctx;
        String dataCenter = easContext.getDataCenter();
        ACL.init(dataCenter);
        this.saveIscServerInfo(params, dataCenter, easContext.getHash());
        ACL.init(dataCenter);
        ClearCacheUtil.clearMembersCache(easContext.getProtocal(), dataCenter, easContext.getQueryString());
        String ierpUrl = D.s((Object)params.get("ierp_server_url"));
        Util.testCallbackIerp(dataCenter, ierpUrl);
        return true;
    }

    private void saveIscServerInfo(Map<String, Object> params, String dataCenter, String hash) {
        String key = EasContextFactory.getDeployKey(dataCenter);
        String ierp_server_url = D.s((Object)params.get("ierp_server_url"));
        String accessKey = Cipher.decrypt((String)D.s((Object)params.get("access_key")), (String)key);
        if (!hash.equals(Hash.md5((String)(String.valueOf(ierp_server_url) + accessKey)))) {
            throw new UnsupportedOperationException("\u54c8\u5e0c\u7801\u4e0d\u5339\u914d\uff01");
        }
        PermissionMode mode = PermissionMode.valueOf((String)D.s((Object)params.get("permission_mode")));
        Connection cn = this.getConnection(dataCenter);
        try {
            IscHubConfigUtil.saveIscHubServerInfo((Connection)cn, (String)ierp_server_url, (String)accessKey, (PermissionMode)mode);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    private Connection getConnection(String dataCenter) {
        try {
            return DbConnector.getConnection((String)dataCenter);
        }
        catch (BOSException e) {
            throw DatabaseError.CONNECTION_FAILURE.create((Throwable)e, new String[]{dataCenter});
        }
    }
}

