/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.simplecmd;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.util.DbConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.isc.connector.eas.ACL;
import kd.isc.connector.eas.EasContextFactory;
import kd.isc.connector.eas.Util;
import kd.isc.connector.eas.simplecmd.SimpleCmd;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;

public class CheckDeployInfo
implements SimpleCmd {
    private static final String ISC_HUB = "isc_hub";
    private static final String USER = "user";

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String reqParam = CheckDeployInfo.readReq(req);
        String dataCenter = D.s((Object)req.getParameter("dataCenter"));
        Map<String, Object> ierpInfo = this.getIerpInfo(reqParam, dataCenter);
        List<String> dataCenterList = Util.getDataCenters();
        if (dataCenterList.contains(dataCenter)) {
            this.checkDeployInfo(res, dataCenter, ierpInfo);
        } else {
            res.sendError(404);
        }
    }

    private void checkDeployInfo(HttpServletResponse res, String dataCenter, Map<String, Object> ierpInfo) throws IOException {
        Connection cn = null;
        try {
            try {
                cn = DbConnector.getConnection((String)dataCenter);
                Map deployInfo = IscHubConfigUtil.getDeployInfo((Connection)cn);
                res.getOutputStream().write(Json.toString(this.checkEasDeployInfo(deployInfo, ierpInfo, dataCenter)).getBytes(D.UTF_8));
            }
            catch (BOSException e) {
                throw DatabaseError.CONNECTION_FAILURE.create((Throwable)e, new String[]{dataCenter});
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    private List<Pair> checkEasDeployInfo(Map<String, Object> deployData, Map<String, Object> ierpInfo, String dataCenter) {
        if (deployData == null) {
            return Collections.singletonList(new Pair((Object)"\u8fde\u63a5\u8d26\u5957", (Object)"EAS\u8fde\u63a5\u672a\u90e8\u7f72\uff0c\u8bf7\u5148\u90e8\u7f72\u540e\u518d\u68c0\u6d4b\u90e8\u7f72\u4fe1\u606f"));
        }
        Map deployInfo = (Map)Json.toObject((String)Cipher.decrypt((String)D.s((Object)deployData.get("fisc_access_key"))));
        if (this.isDeployedByOtherIerp(ierpInfo, deployInfo)) {
            return Collections.singletonList(new Pair((Object)"\u8fde\u63a5\u8d26\u5957", (Object)("\u8be5EAS\u8d26\u5957\u5df2\u88abURL\u4e3a\u3010" + deployData.get("fierp_server_url") + "\u3011\u7684\u3010" + deployInfo.get("accountName") + "\u3011\u8d26\u5957\u90e8\u7f72\uff0c\u8bf7\u91cd\u65b0\u90e8\u7f72\u3002")));
        }
        ArrayList<Pair> checkList = new ArrayList<Pair>();
        this.checkIerpUser(ierpInfo, deployInfo, checkList);
        this.checkEasUser(ierpInfo, dataCenter, checkList);
        if (checkList.isEmpty()) {
            checkList.add(new Pair((Object)"\u68c0\u67e5\u901a\u8fc7", (Object)"\u68c0\u67e5\u901a\u8fc7\uff0c\u65e0\u5dee\u5f02\u9879"));
        }
        return checkList;
    }

    private void checkEasUser(Map<String, Object> ierpInfo, String dataCenter, List<Pair> checkList) {
        if (this.easUserNotExsits(ierpInfo, dataCenter)) {
            checkList.add(new Pair((Object)"EAS\u767b\u5f55\u7528\u6237", (Object)("\u7528\u6237\u3010" + ierpInfo.get("easUser") + "\u3011\u5728\u3010" + dataCenter + "\u3011\u8d26\u5957\u4e2d\u4e0d\u5b58\u5728\u3002")));
        } else if (this.easUserPwdChanged(ierpInfo, dataCenter)) {
            checkList.add(new Pair((Object)"EAS\u767b\u5f55\u7528\u6237\u5bc6\u7801", (Object)"\u8fde\u63a5\u914d\u7f6e\u4e2d\u3010EAS\u767b\u5f55\u7528\u6237\u5bc6\u7801\u3011\u9519\u8bef\uff0c\u8bf7\u5728\u8fde\u63a5\u914d\u7f6e\u4e2d\u8f93\u5165\u6b63\u786e\u7684\u5bc6\u7801\u5e76\u91cd\u65b0\u90e8\u7f72\u3002"));
        }
    }

    private void checkIerpUser(Map<String, Object> ierpInfo, Map<String, Object> deployInfo, List<Pair> checkList) {
        if (this.ierpUserChanged(ierpInfo, deployInfo)) {
            checkList.add(new Pair((Object)"\u5f53\u524d\u8d26\u5957\u56de\u8c03\u4ee3\u7406\u7528\u6237", (Object)("\u8fde\u63a5\u914d\u7f6e\u4e2d\u3010\u5f53\u524d\u8d26\u5957\u56de\u8c03\u4ee3\u7406\u7528\u6237\u3011\uff1a" + ierpInfo.get(USER) + "  \uff0c\u5df2\u90e8\u7f72\u4ee3\u7406\u7528\u6237\uff1a" + deployInfo.get(USER) + "\uff0c\u8bf7\u91cd\u65b0\u90e8\u7f72\u3002")));
        } else if (this.ierpUserPwdChanged(ierpInfo, deployInfo)) {
            checkList.add(new Pair((Object)"\u5f53\u524d\u8d26\u5957\u56de\u8c03\u4ee3\u7406\u7528\u6237\u5bc6\u7801", (Object)("\u8fde\u63a5\u914d\u7f6e\u4e2d\u3010\u5f53\u524d\u8d26\u5957\u56de\u8c03\u4ee3\u7406\u7528\u6237\u3011\uff1a" + ierpInfo.get(USER) + "\u7684\u5bc6\u7801\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u90e8\u7f72\u3002")));
        }
    }

    private boolean easUserNotExsits(Map<String, Object> ierpInfo, String dataCenter) {
        String easUser = D.s((Object)ierpInfo.get("easUser"));
        String value = EasContextFactory.innerGetUserInfo(easUser, dataCenter);
        return value.length() == 0;
    }

    private boolean easUserPwdChanged(Map<String, Object> ierpInfo, String dataCenter) {
        return !this.checkEasUserAndPassword(ierpInfo, dataCenter);
    }

    private boolean ierpUserPwdChanged(Map<String, Object> ierpInfo, Map<String, Object> deployInfo) {
        return !ierpInfo.get("user_pwd").equals(deployInfo.get("user_pwd"));
    }

    private boolean ierpUserChanged(Map<String, Object> ierpInfo, Map<String, Object> deployInfo) {
        return !ierpInfo.get(USER).equals(deployInfo.get(USER));
    }

    private boolean isDeployedByOtherIerp(Map<String, Object> ierpInfo, Map<String, Object> deployInfo) {
        return !ierpInfo.get(ISC_HUB).equals(deployInfo.get(ISC_HUB));
    }

    private static String readReq(HttpServletRequest req) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)req.getInputStream(), "UTF-8");
        try {
            String string = (String)Json.toObject((Reader)reader);
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private Map<String, Object> getIerpInfo(String reqParam, String dataCenter) {
        String key = EasContextFactory.getDeployKey(dataCenter);
        String data = ACL.decrypt(reqParam, key);
        return (Map)Json.toObject((String)data);
    }

    private boolean checkEasUserAndPassword(Map<String, Object> reqData, String dataCenter) {
        String easUser = D.s((Object)reqData.get("easUser"));
        String easUserPassword = D.s((Object)reqData.get("easUserPassword"));
        String[] info = EasContextFactory.getUserInfo(easUser, dataCenter);
        if (info.length == 1) {
            return easUserPassword == null;
        }
        return EasContextFactory.checkPwdWithoutException(easUserPassword, info, dataCenter);
    }
}

