/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.dt;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class D {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Date ZERO = D.t("1899-12-30");

    public static long l(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        return D.l(value.toString().trim());
    }

    private static long l(String s) {
        if (s.length() == 0) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static int i(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return D.i(value.toString().trim());
    }

    private static int i(String s) {
        if (s.length() == 0) {
            return 0;
        }
        if ("true".equalsIgnoreCase(s)) {
            return 1;
        }
        if ("false".equalsIgnoreCase(s)) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public static String s(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static String s(Object o, String defaultString) {
        String t = D.s(o);
        if (t != null) {
            return t;
        }
        return defaultString;
    }

    public static boolean x(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof byte[]) {
            return D.bytesToBoolean((byte[])o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        String s = o.toString().trim();
        if (s.length() == 0) {
            return false;
        }
        if ("false".equalsIgnoreCase(s) || "0".equalsIgnoreCase(s) || "no".equalsIgnoreCase(s) || "off".equalsIgnoreCase(s) || "n".equalsIgnoreCase(s) || "f".equalsIgnoreCase(s) || "failed".equalsIgnoreCase(s) || "\u4e0d\u540c\u610f".equals(s) || "\u62d2\u7edd".equals(s) || "\u9a73\u56de".equals(s) || "\u5426".equals(s) || "undefined".equals(s) || "disable".equals(s)) {
            return false;
        }
        if ("true".equalsIgnoreCase(s) || "1".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s) || "y".equalsIgnoreCase(s) || "t".equalsIgnoreCase(s) || "ok".equalsIgnoreCase(s) || "success".equalsIgnoreCase(s) || "\u540c\u610f".equals(s) || "\u901a\u8fc7".equals(s) || "\u662f".equals(s) || "enable".equals(s)) {
            return true;
        }
        throw new IscBizException("invalid boolean string '" + s + "'.");
    }

    private static boolean bytesToBoolean(byte[] bytes) {
        if (bytes.length == 1) {
            return bytes[0] != 0;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString("byte\u6570\u7ec4\uff08%s\uff09\u7684\u957f\u5ea6\u4e0d\u662f1\uff0c\u4e0d\u80fd\u8f6c\u6362\u4e3aboolean\u503c\u3002", "D_12", "isc-iscb-util", new Object[0]), Hex.encode(bytes)));
    }

    public static Timestamp t(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof Double) {
            double t = (Double)value * 8.64E7;
            return new Timestamp((long)t + ZERO.getTime());
        }
        String s0 = value.toString();
        if (s0 == null) {
            return null;
        }
        String s = s0.trim();
        if (s.length() == 0) {
            return null;
        }
        if (D.isLong(s)) {
            return new Timestamp(Long.parseLong(s));
        }
        int i = s.lastIndexOf(46);
        if (i < 0) {
            String format = D.getDateFormat(s);
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            try {
                return new Timestamp(sdf.parse(s).getTime());
            }
            catch (ParseException e) {
                throw D.e(e);
            }
        }
        String s1 = s.substring(0, i);
        String s2 = s.substring(i + 1);
        int len = s2.length();
        if (len > 9) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u65e5\u671f/\u65f6\u95f4\u5c0f\u6570\u4f4d\u6570\u8d85\u8fc79\u4f4d\uff0c\u4e0d\u652f\u6301\u8f93\u5165\u7684\u53c2\u6570\u503c\uff1a%s", "D_13", "isc-iscb-util", new Object[0]), s));
        }
        s2 = String.valueOf(s2) + "000000000".substring(0, 9 - len);
        String format = D.getDateFormat(s1);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            Timestamp t = new Timestamp(sdf.parse(s).getTime());
            t.setNanos(Integer.parseInt(s2));
            return t;
        }
        catch (ParseException e) {
            throw D.e(e);
        }
    }

    private static int colonCount(String s) {
        int i = s.indexOf(58);
        int count = 0;
        while (i >= 0) {
            ++count;
            i = s.indexOf(58, i + 1);
        }
        return count;
    }

    public static String getDateFormat(String s) {
        String format = null;
        if (s.indexOf(84) > 0) {
            format = s.indexOf(46) > 0 ? "yyyy-MM-dd'T'HH:mm:ss.SSS" : (D.colonCount(s) == 2 ? "yyyy-MM-dd'T'HH:mm:ss" : "yyyy-MM-dd'T'HH:mm");
        } else if (s.indexOf(32) > 0) {
            if (s.indexOf(45) > 0) {
                format = s.indexOf(46) > 0 ? "yyyy-MM-dd HH:mm:ss.SSS" : (D.colonCount(s) == 2 ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm");
            } else if (s.indexOf(47) > 0) {
                format = s.indexOf(46) > 0 ? "yyyy/MM/dd HH:mm:ss.SSS" : (D.colonCount(s) == 2 ? "yyyy/MM/dd HH:mm:ss" : "yyyy/MM/dd HH:mm");
            }
        } else if (s.indexOf(47) > 0) {
            format = "yyyy/MM/dd";
        } else if (s.indexOf(45) > 0) {
            format = "yyyy-MM-dd";
        } else if (s.indexOf(58) > 0) {
            format = s.indexOf(46) > 0 ? "HH:mm:ss.SSS" : (D.colonCount(s) == 2 ? "HH:mm:ss" : "HH:mm");
        }
        if (format != null) {
            return format;
        }
        throw new IscBizException("illegal datetime format, s='" + s + "'.");
    }

    public static boolean isLong(String d) {
        int i = 0;
        int j = d.length();
        while (i < j) {
            char c = d.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static BigDecimal n(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        String s = value.toString().trim();
        if (s.length() == 0) {
            return BigDecimal.ZERO;
        }
        if (s.indexOf(44) >= 0) {
            s = s.replaceAll(",", "");
        }
        if (s.equals("-")) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(s);
    }

    public static RuntimeException e(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new IscBizException(e.getMessage(), e);
    }

    public static Exception e2(Throwable e) {
        if (e instanceof Exception) {
            return (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return D.e(e);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw CommonError.THREAD_INTERRUPTED.wrap(e);
        }
    }

    public static String format(Date d, String format) {
        if (d == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format, Locale.CHINA);
        return df.format(d);
    }

    public static boolean isFatal(Throwable error) {
        if (error == null) {
            return false;
        }
        if (error instanceof Error) {
            return true;
        }
        String text = StringUtil.getCascadeMessage(error);
        return text.contains("Timeout") || text.contains("timeout") || text.contains("TIMEOUT") || text.contains("\u8d85\u65f6") || text.contains("Java heap space") || text.contains("java.lang.StackOverflowError");
    }

    public static boolean isError(Throwable error) {
        if (error == null) {
            return false;
        }
        if (error instanceof Error) {
            return true;
        }
        String text = StringUtil.getCascadeMessage(error);
        return text.contains("Java heap space") || text.contains("java.lang.StackOverflowError");
    }

    public static <O> List<O> asList(O ... v) {
        if (v == null) {
            throw new NullPointerException(ResManager.loadKDString("\u4e0d\u5141\u8bb8\u4f7f\u7528NULL\u8c03\u7528\u672c\u65b9\u6cd5\u3002", "D_11", "isc-iscb-util", new Object[0]));
        }
        switch (v.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(v[0]);
            }
        }
        return Arrays.asList(v);
    }
}

