/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.c.common;

import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.runtime.DataAreaImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;
import kd.isc.iscb.util.flow.core.plugin.Condition;

public class TerminateChildrenAndSubMemory
extends Command {
    private Condition c;
    private String node;

    public TerminateChildrenAndSubMemory(String node, Condition c) {
        super(100);
        this.node = node;
        this.c = c;
    }

    @Override
    public int invoke(ExecutionImpl e) {
        if (!this.c.test(e)) {
            return 1;
        }
        for (ExecutionImpl parent : e.getRuntime().getExecutions(this.node)) {
            for (ExecutionImpl child : parent.getChildren()) {
                if (child == e) continue;
                child.terminate();
                this.cancelSubMemory(parent, child);
            }
        }
        return 1;
    }

    private void cancelSubMemory(ExecutionImpl parent, ExecutionImpl child) {
        DataAreaImpl subMemory = child.getMemory();
        if (subMemory.getHost() == parent) {
            subMemory.setCanceled();
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.node + "] when " + this.c;
    }
}

