/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.op.compare;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.core.Filter;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.core.Operator;
import kd.isc.iscb.util.script.core.Predicate;
import kd.isc.iscb.util.script.core.Repository;
import kd.isc.iscb.util.script.data.Range;
import kd.isc.iscb.util.script.feature.op.compare.Less;
import kd.isc.iscb.util.script.feature.op.compare.LessOrEquals;
import kd.isc.iscb.util.script.feature.tool.collection.Util;
import kd.isc.iscb.util.script.util.Numeric;

public class Contains
implements NativeFunction,
Operator,
Predicate {
    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "contains";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object v = Contains.get(args, 0);
        Object expected = Contains.get(args, 1);
        return Contains.calc(ctx, v, expected);
    }

    public static Object calc(ScriptContext ctx, Object v, Object expected) {
        if (v == null) {
            if (expected == null) {
                return true;
            }
            return false;
        }
        if (expected instanceof NativeFunction && (v instanceof Collection || v.getClass().isArray() || v instanceof Map)) {
            return Contains.findByFunction(ctx, v, (NativeFunction)expected);
        }
        if (v instanceof Collection) {
            return ((Collection)v).contains(expected);
        }
        if (v instanceof Repository) {
            return ((Repository)v).exists(expected);
        }
        if (v instanceof Map) {
            return ((Map)v).containsKey(expected);
        }
        if (v instanceof String) {
            return Contains.findInString(v, expected);
        }
        if (v.getClass().isArray()) {
            return Contains.findInArray(v, expected);
        }
        if (v instanceof Range) {
            return Contains.findInRange((Range)v, expected);
        }
        if (v instanceof Filter) {
            return ((Filter)v).contains(expected);
        }
        if (v instanceof Context) {
            return ((Context)v).contains((String)expected);
        }
        throw new UnsupportedOperationException(v + " contains " + expected);
    }

    private static Object findInRange(Range v, Object expected) {
        Object[] a = new Object[]{v.getLBound(), expected, v.getUBound()};
        Numeric.normalize(a);
        Object startValue = a[0];
        Object value = a[1];
        Object endValue = a[2];
        if (Less.isLess(startValue, endValue)) {
            if (LessOrEquals.test(startValue, value) && LessOrEquals.test(value, endValue)) {
                return true;
            }
            return false;
        }
        if (LessOrEquals.test(value, startValue) && LessOrEquals.test(endValue, value)) {
            return true;
        }
        return false;
    }

    private static Object findInString(Object v, Object expected) {
        if (expected == null) {
            return Boolean.FALSE;
        }
        return ((String)v).contains(expected.toString());
    }

    public static Object get(Object[] args, int i) {
        Object o = args[i];
        if (o instanceof StringBuilder) {
            o = o.toString();
        } else if (o instanceof StringBuffer) {
            o = o.toString();
        }
        return o;
    }

    private static Object findByFunction(ScriptContext ctx, Object v, NativeFunction fn) {
        Iterator<?> it = Util.getIterator(v);
        Object[] params = new Object[1];
        while (it.hasNext()) {
            params[0] = it.next();
            if (!((Boolean)fn.call(ctx, params)).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Object findInArray(Object v, Object expected) {
        Iterator<?> it = Util.getIterator(v);
        while (it.hasNext()) {
            if (!expected.equals(it.next())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public int priority() {
        return 6;
    }

    @Override
    public int type() {
        return 4;
    }
}

