/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.rpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cloudera.impala.jdbc4.internal.apache.log4j.Logger;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.customer.gtiit.util.ContractRptUtil;
import com.kingdee.shr.customer.gtiit.util.DateTimeUtils;
import com.kingdee.shr.customer.gtiit.util.NewExportUtils;
import com.kingdee.shr.customer.gtiit.util.RptUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class ContractListReportNEWListHandler
extends ListHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.customer.gtiit.rpt.ContractListReportNEWListHandler");
    Context ctx = SHRContext.getInstance().getContext();
    private int totalCount;

    public String getGridColModelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, SQLException {
        ArrayList<String> colNames = this.getcolNamesAction();
        List<Map<String, Object>> colModel = this.getcolModelAction();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        map.put("colNames", colNames);
        map.put("colModel", colModel);
        JSONUtils.writeJson((HttpServletResponse)response, map);
        return null;
    }

    public void getGridDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException, ParseException {
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        ArrayList maplist = new ArrayList();
        int num = 0;
        ArrayList<String> qfNames = new ArrayList<String>();
        qfNames.add("queryTime");
        qfNames.add("workerCategory");
        qfNames.add("job");
        String parameter = request.getParameter("fastFilterItems");
        JSONObject paramJson = JSON.parseObject((String)parameter);
        Map<String, Object> rptSQLFilterate = RptUtils.getRptSQLFilterate(paramJson, qfNames);
        String sqlInfo = ContractRptUtil.getNewContractSql(rptSQLFilterate);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlInfo);
        Calendar calendar = Calendar.getInstance();
        int daysInYear = calendar.getActualMaximum(6);
        BigDecimal year = new BigDecimal(daysInYear);
        while (rs.next()) {
            if (++num < rows * (page - 1) + 1 || num > rows * page) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("PersonNumber", rs.getString("PersonNumber"));
            map.put("LastName", rs.getString("LastName"));
            map.put("FirstName", rs.getString("FirstName"));
            map.put("EnglishName", rs.getString("EnglishName"));
            map.put("Department", rs.getString("Department"));
            map.put("Position", rs.getString("Positions"));
            map.put("JobName", rs.getString("JobName"));
            map.put("WorkerCategory", rs.getString("WorkerCategory"));
            map.put("PersonType", rs.getString("PersonType"));
            map.put("FullorPartTime", rs.getString("FullorPartTime"));
            map.put("HireDate", rs.getDate("HireDate") == null ? null : DateTimeUtils.dateFormat(rs.getDate("HireDate"), "yyyy-MM-dd"));
            map.put("ProbationEndDate", rs.getDate("ProbationEndDate") == null ? null : DateTimeUtils.dateFormat(rs.getDate("ProbationEndDate"), "yyyy-MM-dd"));
            map.put("ContractNo", rs.getString("ContractNo"));
            map.put("Type", rs.getString("Type"));
            Date commencingDate = rs.getDate("CommencingDate");
            map.put("CommencingDate", commencingDate == null ? null : DateTimeUtils.dateFormat(rs.getDate("CommencingDate"), "yyyy-MM-dd"));
            Date expiredDate = rs.getDate("ExpiredDate");
            map.put("ExpiredDate", expiredDate == null ? null : DateTimeUtils.dateFormat(rs.getDate("ExpiredDate"), "yyyy-MM-dd"));
            BigDecimal toYearsOfService = null;
            if (rs.getString("yearsofservice") != null) {
                BigDecimal yearsofservice = new BigDecimal(rs.getString("yearsofservice"));
                toYearsOfService = yearsofservice.setScale(2, RoundingMode.HALF_UP);
                logger.error((Object)("\u670d\u52a1\u5e74\u96502\u4f4d\u5c0f\u6570" + toYearsOfService));
            }
            map.put("YearsOfService", toYearsOfService.toString());
            maplist.add(map);
        }
        this.totalCount = num;
        LinkedHashMap<String, Serializable> gridDataMap = new LinkedHashMap<String, Serializable>();
        if (this.totalCount % rows == 0) {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows));
        } else {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows + 1));
        }
        gridDataMap.put("page", Integer.valueOf(page));
        gridDataMap.put("records", Integer.valueOf(this.totalCount));
        gridDataMap.put("rows", maplist);
        JSONUtils.writeJson((HttpServletResponse)response, gridDataMap);
    }

    public ArrayList<String> getcolNamesAction() throws SHRWebException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Person Number \u5de5\u53f7");
        list.add("Last Name \u59d3");
        list.add("First Name \u540d");
        list.add("English Name \u82f1\u6587\u540d");
        list.add("Department \u90e8\u95e8\u540d\u79f0");
        list.add("Position \u804c\u4f4d\u540d\u79f0");
        list.add("Job Name \u804c\u52a1");
        list.add("Worker Category \u5458\u5de5\u7c7b\u522b");
        list.add("Person Type \u4eba\u5458\u7c7b\u578b");
        list.add("Full or Part Time \u5168\u804c\u6216\u517c\u804c");
        list.add("Hire Date \u96c7\u4f63\u65e5\u671f");
        list.add("Probation End Date \u8bd5\u7528\u671f\u7ed3\u675f\u65e5\u671f");
        list.add("Contract/Agreement No. \u5408\u540c/\u534f\u8bae\u7f16\u7801");
        list.add("Type \u7c7b\u578b");
        list.add("Commencing Date \u5f00\u59cb\u65f6\u95f4");
        list.add("Expired Date \u7ed3\u675f\u65f6\u95f4");
        list.add("Service life \u670d\u52a1\u5e74\u9650");
        return list;
    }

    public List<Map<String, Object>> getcolModelAction() {
        ArrayList<Map<String, Object>> modelColList = new ArrayList<Map<String, Object>>();
        modelColList.add(this.buildColModelMap("PersonNumber", "Person Number \u5de5\u53f7", 120));
        modelColList.add(this.buildColModelMap("LastName", "Last Name \u59d3", 120));
        modelColList.add(this.buildColModelMap("FirstName", "First Name \u540d", 120));
        modelColList.add(this.buildColModelMap("EnglishName", "English Name \u82f1\u6587\u540d", 120));
        modelColList.add(this.buildColModelMap("Department", "Department \u90e8\u95e8\u540d\u79f0", 120));
        modelColList.add(this.buildColModelMap("Position", "Position \u804c\u4f4d\u540d\u79f0", 120));
        modelColList.add(this.buildColModelMap("JobName", "Job Name \u804c\u52a1", 120));
        modelColList.add(this.buildColModelMap("WorkerCategory", "Worker Category \u5458\u5de5\u7c7b\u522b", 120));
        modelColList.add(this.buildColModelMap("PersonType", "Person Type \u4eba\u5458\u7c7b\u578b", 120));
        modelColList.add(this.buildColModelMap("FullorPartTime", "Full or Part Time \u5168\u804c\u6216\u517c\u804c", 120));
        modelColList.add(this.buildColModelMap("HireDate", "Hire Date \u96c7\u4f63\u65e5\u671f", 120));
        modelColList.add(this.buildColModelMap("ProbationEndDate", "Probation End Date \u8bd5\u7528\u671f\u7ed3\u675f\u65e5\u671f", 120));
        modelColList.add(this.buildColModelMap("ContractNo", "Contract/Agreement No. \u5408\u540c/\u534f\u8bae\u7f16\u7801", 120));
        modelColList.add(this.buildColModelMap("Type", "Type \u7c7b\u578b", 120));
        modelColList.add(this.buildColModelMap("CommencingDate", "Commencing Date \u5f00\u59cb\u65f6\u95f4", 120));
        modelColList.add(this.buildColModelMap("ExpiredDate", "Expired Date \u7ed3\u675f\u65f6\u95f4", 120));
        modelColList.add(this.buildColModelMap("YearsOfService", "Service life \u670d\u52a1\u5e74\u9650", 120));
        return modelColList;
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width) {
        return this.buildColModelMap(index, label, width, false, false, false);
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width, boolean rowspan, boolean isKey, boolean isHedden) {
        LinkedHashMap<String, Object> gridIdMap = new LinkedHashMap<String, Object>();
        gridIdMap.put("index", index);
        gridIdMap.put("name", index);
        gridIdMap.put("label", label);
        gridIdMap.put("width", width);
        if (rowspan) {
            gridIdMap.put("rowspan", rowspan);
        }
        if (isKey) {
            gridIdMap.put("key", isKey);
        }
        if (isHedden) {
            gridIdMap.put("hidden", isHedden);
        }
        return gridIdMap;
    }

    public String toExcelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException {
        ArrayList<String> qfNames = new ArrayList<String>();
        qfNames.add("queryTime");
        qfNames.add("workerCategory");
        qfNames.add("job");
        String parameter = request.getParameter("fastFilterItems");
        JSONObject paramJson = JSON.parseObject((String)parameter);
        Map<String, Object> rptSQLFilterate = RptUtils.getRptSQLFilterate(paramJson, qfNames);
        String sqlInfo = ContractRptUtil.getNewContractSql(rptSQLFilterate);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sqlInfo);
        LinkedHashMap<String, String> selectFieldsTypeMap = new LinkedHashMap<String, String>();
        String stringType = "String_@";
        String dateType = "Date_yyyy/MM/dd";
        selectFieldsTypeMap.put("PersonNumber", "Number_0_%s");
        selectFieldsTypeMap.put("LastName", stringType);
        selectFieldsTypeMap.put("FirstName", stringType);
        selectFieldsTypeMap.put("EnglishName", stringType);
        selectFieldsTypeMap.put("Department", stringType);
        selectFieldsTypeMap.put("Positions", stringType);
        selectFieldsTypeMap.put("JobName", stringType);
        selectFieldsTypeMap.put("WorkerCategory", stringType);
        selectFieldsTypeMap.put("PersonType", stringType);
        selectFieldsTypeMap.put("FullorPartTime", stringType);
        selectFieldsTypeMap.put("HireDate", dateType);
        selectFieldsTypeMap.put("ProbationEndDate", dateType);
        selectFieldsTypeMap.put("ContractNo", stringType);
        selectFieldsTypeMap.put("Type", stringType);
        selectFieldsTypeMap.put("CommencingDate", dateType);
        selectFieldsTypeMap.put("ExpiredDate", dateType);
        selectFieldsTypeMap.put("Yearsofservice", "Number_0.0_%s");
        ArrayList<String> list = new ArrayList<String>();
        list.add("Person Number \u5de5\u53f7");
        list.add("Last Name \u59d3");
        list.add("First Name \u540d");
        list.add("English Name \u82f1\u6587\u540d");
        list.add("Department \u90e8\u95e8\u540d\u79f0");
        list.add("Position \u804c\u4f4d\u540d\u79f0");
        list.add("Job Name \u804c\u52a1");
        list.add("Worker Category \u5458\u5de5\u7c7b\u522b");
        list.add("Person Type \u4eba\u5458\u7c7b\u578b");
        list.add("Full or Part Time \u5168\u804c\u6216\u517c\u804c");
        list.add("Hire Date \u96c7\u4f63\u65e5\u671f");
        list.add("Probation End Date \u8bd5\u7528\u671f\u7ed3\u675f\u65e5\u671f");
        list.add("Contract/Agreement No. \u5408\u540c/\u534f\u8bae\u7f16\u7801");
        list.add("Type \u7c7b\u578b");
        list.add("Commencing Date \u5f00\u59cb\u65f6\u95f4");
        list.add("Expired Date \u7ed3\u675f\u65f6\u95f4");
        list.add("Service life \u670d\u52a1\u5e74\u9650");
        NewExportUtils.exportData(response, rs, "ContractListReportNEW.xlsx", selectFieldsTypeMap, list);
        return null;
    }
}

