/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas;

import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasContextFactory;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Json;

public class ACL {
    private static final Map<String, String> accessKeys = new HashMap<String, String>();
    private static final Map<String, Map<String, Pattern>> metaPatterns = new HashMap<String, Map<String, Pattern>>();

    public static String getAccessKey(String dataCenter) {
        String accessKey = accessKeys.get(dataCenter);
        if (accessKey != null) {
            return accessKey;
        }
        throw new IscBizException("\u8d26\u5957\uff08" + dataCenter + "\uff09\u672a\u90e8\u7f72\u96c6\u6210\u4e91\u8fde\u63a5\u4fe1\u606f\uff01\u8bf7\u4f7f\u7528\u201c\u8fde\u63a5\u914d\u7f6e - \u90e8\u7f72\u201d\u529f\u80fd\u5c06\u914d\u7f6e\u4fe1\u606f\u90e8\u7f72\u5230\u672cEAS\u73af\u5883\u3002");
    }

    static boolean isValid(String dataCenter, String name, String type) {
        Map<String, Pattern> patterns = metaPatterns.get(dataCenter);
        if (patterns == null) {
            return false;
        }
        Pattern p = patterns.get(type);
        if (p == null) {
            return false;
        }
        return p.matcher(name).matches();
    }

    public static String[] getDataCenters() {
        return accessKeys.keySet().toArray(new String[accessKeys.size()]);
    }

    static void init(Map<String, String> config) {
        for (Map.Entry<String, String> e : config.entrySet()) {
            String key = e.getKey();
            String content = e.getValue();
            if (key.indexOf(46) < 0) {
                if (content.length() == 32) {
                    accessKeys.put(key, content);
                    continue;
                }
                Map loginInfo = (Map)Json.toObject((String)Cipher.decrypt((String)content));
                accessKeys.put(key, (String)loginInfo.get("key"));
                ConnectorCallback.registerLoginInfo((String)key, (Map)loginInfo);
                EventBindingUtil.registerLoginInfo((Map)loginInfo);
                continue;
            }
            ACL.putPatterns(key, content);
        }
    }

    private static void putPatterns(String key, String content) {
        int j = key.indexOf(46);
        String dataCenter = key.substring(0, j).trim();
        Map<String, Pattern> patterns = ACL.getPatterns(dataCenter);
        String type = key.substring(j + 1).trim();
        Pattern pattern = Pattern.compile(content);
        patterns.put(type, pattern);
    }

    private static Map<String, Pattern> getPatterns(String dataCenter) {
        Map<String, Pattern> patterns = metaPatterns.get(dataCenter);
        if (patterns == null) {
            patterns = new HashMap<String, Pattern>();
            metaPatterns.put(dataCenter, patterns);
        }
        return patterns;
    }

    static void initFromDB() {
        String[][] aisInfo = SchedulerUtils.getDataCenterInfos();
        if (aisInfo == null) {
            return;
        }
        int i = 0;
        while (i < aisInfo.length) {
            String jndiUrl = aisInfo[i][2];
            if (jndiUrl == null || !jndiUrl.endsWith("_Query")) {
                String dataCenter = aisInfo[i][0];
                ACL.init(dataCenter);
            }
            ++i;
        }
    }

    public static void init(String dataCenter) {
        Connection cn = null;
        try {
            try {
                cn = DbConnector.getConnection((String)dataCenter);
                if (!EasContextFactory.exists(cn, "T_ISC_HUB_SERVER")) {
                    IscHubConfigUtil.createIscHubServerTable((Connection)cn, (String)"CLOB");
                }
                if (!EasContextFactory.exists(cn, "T_ISC_HUB_PERMIT")) {
                    IscHubConfigUtil.createIscHubPermitTable((Connection)cn, (String)"CLOB");
                }
                EasContextFactory.initEachDC(dataCenter);
                Map loginInfo = IscHubConfigUtil.loadIscHubServerInfo((Connection)cn, (String)dataCenter);
                if (loginInfo != null) {
                    accessKeys.put(dataCenter, (String)loginInfo.get("key"));
                    IscHubConfigUtil.loadIscHubPermissions((Connection)cn, (String)dataCenter);
                }
            }
            catch (Throwable error) {
                EasContext.getErrLogger().warn((Object)("\u521d\u59cb\u5316\u5f02\u5e38\uff1a" + dataCenter), error);
                DbUtil.close((Connection)cn, (boolean)false);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    public static String decrypt(String queryString, String key) {
        String text;
        try {
            text = Cipher.decrypt((String)queryString, (String)key);
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null && e.getMessage().contains("\u5bc6\u7801\u9519\u8bef")) {
                throw new IscBizException("\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u524d\u5f80\u8fde\u63a5\u7ba1\u7406-\u8fde\u63a5\u914d\u7f6e\u6d4b\u8bd5\u8fde\u63a5\u662f\u5426\u6b63\u5e38\uff0c\u5982\u679c\u6d4b\u8bd5\u5f02\u5e38\u53ef\u4ee5\u5c1d\u8bd5\u91cd\u65b0\u90e8\u7f72\u3002\u5982\u679c\u82cd\u7a79\u73af\u5883\u4e0e\u5f53\u524d\u8d26\u5957\u4e0d\u4e00\u81f4\u5219\u9700\u8981\u91cd\u65b0\u90e8\u7f72\u3002\u5982\u679c\u6709\u591a\u4e2a\u96c6\u6210\u4e91\u8fde\u63a5\u540c\u4e00\u4e2aEAS\u8d26\u5957\uff0c\u5219\u8bf7\u4ec5\u4fdd\u7559\u4e00\u4e2a\u96c6\u6210\u4e91\u8fde\u63a5\u8be5\u8d26\u5957\uff1b\u4e00\u4e2a\u96c6\u6210\u4e91\u53ef\u4ee5\u8fde\u63a5\u591a\u4e2aEAS\u8d26\u5957\uff0c\u4f46\u4e00\u4e2aEAS\u8d26\u5957\u4ec5\u5141\u8bb8\u8fde\u63a5\u4e00\u4e2a\u96c6\u6210\u4e91\u3002EAS\u8fde\u63a5\u5f02\u5e38\u53ef\u901a\u8fc7\u201c\u90e8\u7f72-\u68c0\u67e5\u90e8\u7f72\u4fe1\u606f\u201d\u68c0\u67e5\u90e8\u7f72\u5dee\u5f02\uff0c\u5e76\u6309\u7167\u89e3\u51b3\u5efa\u8bae\u4fee\u590d\u3002", (Throwable)e);
            }
            throw e;
        }
        return text;
    }

    public static void removeAccessKeys(String dataCenter) {
        accessKeys.remove(dataCenter);
    }
}

