/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.TaskExecutor;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class Util {
    public static void checkPermission(ConnectorContext ctx, String sql, Map<String, Object> params, ConnectorContext.Operation op) {
        String table_name = Util.getTableName(sql);
        if (!Util.isValid(ctx, op, table_name)) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u975e\u6cd5\u8bbf\u95ee\uff1a%s", "Util_7", "isc-iscb-util", new Object[0]), table_name));
        }
        String command = D.s(params.get("command"));
        ctx.logger(command, sql, params);
    }

    private static boolean isValid(ConnectorContext ctx, ConnectorContext.Operation op, String table_name) {
        if ("T_ISC_HUB_SERVER".equalsIgnoreCase(table_name)) {
            return false;
        }
        if ("T_ISC_HUB_PERMIT".equalsIgnoreCase(table_name)) {
            return ConnectorContext.Operation.READ == op;
        }
        if (ctx.isValid(table_name, op)) {
            return true;
        }
        if (table_name.startsWith("T_ISC_") || table_name.startsWith("T_ISCB_")) {
            return ConnectorContext.Operation.READ == op;
        }
        return false;
    }

    public static String getTableName(String sql) {
        if (D.s(sql) == null) {
            throw new IscBizException(ResManager.loadKDString("SQL\u8bed\u53e5\u4e0d\u53ef\u4e3a\u7a7a\u3002", "Util_1", "isc-iscb-util", new Object[0]));
        }
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return Util.getFromSelect(sql);
        }
        if (sql.startsWith("update") || sql.startsWith("UPDATE")) {
            return Util.getFromUpdate(sql);
        }
        if (sql.startsWith("delete") || sql.startsWith("DELETE")) {
            return Util.getFromSelect(sql);
        }
        if (sql.startsWith("insert") || sql.startsWith("INSERT")) {
            return Util.getFromInsert(sql);
        }
        if (sql.startsWith("create table ") || sql.startsWith("CREATE TABLE ")) {
            return sql.substring("create table ".length(), sql.indexOf(40)).trim();
        }
        if (sql.startsWith("truncate table ") || sql.startsWith("TRUNCATE TABLE ")) {
            return sql.substring("truncate table ".length()).trim();
        }
        if (sql.startsWith("/*dialect*/")) {
            return Util.getFromSelect(sql);
        }
        throw new IllegalArgumentException(sql);
    }

    private static String getFromInsert(String sql) {
        int i = sql.indexOf("into ");
        if (i < 0) {
            i = sql.indexOf("INTO ");
        }
        if (i < 0) {
            throw new IllegalArgumentException(sql);
        }
        int j = sql.indexOf(40);
        return sql.substring(i + "into ".length(), j).trim();
    }

    private static String getFromUpdate(String sql) {
        int i = DbUtil.findMinIndex(sql, "set ", 0);
        if (i < 0) {
            throw new IllegalArgumentException(sql);
        }
        return sql.substring("update ".length(), i).trim();
    }

    private static boolean isQNameChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '_' || c == '.' || c == '\"' || c == '@' || c == '(';
    }

    private static String getFromSelect(String sql) {
        int i = DbUtil.findFrom(sql);
        i += "from ".length();
        while (i < sql.length() && !Util.isQNameChar(sql.charAt(i))) {
            ++i;
        }
        if (sql.charAt(i) == '(') {
            int j;
            if ((j = Util.findRightBracket(sql, ++i)) <= sql.length()) {
                String subQuery = sql.substring(i, j).trim();
                return Util.getFromSelect(subQuery);
            }
        } else {
            int j = Util.findEndOfTableName(sql, i);
            if (j <= sql.length()) {
                return sql.substring(i, j).trim();
            }
        }
        throw new IllegalArgumentException(sql);
    }

    private static int findEndOfTableName(String sql, int i) {
        int j = i + 1;
        while (j < sql.length() && Util.isQNameChar(sql.charAt(j))) {
            ++j;
        }
        return j;
    }

    private static int findRightBracket(String sql, int i) {
        int count = 1;
        int j = i;
        while (j < sql.length()) {
            char c = sql.charAt(j);
            if (c == '(') {
                ++count;
            } else if (c == ')' && --count == 0) break;
            ++j;
        }
        return j;
    }

    public static Map<String, String> ini2map(String config) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = config.split("\\r|\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i;
            String item = stringArray[n2];
            if (item != null && !item.startsWith("#") && (i = item.indexOf(61)) > 0) {
                String key = item.substring(0, i).trim();
                String value = item.substring(i + 1).trim();
                if (key.length() > 0 && value.length() > 0) {
                    map.put(key, value);
                }
            }
            ++n2;
        }
        return map;
    }

    public static void asyncExecTask(Runnable task) {
        TaskExecutor.INSTANCE.get().execute(task);
    }
}

