/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.model;

import kd.isc.iscb.util.flow.core.i.model.NodeImpl;

public abstract class Pattern
implements Comparable<Pattern> {
    private String name;
    private String[] mutex;
    private int priority;
    public static final int PRIORITY_HIGH = 200;
    public static final int PRIORITY_NORMAL = 500;
    public static final int PRIORITY_LOW = 700;
    public static final String BIZ = "BIZ";
    public static final String TRANSIT = "TRANSIT";
    public static final String AS_START = "AS_START";
    public static final String AS_END = "AS_END";
    public static final String MERGE = "MERGE";
    public static final String CALL_CHILDREN = "CALL_CHILDREN";
    public static final String CANCEL_CHILDREN = "VAR_CANCEL_CHILDREN";
    public static final String EXIT_EXCLUSIVE = "EXIT_EXCLUSIVE";

    public Pattern(int priority, String name, String ... mutex) {
        if (mutex == null || mutex.length == 0) {
            throw new IllegalArgumentException("Mutex is null!");
        }
        this.name = name;
        this.mutex = (String[])mutex.clone();
        this.priority = priority;
    }

    public final String[] getMutex() {
        return (String[])this.mutex.clone();
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final int compareTo(Pattern o) {
        int i1 = this.priority;
        int i2 = o.getPriority();
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return 0;
    }

    public int getPriority() {
        return this.priority;
    }

    public abstract void apply(NodeImpl var1);
}

