/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.stream;

import javax.script.ScriptContext;
import kd.isc.iscb.util.script.LifeScriptContext;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.accessor.NameAccessorImpl;
import kd.isc.iscb.util.script.accessor.PathAccessor;
import kd.isc.iscb.util.script.data.Schema;
import kd.isc.iscb.util.script.data.Tuple;
import kd.isc.iscb.util.script.feature.control.stream.Utils;

public interface ValueGetter {
    public static final ValueGetter CURRENT = new ValueGetter(){

        @Override
        public Object eval(ScriptContext ctx, Object src) {
            return src;
        }
    };

    public Object eval(ScriptContext var1, Object var2);

    public static class ExprGetter
    implements ValueGetter {
        private Object expr;

        public ExprGetter(Object expr) {
            this.expr = expr;
        }

        @Override
        public Object eval(ScriptContext ctx, Object src) {
            LifeScriptContext current = PathAccessor.createScriptContext(ctx, src, ctx, new Object[0]);
            return Util.eval(current, this.expr);
        }
    }

    public static class PropGetter
    implements ValueGetter {
        private Object stub;
        private String prop;
        private int line;

        public PropGetter(Object stub, String prop, int line) {
            this.stub = stub;
            this.prop = prop;
            this.line = line;
        }

        @Override
        public Object eval(ScriptContext ctx, Object src) {
            return NameAccessorImpl.getValue(this.stub, this.prop, src, true, this.line);
        }
    }

    public static class TupleGetter
    implements ValueGetter {
        private Object[] expr;
        private Schema schema;

        public TupleGetter(Object[] expr) {
            this.schema = Utils.createSchema(expr);
            this.expr = expr;
        }

        @Override
        public Object eval(ScriptContext ctx, Object src) {
            LifeScriptContext current = PathAccessor.createScriptContext(ctx, src, ctx, new Object[0]);
            Object[] args = Util.evalArray(current, this.expr);
            return new Tuple(this.schema, args);
        }
    }
}

