/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsOverTimeBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsOverTimeBillInfo;
import com.kingdee.eas.hr.ats.OverTimeCompensInfo;
import com.kingdee.eas.hr.ats.OverTimeTypeInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ats.web.handler.PerAtsOverTimeBillBatchEditHandler;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.customer.gtiit.util.BaseUtil;
import com.kingdee.shr.customer.gtiit.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;
import org.springframework.util.LinkedMultiValueMap;

public class PerAtsOverTimeBillBatchEditHandlerEx
extends PerAtsOverTimeBillBatchEditHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.customer.gtiit.handler.PerAtsOverTimeBillBatchEditHandlerEx");

    public void workMultipleAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String otDate = request.getParameter("otDate");
        logger.error((Object)("\u52a0\u73ed\u65e5\u671f\uff1a" + otDate));
        String sql = "SELECT b.CFWORKMULTIPLE FROM T_HR_ATS_LegalHoliday a left join T_HR_ATS_LegalHolidayItem b on a.fid = b.FGROUPID where a.FSTATE = '1' and b.FSTARTDATE <= '" + otDate + "' and b.FENDDATE >= '" + otDate + "'";
        logger.error((Object)("\u67e5\u8be2\u52a0\u73ed\u7c7b\u578bSQL\uff1a" + sql));
        Map<String, Map<String, String>> overTimeTypeMap = BaseUtil.getOverTimeType(ctx);
        Map<Object, Object> returnMap = new HashMap();
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                if (iRowSet.getString("CFWORKMULTIPLE").equals("1")) {
                    returnMap = overTimeTypeMap.get("001");
                    continue;
                }
                if (iRowSet.getString("CFWORKMULTIPLE").equals("2")) {
                    returnMap = overTimeTypeMap.get("002");
                    continue;
                }
                if (!iRowSet.getString("CFWORKMULTIPLE").equals("3")) continue;
                returnMap = overTimeTypeMap.get("003");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        JSONUtils.writeJson((HttpServletResponse)response, returnMap);
    }

    public void jobTypeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Calendar calendar = Calendar.getInstance();
        Context ctx = SHRContext.getInstance().getContext();
        Map<String, Map<String, String>> overTimeTypeMap = BaseUtil.getOverTimeType(ctx);
        Map<Object, Object> returnMap = new HashMap();
        String otDate = request.getParameter("otDate");
        logger.error((Object)("\u52a0\u73ed\u65e5\u671f:" + otDate));
        Date parseDate = DateTimeUtils.parseDate(otDate, "yyyy-MM-dd");
        calendar.setTime(parseDate);
        int dayOfWeek = calendar.get(7);
        returnMap = dayOfWeek == 7 || dayOfWeek == 1 ? overTimeTypeMap.get("002") : overTimeTypeMap.get("001");
        JSONUtils.writeJson((HttpServletResponse)response, returnMap);
    }

    protected void verifyModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        super.verifyModel(request, response, model);
        this.checkOverTime(model);
        this.checkCompensate(model);
    }

    protected void beforeSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        super.beforeSubmit(request, response, model);
        this.checkOverSubmitDate();
        this.checkOverTime(model);
        this.checkCompensate(model);
        this.countSumTime(model);
    }

    private void countSumTime(CoreBaseInfo model) throws ShrWebBizException {
        logger.error((Object)"\u8fdb\u5165\u591a\u4eba\u52a0\u73ed\u5355\u63d0\u4ea4\u91cd\u7b97\u65f6\u95f4\u65b9\u6cd5");
        AtsOverTimeBillInfo billInfo = (AtsOverTimeBillInfo)model;
        logger.error((Object)("\u52a0\u73ed\u5355ID\uff1a" + billInfo.getId()));
        AtsOverTimeBillEntryCollection entries = billInfo.getEntries();
        BigDecimal weekdayHour = BigDecimal.ZERO;
        BigDecimal restdayHour = BigDecimal.ZERO;
        BigDecimal holidayHour = BigDecimal.ZERO;
        BigDecimal totalDuration = BigDecimal.ZERO;
        BigDecimal compensatoryTotal = BigDecimal.ZERO;
        BigDecimal totalOvertimePay = BigDecimal.ZERO;
        int i = 0;
        while (i < entries.size()) {
            AtsOverTimeBillEntryInfo entryInfo = entries.get(i);
            String otTypeId = "";
            String otCompensId = "";
            OverTimeTypeInfo otType = entryInfo.getOtType();
            BigDecimal applyOtTime = entryInfo.getApplyOTTime() == null ? BigDecimal.ZERO : entryInfo.getApplyOTTime();
            OverTimeCompensInfo otCompens = entryInfo.getOtCompens();
            if (otType != null) {
                otTypeId = otType.getId().toString();
            }
            if (otCompens != null) {
                otCompensId = otCompens.getId().toString();
            }
            if (StringUtils.equals((CharSequence)otTypeId, (CharSequence)"rBy0u1YgQ9C1OxcM85mxyY6C/nU=")) {
                weekdayHour = weekdayHour.add(applyOtTime);
            } else if (StringUtils.equals((CharSequence)otTypeId, (CharSequence)"zr+ur5D4RA+2bdVZ2VPqp46C/nU=")) {
                restdayHour = restdayHour.add(applyOtTime);
            } else if (StringUtils.equals((CharSequence)otTypeId, (CharSequence)"sRWUOt7sRpOY0TCo6NMqGY6C/nU=")) {
                holidayHour = holidayHour.add(applyOtTime);
            }
            if (StringUtils.equals((CharSequence)otCompensId, (CharSequence)"AERg0TIcSnaM40EKvJCdRKlrTmA=")) {
                compensatoryTotal = compensatoryTotal.add(applyOtTime);
            } else if (StringUtils.equals((CharSequence)otCompensId, (CharSequence)"zkbt5bMLQ3ehUivmKbtBOqlrTmA=")) {
                totalOvertimePay = totalOvertimePay.add(applyOtTime);
            }
            ++i;
        }
        totalDuration = weekdayHour.add(restdayHour).add(holidayHour);
        billInfo.put("weekdayHour", (Object)weekdayHour);
        billInfo.put("restdayHour", (Object)restdayHour);
        billInfo.put("holidayHour", (Object)holidayHour);
        billInfo.put("totalDuration", (Object)totalDuration);
        billInfo.put("compensatoryTotal", (Object)compensatoryTotal);
        billInfo.put("totalOvertimePay", (Object)totalOvertimePay);
    }

    private void checkOverSubmitDate() throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        String sql = "select fname_l1 from T_HR_ATS_OverTimeReason where fnumber = 'zbjbsj001'";
        int day = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                day = rowSet.getInt("fname_l1");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (day == 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        int thisDay = calendar.get(5);
        if (thisDay > day) {
            throw new ShrWebBizException("Not allowed to submit last month's overtime application after the " + day + "th");
        }
    }

    private void checkCompensate(CoreBaseInfo model) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        AtsOverTimeBillInfo billInfo = (AtsOverTimeBillInfo)model;
        AtsOverTimeBillEntryCollection entries = billInfo.getEntries();
        HashSet<String> personIdSet = new HashSet<String>();
        String compenSql = "select fid from T_HR_ATS_OverTimeCompens where fnumber='002'";
        String compenId = "";
        try {
            IRowSet compenRowSet = DbUtil.executeQuery((Context)ctx, (String)compenSql);
            if (compenRowSet.next()) {
                compenId = compenRowSet.getString("fid");
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < entries.size()) {
            AtsOverTimeBillEntryInfo entryInfo = entries.get(i);
            if (StringUtils.equals((CharSequence)entryInfo.getOtCompens().getId().toString(), (CharSequence)compenId)) {
                personIdSet.add(entryInfo.getPerson().getId().toString());
            }
            ++i;
        }
        logger.error((Object)("\u5458\u5de5ID\u96c6\u5408\uff1a" + ((Object)personIdSet).toString()));
        StringBuffer strBuffer = new StringBuffer();
        for (String personId : personIdSet) {
            strBuffer.append("'" + personId + "',");
        }
        if (strBuffer.length() > 0) {
            strBuffer = strBuffer.deleteCharAt(strBuffer.length() - 1);
            Map<String, String> personIdByNameMap = BaseUtil.getPersonIdByName(ctx, personIdSet);
            String sql = "SELECT p.fid,emp.jobgradename FROM t_bd_person p left join (select gra.fname_l2 jobgradename,e.fpersonid from (SELECT FPERSONID,max(fleffdt) as maxDate FROM T_HR_EmpPostExperienceHis group by  FPERSONID) as h left join T_HR_EmpPostExperienceHis e on e.fpersonid= h.FPERSONID and fleffdt = h.maxDate left join (SELECT * FROM T_HR_EmpPostRank where fislatest='1') r on r.fpersonid = e.fpersonid left join T_HR_JobGrade gra on gra.fid=r.fjobgradeid) emp on p.fid=emp.fpersonid where p.fid in (" + strBuffer.toString() + ")";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rowSet.next()) {
                    int gradeLevel;
                    String jobGradeName = rowSet.getString("jobgradename");
                    if (!StringUtils.isNotBlank((CharSequence)jobGradeName) || (gradeLevel = Integer.parseInt(jobGradeName = jobGradeName.replace("L", ""))) < 8) continue;
                    throw new ShrWebBizException("Employee (" + personIdByNameMap.get(rowSet.getString("fid")) + ") with a rank greater than or equal to L8 is not allowed to submit overtime compensation forms with overtime pay as the compensation type");
                }
                String personTypeSql = "SELECT a.fid,e.fnumber FROM T_BD_Person a left join (select b.fpersonid,c.CFWorkercategoryID from (SELECT FPERSONID,max(FEFFDT) as maxDate FROM T_HR_EmpOrgRelation where fassignType = '1' and fislatestinaday = '1' group by FPERSONID) b left join T_HR_EmpOrgRelation c on b.fpersonid = c.fpersonid and b.maxdate=c.FEFFDT and c.fassignType = '1' and c.fislatestinaday = '1') d on a.fid=d.fpersonid left join CT_MP_WorkerCategory e on e.fid=d.CFWorkercategoryID where a.fid in (" + strBuffer.toString() + ")";
                IRowSet personTypeRow = DbUtil.executeQuery((Context)ctx, (String)personTypeSql);
                while (personTypeRow.next()) {
                    String workCategoryNumber = personTypeRow.getString("fnumber");
                    if (!StringUtils.equals((CharSequence)"GTIIT_FACULTY", (CharSequence)workCategoryNumber) && !StringUtils.equals((CharSequence)"GTIIT_OTHER", (CharSequence)workCategoryNumber)) continue;
                    throw new ShrWebBizException("Employee (" + personIdByNameMap.get(personTypeRow.getString("fid")) + ") is an academic staff member and cannot submit overtime compensation forms with overtime pay as the compensation method");
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkOverTime(CoreBaseInfo model) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        AtsOverTimeBillInfo billInfo = (AtsOverTimeBillInfo)model;
        AtsOverTimeBillEntryCollection entries = billInfo.getEntries();
        LinkedMultiValueMap multiMap = new LinkedMultiValueMap();
        StringBuffer personIdBuffer = new StringBuffer();
        int i = 0;
        while (i < entries.size()) {
            block12: {
                AtsOverTimeBillEntryInfo entryInfo = entries.get(i);
                if (entryInfo.getOtType().getString("id").equals("rBy0u1YgQ9C1OxcM85mxyY6C/nU=")) {
                    block11: {
                        Date otDate = entryInfo.getOtDate();
                        String dateFormat = DateTimeUtils.dateFormat(otDate, "yyyy-MM-dd");
                        String sql = "SELECT b.CFWORKMULTIPLE FROM T_HR_ATS_LegalHoliday a left join T_HR_ATS_LegalHolidayItem b on a.fid = b.FGROUPID where a.FSTATE = '1' and b.FSTARTDATE <= '" + dateFormat + "' and b.FENDDATE >= '" + dateFormat + "'";
                        try {
                            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                            if (!iRowSet.next()) break block11;
                            break block12;
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    HashMap<String, Timestamp> map = new HashMap<String, Timestamp>();
                    map.put("startTime", entryInfo.getStartTime());
                    map.put("endTime", entryInfo.getEndTime());
                    multiMap.add((Object)entryInfo.getPerson().getString("id"), map);
                    personIdBuffer.append("'" + entryInfo.getPerson().getString("id") + "',");
                }
            }
            ++i;
        }
        Map<String, String> personIdByNameMap = BaseUtil.getPersonIdByName(ctx, multiMap.keySet());
        if (personIdBuffer.length() > 0) {
            String sql = "SELECT a.FPROPOSERID,c.FRESTPRETIME,c.FRESTNEXTTIME FROM T_HR_ATS_AttendanceFile a left join T_HR_ATS_Shift b on a.FATSSHIFTID = b.fid left join T_HR_ATS_ShiftItem c on c.FGROUPID = b.fid where FPROPOSERID in (" + personIdBuffer.deleteCharAt(personIdBuffer.length() - 1) + ") and  a.FATTENDFILESTATE = '" + "1" + "'";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rowSet.next()) {
                    String personId = rowSet.getString("FPROPOSERID");
                    String restStart = rowSet.getObject("FRESTPRETIME") == null ? "12:00" : rowSet.getString("FRESTPRETIME");
                    String restEnd = rowSet.getObject("FRESTNEXTTIME") == null ? "13:30" : rowSet.getString("FRESTNEXTTIME");
                    List list = multiMap.get((Object)personId);
                    for (Map dateMap : list) {
                        Date startTime = (Date)dateMap.get("startTime");
                        Date endTime = (Date)dateMap.get("endTime");
                        Instant startInstant = startTime.toInstant();
                        Instant endInstant = endTime.toInstant();
                        LocalTime startLocalTime = startInstant.atZone(ZoneId.systemDefault()).toLocalTime();
                        LocalTime endLocalTime = endInstant.atZone(ZoneId.systemDefault()).toLocalTime();
                        LocalTime shiftStartTime = LocalTime.parse(restStart);
                        LocalTime shiftendTime = LocalTime.parse(restEnd);
                        if (startLocalTime.compareTo(shiftendTime) >= 0 || endLocalTime.compareTo(shiftStartTime) <= 0 || (startLocalTime.compareTo(shiftStartTime) < 0 || startLocalTime.compareTo(shiftendTime) > 0) && (endLocalTime.compareTo(shiftStartTime) < 0 || endLocalTime.compareTo(shiftendTime) > 0)) continue;
                        throw new ShrWebBizException("Employee (" + personIdByNameMap.get(personId) + ") cannot work overtime during rest time on weekdays");
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

