/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.service.job.util.SQL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.InitDataHandler;
import kd.isc.iscb.util.bean.BatchTriggerInfo;
import kd.isc.iscb.util.bean.EachTriggerInfo;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.InitResult;
import kd.isc.iscb.util.connector.InitStatus;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class BindingHandler
implements InitDataHandler {
    @Override
    public InitResult checkState(String dataCenter, JSONObject jsonObject) {
        InitResult result = new InitResult(InitStatus.NEED_NOT_INIT, null);
        BatchTriggerInfo batchTrigger = (BatchTriggerInfo)JSON.toJavaObject((JSON)jsonObject, BatchTriggerInfo.class);
        List iscTriggers = batchTrigger.getTriggers();
        String sql = "select * from T_ISCB_CON_EVT_BND order by ftrigger_id";
        ArrayList<?> easTriggers = this.executeQuery(dataCenter, sql);
        if (iscTriggers.size() != easTriggers.size()) {
            this.setTriggerCountNotMatched(result);
        } else {
            this.checkTriggerContent(result, batchTrigger, iscTriggers, easTriggers);
        }
        return result;
    }

    private void checkTriggerContent(InitResult result, BatchTriggerInfo batchTrigger, List<EachTriggerInfo> iscTriggers, ArrayList<?> easTriggers) {
        int i = 0;
        while (i < iscTriggers.size()) {
            EachTriggerInfo eachTriggerInfo = iscTriggers.get(i);
            Map record = (Map)easTriggers.get(i);
            if (!D.s(record.get("fisc_hub")).equals(batchTrigger.getIscHub())) {
                this.setIscHubDismatched(result);
            } else if (eachTriggerInfo.getTriggerId() != D.l(record.get("ftrigger_id"))) {
                this.setTriggerOrderDismatched(result);
            } else if (!eachTriggerInfo.getEvents().equals(record.get("fevents"))) {
                this.setTriggerEventsDismatched(result, eachTriggerInfo, record);
            } else {
                this.setTriggerDataRequiresDismatched(result, eachTriggerInfo, record);
            }
            if (result.getStatus() != InitStatus.NEED_NOT_INIT) break;
            ++i;
        }
    }

    private void setTriggerDataRequiresDismatched(InitResult result, EachTriggerInfo eachTriggerInfo, Map<String, Object> record) {
        String iscMd5;
        String easMd5 = Hash.md5((String)((String)record.get("frequired_fields")));
        if (!easMd5.equals(iscMd5 = Hash.md5((String)eachTriggerInfo.getRequires()))) {
            result.setStatus(InitStatus.NEED_INIT);
            result.setErrorStack("id\u4e3a" + eachTriggerInfo.getTriggerId() + "\u7684\u4e8b\u4ef6\u542f\u52a8\u65b9\u6848\u7684\u6e90\u5b57\u6bb5\u4e0d\u4e00\u81f4,eas\u7684\u4e3a " + record.get("frequired_fields") + ",\u82cd\u7a79\u7684\u4e3a" + eachTriggerInfo.getRequires());
        }
    }

    private void setTriggerEventsDismatched(InitResult result, EachTriggerInfo eachTriggerInfo, Map<String, Object> record) {
        String dbEvts = D.s((Object)record.get("fevents")).replace(" ", "");
        if (!eachTriggerInfo.getEvents().replace(" ", "").equals(dbEvts)) {
            result.setStatus(InitStatus.NEED_INIT);
            result.setErrorStack("id\u4e3a" + eachTriggerInfo.getTriggerId() + "\u7684\u4e8b\u4ef6\u542f\u52a8\u65b9\u6848\u4e24\u8fb9\u7684\u76d1\u542c\u7684\u4e8b\u4ef6\u4e0d\u4e00\u81f4");
        }
    }

    private void setTriggerOrderDismatched(InitResult result) {
        result.setStatus(InitStatus.NEED_INIT);
        result.setErrorStack("\u4e24\u8fb9\u4e8b\u4ef6\u89e6\u53d1id\u6392\u5e8f\u540e\u4e0d\u4e00\u81f4\uff0c\u9700\u521d\u59cb\u5316");
    }

    private void setIscHubDismatched(InitResult result) {
        result.setStatus(InitStatus.NEED_INIT);
        result.setErrorStack("\u5b58\u5728\u4e0d\u5c5e\u4e8e\u8be5\u82cd\u7a79\u7684\u4e8b\u4ef6\u7ed1\u5b9a\u6570\u636e\uff0c\u9700\u521d\u59cb\u5316");
    }

    private void setTriggerCountNotMatched(InitResult result) {
        result.setStatus(InitStatus.NEED_INIT);
        result.setErrorStack("\u82cd\u7a79\u4e0eeas\u4e8b\u4ef6\u7ed1\u5b9a\u7684\u4e2a\u6570\u4e0d\u76f8\u7b49\uff0c\u9700\u521d\u59cb\u5316");
    }

    private ArrayList<?> executeQuery(String dataCenter, String sql) {
        try {
            return SQL.executeQuery((String)dataCenter, (String)sql);
        }
        catch (BOSException e) {
            throw DatabaseError.SQL_QUERY_FAILURE.wrap((Throwable)e);
        }
    }

    @Override
    public InitResult init(String dataCenter, JSONObject jsonObject) {
        InitResult result = new InitResult(InitStatus.NEED_NOT_INIT, null);
        try {
            InitResult checkResult = this.checkState(dataCenter, jsonObject);
            if (checkResult.getStatus() == InitStatus.NEED_INIT) {
                this.initEventListeners(dataCenter, jsonObject);
                result.setStatus(InitStatus.INIT_COMPLETE);
            }
        }
        catch (Throwable e) {
            result.setStatus(InitStatus.INIT_ERROR);
            result.setErrorStack(StringUtil.toString((Throwable)e));
        }
        return result;
    }

    private void initEventListeners(String dataCenter, JSONObject jsonObject) throws BOSException {
        BatchTriggerInfo batchTrigger = (BatchTriggerInfo)JSON.toJavaObject((JSON)jsonObject, BatchTriggerInfo.class);
        Connection cn = DbConnector.getConnection((String)dataCenter);
        try {
            String sql = "delete from T_ISCB_CON_EVT_BND";
            DbUtil.executeUpdate((Connection)cn, (String)sql);
            this.saveTriggerInfo(batchTrigger, cn);
            EventBindingCache.init((String)dataCenter, (Connection)cn);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public void saveTriggerInfo(BatchTriggerInfo batchTrigger, Connection cn) {
        List triggers = batchTrigger.getTriggers();
        for (EachTriggerInfo triggerInfo : triggers) {
            EventBindingUtil.saveEvents((Connection)cn, (String)batchTrigger.getIscHub(), (String)triggerInfo.getEntity(), (EventBindingUtil.TriggerType)(triggerInfo.getTriggerType() != null ? triggerInfo.getTriggerType() : EventBindingUtil.TriggerType.DataCopyTrigger), (long)triggerInfo.getTriggerId(), (String[])triggerInfo.getEvents().replace(" ", "").split(","), (Map)((Map)Json.toObject((String)triggerInfo.getRequires())));
        }
    }
}

