/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodCollection;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.bos.workflow.biz.EventUtils;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.Util;
import kd.isc.connector.eas.e.util.WorkflowHandleUtil;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public final class InitiateWorkflow
extends AbstractCommandExecutor {
    public String getCommand() {
        return "initiate_workflow";
    }

    protected Object exec(ConnectorContext conContext, Map<String, Object> params) {
        String proxy_user = D.s((Object)params.get("proxyUser"));
        Context context = Util.generateBosCtx(conContext, proxy_user);
        String exceptionName = "\u5355\u636eId\u5217\u8868idList\u7684\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002";
        String[] billIds = WorkflowHandleUtil.getIds(params, "idList", exceptionName);
        List<WfBizEvent> wfs = this.checkAllValid(conContext, params, billIds);
        this.startWorkFlow(context, wfs);
        try {
            return WorkflowHandleUtil.getWorkFlowStateById(conContext, "FREFID", billIds);
        }
        catch (Exception e) {
            EasContext.getErrLogger().error((Object)"\u6267\u884cqueryWorkflowState\u6307\u4ee4\u51fa\u9519\u3002", (Throwable)e);
            throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
        }
    }

    private void startWorkFlow(Context context, List<WfBizEvent> wfs) {
        WfTxContext wfContext = WfTxContext.beginTx((Context)context);
        try {
            int i = 0;
            while (i < wfs.size()) {
                try {
                    WfEngine.getEngine((Context)context).acceptEvent(wfs.get(i));
                }
                catch (WfException e) {
                    EasContext.getErrLogger().error((Object)"\u6267\u884cinitiate_workflow\u6307\u4ee4\u51fa\u9519\u3002", (Throwable)e);
                    throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
                }
                ++i;
            }
        }
        finally {
            wfContext.endTx();
        }
    }

    private List<WfBizEvent> checkAllValid(ConnectorContext conContext, Map<String, Object> params, String[] billIds) {
        String proxy_user = D.s((Object)params.get("proxyUser"));
        Context context = Util.generateBosCtx(conContext, proxy_user);
        String operation = D.s((Object)params.get("operation"));
        String entity = D.s((Object)params.get("entity"));
        Map<Object, Object> wfProperties = new HashMap();
        try {
            this.checkEntityByBosType(context, entity, billIds);
            BOSObjectType bosType = BOSUuid.read((String)billIds[0]).getType();
            List<Map<String, String>> entityMethodRef = this.getEntityMethodRefByOperate(context, bosType, operation);
            if (entityMethodRef.isEmpty()) {
                throw new IscBizException("\u5b9e\u4f53\u540d\u79f0\uff1a" + entity + "\u4e0a\u6ca1\u6709\u5bf9\u5e94\u7684\u65b9\u6cd5:" + operation);
            }
            wfProperties = this.createPropertiesByMethodId(context, entityMethodRef);
            if (wfProperties.isEmpty()) {
                throw new IscBizException("\u5b9e\u4f53\u540d\u79f0\uff1a" + entity + "\u64cd\u4f5c\uff1a" + operation + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94Function");
            }
            this.checkWorkFlowById(conContext, billIds);
        }
        catch (Exception e) {
            EasContext.getErrLogger().error((Object)"\u6267\u884cinitiate_workflow\u6307\u4ee4\u51fa\u9519\u3002", (Throwable)e);
            throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
        }
        ArrayList<WfBizEvent> wfs = new ArrayList<WfBizEvent>();
        int i = 0;
        while (i < billIds.length) {
            WfBizEvent wf = new WfBizEvent();
            wf.setBoundBoId(billIds[i]);
            wf.setBoId(billIds[i]);
            wf.setUserId(proxy_user);
            wf.setExtendProperties((Map)params.get("extendInfo"));
            wf.putExtendProperty((Object)"CTRL_SHIFT_ALT", (Object)true);
            wf.setFuncName((String)wfProperties.get("funcName"));
            wf.setOperationName((String)wfProperties.get("operationName"));
            wf.setEventName((String)wfProperties.get("eventName"));
            wfs.add(wf);
            ++i;
        }
        return wfs;
    }

    private void checkEntityByBosType(Context ctx, String entity, String[] billIds) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        int i = 0;
        while (i < billIds.length) {
            BOSObjectType bosType = BOSUuid.read((String)billIds[i]).getType();
            String entityName = loader.getEntity(bosType).getFullName();
            if (!entityName.equals(entity)) {
                throw new IscBizException("\u5b9e\u4f53\u540d\u79f0\u4e0e\u5355\u636eId\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u5b9e\u4f53\u540d\u79f0\uff1a" + entity + ",\u5355\u636eid\uff1a" + billIds[i]);
            }
            ++i;
        }
    }

    private Map<String, String> createPropertiesByMethodId(Context ctx, List<Map<String, String>> list) throws WfException {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        int i = 0;
        while (i < list.size()) {
            String methodId = String.valueOf(list.get(i).get("innerID")) + list.get(i).get("bosType");
            BizEventMap.EventStructEntry[] eventMapEntry = EventUtils.getByMethod((Context)ctx, (String)methodId);
            if (eventMapEntry != null && eventMapEntry.length > 0) {
                propertyMap.put("funcName", eventMapEntry[0].getFunction());
                propertyMap.put("operationName", eventMapEntry[0].getOperation());
                propertyMap.put("eventName", list.get(i).get("eventName"));
                return propertyMap;
            }
            ++i;
        }
        return propertyMap;
    }

    private List<Map<String, String>> getEntityMethodRefByOperate(Context ctx, BOSObjectType bosType, String operate) {
        ArrayList<Map<String, String>> entityMethodRef = new ArrayList<Map<String, String>>();
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        IMetaDataPK entityPk = loader.getEntityObjectPK(bosType);
        EntityObjectInfo entityInfo = (EntityObjectInfo)MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getBusinessObject(entityPk);
        EventCollection events = entityInfo.getEvents();
        int i = 0;
        while (i < events.size()) {
            EventInfo eventInfo = events.get(i);
            EventMethodCollection eventMethods = eventInfo.getEventMethods();
            int j = 0;
            while (j < eventMethods.size()) {
                EventMethodInfo eventMethodInfo = eventMethods.get(j);
                MethodInfo methodInfo = eventMethodInfo.getMethodRef();
                if (operate.equals(methodInfo.getName())) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("innerID", methodInfo.getInnerID());
                    properties.put("eventName", eventInfo.getName());
                    properties.put("bosType", bosType.toString());
                    entityMethodRef.add(properties);
                }
                ++j;
            }
            ++i;
        }
        return entityMethodRef;
    }

    private void checkWorkFlowById(ConnectorContext conContext, String[] billIds) throws Exception {
        List<Map<String, Object>> list = WorkflowHandleUtil.getWorkFlowStateById(conContext, "FREFID", billIds);
        ArrayList<String> exitWorkflow = new ArrayList<String>();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).get("billObjId") != null) {
                exitWorkflow.add(list.get(i).get("billObjId").toString());
            }
            ++i;
        }
        if (exitWorkflow != null && exitWorkflow.size() > 0) {
            throw new Exception("\u5355\u636eids\uff1a" + exitWorkflow + "\u5df2\u7ecf\u5173\u8054\u5de5\u4f5c\u6d41\uff0c\u7981\u6b62\u91cd\u65b0\u542f\u52a8\u5de5\u4f5c\u6d41\u3002");
        }
    }
}

