/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.util.DbConnector;
import java.sql.Connection;
import java.util.Map;
import kd.isc.connector.eas.ACL;
import kd.isc.connector.eas.ClearCacheUtil;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasContextFactory;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.misc.Json;

public class PushPermission
extends AbstractCommandExecutor {
    public String getCommand() {
        return "push_permission";
    }

    protected Boolean exec(ConnectorContext ctx, Map<String, Object> params) {
        EasContext easContext = (EasContext)ctx;
        String dataCenter = easContext.getDataCenter();
        this.savePermission(params, dataCenter);
        ACL.init(dataCenter);
        ClearCacheUtil.clearMembersCache(easContext.getProtocal(), dataCenter, easContext.getQueryString());
        return true;
    }

    private void savePermission(Map<String, Object> params, String dataCenter) {
        String key = EasContextFactory.getDeployKey(dataCenter);
        String data = ACL.decrypt(D.s((Object)params.get("data")), key);
        Map permission = (Map)Json.toObject((String)data);
        Connection cn = this.getConnection(dataCenter);
        try {
            IscHubConfigUtil.clearIscHubPermissions((Connection)cn);
            for (Map.Entry e : permission.entrySet()) {
                String meta = (String)e.getKey();
                String permit = (String)e.getValue();
                IscHubConfigUtil.saveIscHubPermit((Connection)cn, (String)meta, (String)permit);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    private Connection getConnection(String dataCenter) {
        try {
            return DbConnector.getConnection((String)dataCenter);
        }
        catch (BOSException e) {
            throw DatabaseError.CONNECTION_FAILURE.create((Throwable)e, new String[]{dataCenter});
        }
    }
}

