/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.meta;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.EasThreadParamUtil;
import kd.isc.connector.eas.e.GetEntityInfo;
import kd.isc.connector.eas.meta.AbstractSetter;
import kd.isc.connector.eas.meta.DataTypeParser;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class EntriesSetter
extends AbstractSetter {
    private BOSObjectType bostype;

    public BOSObjectType getBostype() {
        return this.bostype;
    }

    public void setBostype(BOSObjectType bostype) {
        this.bostype = bostype;
    }

    public EntriesSetter(BOSObjectType bostype) {
        this.bostype = bostype;
    }

    @Override
    public void set(IObjectValue info, String property, Object value, Map<String, IObjectValue> entries) {
        if (!((value = this.prehandleEntryValue(value)) instanceof List)) {
            throw new IscBizException("property: " + property + " value is not a List : " + value);
        }
        this.setEntryPropertyValue(info, entries, property, value);
    }

    private void setEntryPropertyValue(IObjectValue info, Map<String, IObjectValue> entries, String property, Object value) {
        List params = (List)value;
        EntityObjectInfo entryEntityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)EasThreadParamUtil.getCtx()).getEntity(this.bostype);
        IObjectCollection dataCollection = this.getDataCollection(info, property, entryEntityInfo);
        List<String> entryJudgeFields = this.getJudgeFields(property);
        Map<String, IObjectValue> oldData = this.constructJudgeKeyToBillEntryMap(dataCollection, entryJudgeFields);
        String clzObjectValueName = entryEntityInfo.getObjectValueClass();
        for (Map param : params) {
            if (oldData.size() == 0) {
                this.addNewItem(dataCollection, entryEntityInfo, clzObjectValueName, param, entries);
                continue;
            }
            this.handleExistsEntry(entries, entryEntityInfo, dataCollection, entryJudgeFields, oldData, clzObjectValueName, param);
        }
        if (oldData.size() > 0) {
            for (IObjectValue o : oldData.values()) {
                dataCollection.removeObject(o);
            }
        }
        info.put(property, (Object)dataCollection);
    }

    private void handleExistsEntry(Map<String, IObjectValue> entries, EntityObjectInfo entryEntityInfo, IObjectCollection dataCollection, List<String> entryJudgeFields, Map<String, IObjectValue> oldData, String clzObjectValueName, Map<String, Object> param) {
        String judgeKey = this.generateJudgeKey(entryJudgeFields, param);
        IObjectValue entryInfo = oldData.get(judgeKey);
        if (entryInfo == null) {
            this.addNewItem(dataCollection, entryEntityInfo, clzObjectValueName, param, entries);
        } else {
            this.setPropVal(entryEntityInfo, param, entryInfo, false, entries);
            dataCollection.addObject(entryInfo);
            oldData.remove(judgeKey);
        }
    }

    private String generateJudgeKey(List<String> entryJudgeFields, Map<String, Object> param) {
        StringBuilder sb = new StringBuilder();
        for (String judgeField : entryJudgeFields) {
            sb.append(D.s((Object)param.get(judgeField)));
        }
        String judgeKey = sb.toString();
        return judgeKey;
    }

    private List<String> getJudgeFields(String property) {
        Map<String, List<String>> judgeFields = EasThreadParamUtil.getJudgeFields();
        List<String> entryJudgeFields = judgeFields.get(property);
        if (entryJudgeFields == null || entryJudgeFields.size() == 0) {
            entryJudgeFields = this.findEntryJudgeFields(property, judgeFields, entryJudgeFields);
            this.checkEntryJudgeFields(property, entryJudgeFields);
        }
        return entryJudgeFields;
    }

    private IObjectCollection getDataCollection(IObjectValue info, String property, EntityObjectInfo entryEntityInfo) {
        IObjectCollection dataCollection = (IObjectCollection)info.get(property);
        if (dataCollection == null) {
            dataCollection = this.newEntries(entryEntityInfo);
        }
        return dataCollection;
    }

    private void checkEntryJudgeFields(String property, List<String> entryJudgeFields) {
        if (entryJudgeFields == null || entryJudgeFields.size() == 0) {
            throw new IscBizException("\u5206\u5f55[" + property + "]\u6ca1\u6709\u8bbe\u7f6e\u5019\u9009\u952e");
        }
    }

    private List<String> findEntryJudgeFields(String property, Map<String, List<String>> judgeFields, List<String> entryJudgeFields) {
        for (Map.Entry<String, List<String>> entry : judgeFields.entrySet()) {
            if (!entry.getKey().contains(".") || !entry.getKey().endsWith(property)) continue;
            entryJudgeFields = entry.getValue();
            break;
        }
        return entryJudgeFields;
    }

    private Object prehandleEntryValue(Object value) {
        if (value == null) {
            value = Collections.emptyList();
        }
        if (value instanceof Map) {
            value = Arrays.asList(value);
        }
        return value;
    }

    private IObjectCollection newEntries(EntityObjectInfo entryEntityInfo) {
        try {
            Class clazz = entryEntityInfo.getObjectCollectionClazzRuntime();
            IObjectCollection dataCollection = (IObjectCollection)clazz.newInstance();
            return dataCollection;
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    private void addNewItem(IObjectCollection dataCollection, EntityObjectInfo entryEntityInfo, String clzObjectValueName, Map<String, Object> param, Map<String, IObjectValue> entries) {
        IObjectValue entryInfo = this.newEntry(clzObjectValueName);
        if (entryInfo instanceof CoreBillBaseCustomEntryInfo) {
            ((CoreBillBaseCustomEntryInfo)entryInfo).setBOSType(this.bostype);
        }
        this.setPropVal(entryEntityInfo, param, entryInfo, true, entries);
        dataCollection.addObject(entryInfo);
    }

    private IObjectValue newEntry(String clzObjectValueName) {
        try {
            return (IObjectValue)Class.forName(clzObjectValueName).newInstance();
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    private Map<String, IObjectValue> constructJudgeKeyToBillEntryMap(IObjectCollection dataCollection, List<String> entryJudgeFields) {
        HashMap<String, IObjectValue> oldData = new HashMap<String, IObjectValue>();
        int i = 0;
        while (i < dataCollection.size()) {
            IObjectValue obj = dataCollection.getObject(i);
            this.generateEntryJudgeKey(entryJudgeFields, oldData, obj);
            ++i;
        }
        return oldData;
    }

    private void generateEntryJudgeKey(List<String> entryJudgeFields, Map<String, IObjectValue> oldData, IObjectValue obj) {
        StringBuilder sb = new StringBuilder();
        for (String judgeField : entryJudgeFields) {
            if (obj.get(judgeField) != null) {
                this.appendJudgeFieldValue(obj, sb, judgeField);
                continue;
            }
            throw new IscBizException("\u5206\u5f55[" + obj + "]\u4e0a\u5019\u9009\u952e[" + judgeField + "]\u7684\u503c\u4e3a\u7a7a");
        }
        IObjectValue prevObj = oldData.put(sb.toString(), obj);
        if (prevObj != null) {
            throw new IscBizException("\u6839\u636e\u5206\u5f55\u5019\u9009\u952e" + entryJudgeFields + "\u4f1a\u627e\u5230\u591a\u6761\u6570\u636e:" + obj + "---" + prevObj);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendJudgeFieldValue(IObjectValue obj, StringBuilder sb, String judgeField) {
        if (obj.get(judgeField).toString() == null) {
            if (!(obj.get(judgeField) instanceof IObjectValue)) throw new IscBizException("\u5206\u5f55[" + obj + "]\u4e0a\u5019\u9009\u952e[" + judgeField + "]toString\u4e3anull\u7c7b\u578b\u662f" + obj.get(judgeField).getClass());
            sb.append(((IObjectValue)obj.get(judgeField)).get("id").toString());
            return;
        } else {
            sb.append(D.s((Object)obj.get(judgeField)));
        }
    }

    private void setPropVal(EntityObjectInfo entryEntityInfo, Map<String, Object> param, IObjectValue entryInfo, boolean addNew, Map<String, IObjectValue> entries) {
        param.remove("$pk");
        String source_oid = D.s((Object)param.remove("$id"));
        if (source_oid != null) {
            entries.put(source_oid, entryInfo);
        }
        for (Map.Entry<String, Object> e : param.entrySet()) {
            if (this.isIgnored(addNew, e)) continue;
            PropertyInfo p = entryEntityInfo.getPropertyByNameRuntime(e.getKey());
            this.checkProperty(entryEntityInfo, e, p);
            Map<String, Object> dataType = GetEntityInfo.getDataType(p, entryEntityInfo);
            this.checkDataType(entryEntityInfo, e, dataType);
            AbstractSetter setter = DataTypeParser.getSetter(dataType, p, entryEntityInfo);
            setter.setValue(entryInfo, e.getKey(), e.getValue(), entries);
        }
    }

    private void checkDataType(EntityObjectInfo entryEntityInfo, Map.Entry<String, Object> e, Map<String, Object> dataType) {
        if (dataType.get("name") == null) {
            throw new IscBizException("\u5b57\u6bb5[" + e.getKey() + "]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\u7c7b\u578b,\u8bf7\u68c0\u67e5\u5b9e\u4f53[" + entryEntityInfo.getName() + "]\u4e2d\u5b57\u6bb5\u662f\u5426\u5b58\u5728");
        }
    }

    private void checkProperty(EntityObjectInfo entryEntityInfo, Map.Entry<String, Object> e, PropertyInfo p) {
        if (p == null || p.cvalue() == null) {
            throw new IscBizException("\u5b9e\u4f53[" + entryEntityInfo.getName() + "]\u627e\u4e0d\u5230\u5b57\u6bb5\u5c5e\u6027" + e.getKey());
        }
    }

    private boolean isIgnored(boolean addNew, Map.Entry<String, Object> e) {
        String key = e.getKey();
        if (key.equals("parent")) {
            return true;
        }
        if (!addNew && key.equals("id")) {
            return true;
        }
        return key.startsWith("$") || key.startsWith("#");
    }
}

