/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.customer.salary.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.bill.salary.ISalaryBag;
import com.kingdee.eas.custom.bill.salary.SalaryBagEntryCollection;
import com.kingdee.eas.custom.bill.salary.SalaryBagEntryInfo;
import com.kingdee.eas.custom.bill.salary.SalaryBagFactory;
import com.kingdee.eas.custom.bill.salary.SalaryBagInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ImportException;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class SalaryBagEditHandler
extends EditHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.customer.salary.handler.SalaryBagEditHandler");

    public void getSoureBillDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        String billId = request.getParameter("billId");
        System.out.print("\u5de5\u8d44\u5305\u53d8\u66f4\u6765\u6e90billId=========" + billId);
        Context ctx = SHRContext.getInstance().getContext();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            String selectSql = "SELECT  b.fid as personId,b.FNAME_l2 as personName, c.FID as cmpItemId ,c.FNAME_l2 as cmpItemName,a.CFPaycurrency  FROM CT_SAL_SalaryBag a  left join t_bd_person b on a.CFPersonID = b.FID  left join T_HR_SCmpItem c on a.CFCmpItemID = c.fid  where a.fid = '" + billId + "'";
            System.out.print("\u5de5\u8d44\u5305\u53d8\u66f4sql=========" + selectSql);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String cmpItemId = null;
            String cmpItemName = null;
            if (rs.next()) {
                cmpItemId = rs.getString("cmpItemId");
                cmpItemName = rs.getString("cmpItemName");
                resultMap.put("personId", rs.getString("personId"));
                resultMap.put("personName", rs.getString("personName"));
                resultMap.put("paycurrency", rs.getString("CFPaycurrency"));
                resultMap.put("cmpItemId", cmpItemId);
                resultMap.put("cmpItemName", cmpItemName);
            }
            SalaryBagInfo salaryBagInfo = SalaryBagFactory.getLocalInstance((Context)ctx).getSalaryBagInfo((IObjectPK)new ObjectUuidPK(billId));
            resultMap.put("money", salaryBagInfo.getMoney());
            resultMap.put("startDate", salaryBagInfo.getStartDate());
            resultMap.put("endDate", salaryBagInfo.getEndDate());
            SalaryBagEntryCollection entryCollection = salaryBagInfo.getEntrys();
            ArrayList entryList = new ArrayList();
            if (entryCollection != null && entryCollection.size() > 0) {
                int i = 0;
                int size = entryCollection.size();
                while (i < size) {
                    SalaryBagEntryInfo info = entryCollection.get(i);
                    HashMap<String, Object> entryMap = new HashMap<String, Object>();
                    entryMap.put("months", info.getMonths());
                    entryMap.put("paycurrency", salaryBagInfo.get("paycurrency"));
                    entryMap.put("cmpItemId", cmpItemId);
                    entryMap.put("cmpItemName", cmpItemName);
                    entryMap.put("moneys", info.getMoneys());
                    entryMap.put("beforeAmount", info.getMoneys());
                    entryMap.put("amountPayable", 0);
                    entryMap.put("reissueAmount", 0);
                    entryList.add(entryMap);
                    ++i;
                }
            }
            resultMap.put("entry", entryList);
            System.out.print("\u5de5\u8d44\u5305resultMap=========" + resultMap);
            JSONUtils.writeJson((HttpServletResponse)response, resultMap);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void createEntryDetailAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        String startDateStr = request.getParameter("startDate");
        String endDateStr = request.getParameter("endDate");
        String reissueDateStr = request.getParameter("reissueDate");
        String money = request.getParameter("money");
        String billId = request.getParameter("billId");
        Context ctx = SHRContext.getInstance().getContext();
        try {
            String selectSql = "SELECT  b.fid as personId,b.FNAME_l2 as personName, c.FID as cmpItemId ,c.FNAME_l2 as cmpItemName,a.CFPaycurrency,a.CFendDate  FROM CT_SAL_SalaryBag a  left join t_bd_person b on a.CFPersonID = b.FID  left join T_HR_SCmpItem c on a.CFCmpItemID = c.fid  where a.fid = '" + billId + "'";
            System.out.print("\u5de5\u8d44\u5305\u53d8\u66f4sql=========" + selectSql);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String cmpItemId = null;
            String cmpItemName = null;
            String paycurrency = null;
            Date soureEndDate = null;
            if (rs.next()) {
                cmpItemId = rs.getString("cmpItemId");
                cmpItemName = rs.getString("cmpItemName");
                paycurrency = rs.getString("CFPaycurrency");
                soureEndDate = rs.getDate("CFendDate");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            java.util.Date endDate = sdf.parse(endDateStr);
            java.util.Date reissueDate = sdf.parse(reissueDateStr);
            if (soureEndDate.after(endDate)) {
                throw new ImportException("The expiration date cannot be earlier than the expiration date of the original document");
            }
            List<java.util.Date> monthList = this.getMonthDetail(startDateStr, endDateStr);
            System.out.print("\u6708\u4efd=========" + monthList.size());
            ArrayList resultList = new ArrayList();
            BigDecimal moneyAmount = new BigDecimal(money);
            BigDecimal avgAmount = moneyAmount.divide(BigDecimal.valueOf(monthList.size()), 0, 4);
            BigDecimal remainder = new BigDecimal(0);
            BigDecimal amountPayable = new BigDecimal(0);
            int i = 0;
            while (i < monthList.size()) {
                HashMap<String, Object> entryMap = new HashMap<String, Object>();
                java.util.Date months = monthList.get(i);
                entryMap.put("months", months);
                entryMap.put("paycurrency", paycurrency);
                entryMap.put("cmpItemId", cmpItemId);
                entryMap.put("cmpItemName", cmpItemName);
                if (monthList.size() - i > 1) {
                    remainder = remainder.add(avgAmount);
                } else {
                    avgAmount = moneyAmount.subtract(remainder);
                }
                entryMap.put("moneys", avgAmount);
                BigDecimal beforeAmount = this.getBeforeAmount(billId, sdf.format(months));
                entryMap.put("beforeAmount", beforeAmount);
                if (monthList.get(i).equals(reissueDate)) {
                    entryMap.put("reissueAmount", 0);
                    entryMap.put("amountPayable", amountPayable.add(avgAmount));
                } else if (monthList.get(i).after(reissueDate)) {
                    if (avgAmount.compareTo(beforeAmount) < 0) {
                        entryMap.put("amountPayable", 0);
                    } else {
                        entryMap.put("amountPayable", avgAmount);
                    }
                    entryMap.put("reissueAmount", 0);
                } else {
                    entryMap.put("amountPayable", 0);
                    entryMap.put("reissueAmount", avgAmount.subtract(beforeAmount));
                    amountPayable = amountPayable.add(avgAmount.subtract(beforeAmount));
                }
                System.out.print("\u6708\u4efdresult=========" + entryMap);
                resultList.add(entryMap);
                ++i;
            }
            JSONUtils.writeJson((HttpServletResponse)response, resultList);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private BigDecimal getBeforeAmount(String billId, String months) throws BOSException, SQLException {
        Context ctx = SHRContext.getInstance().getContext();
        BigDecimal beforeAmount = new BigDecimal(0);
        String selectSql = "SELECT CFMoneys FROM  CT_SAL_SalaryBagEntry where FBillID = '" + billId + "' and to_char(CFMonths,'yyyy-MM-dd') = '" + months + "'";
        System.out.print("\u67e5\u627e\u53d8\u66f4\u524d\u91d1\u989d=========" + selectSql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        if (rs.next()) {
            beforeAmount = rs.getBigDecimal("CFMoneys");
        }
        return beforeAmount;
    }

    private List<java.util.Date> getMonthDetail(String startDateStr, String endDateStr) throws ParseException {
        SimpleDateFormat sdfMonth = new SimpleDateFormat("yyyy-MM");
        java.util.Date startDate = sdfMonth.parse(startDateStr);
        java.util.Date endDate = sdfMonth.parse(endDateStr);
        java.util.Date currentDate = startDate;
        ArrayList<java.util.Date> monthList = new ArrayList<java.util.Date>();
        Calendar calendar = Calendar.getInstance();
        while (endDate.after(currentDate) || currentDate.equals(endDate)) {
            monthList.add(currentDate);
            calendar.setTime(currentDate);
            calendar.add(2, 1);
            currentDate = calendar.getTime();
        }
        return monthList;
    }

    protected void verifyModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        SalaryBagInfo billInfo = (SalaryBagInfo)model;
        BigDecimal billAmount = billInfo.getMoney();
        BigDecimal entryAmount = BigDecimal.ZERO;
        SalaryBagEntryCollection entryColl = billInfo.getEntrys();
        if (entryColl != null) {
            int i = 0;
            while (i < entryColl.size()) {
                SalaryBagEntryInfo entry = entryColl.get(i);
                entryAmount = entryAmount.add(entry.getMoneys());
                ++i;
            }
        }
        logger.error((Object)("\u5355\u5934\u91d1\u989d\uff1a" + billAmount + ",\u5206\u5f55\u91d1\u989d\u603b\u548c\uff1a" + entryAmount));
        if (billAmount.compareTo(entryAmount) != 0) {
            throw new ShrWebBizException("The amount split does not equal the total amount, please check !");
        }
        super.verifyModel(request, response, model);
    }

    public void checkDateAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException {
        boolean flag = true;
        String fid = request.getParameter("fid");
        String personId = request.getParameter("personId");
        String sourceBillId = request.getParameter("sourceBillId");
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        String cmpitemId = request.getParameter("cmpitemId");
        System.out.print("sourceBillId========" + sourceBillId);
        System.out.print("cmpitemId========" + cmpitemId);
        Context ctx = SHRContext.getInstance().getContext();
        StringBuffer dateSql = new StringBuffer();
        dateSql.append(" SELECT fnumber FROM CT_SAL_SalaryBag where FBillState = '3' ");
        dateSql.append(" and CFPersonID = '" + personId + "'");
        dateSql.append(" and (CFStartDate between '" + startDate + "' and '" + endDate + "'");
        dateSql.append(" or CFEndDate between '" + startDate + "'  and '" + endDate + "')");
        dateSql.append(" and CFCmpItemID = '" + cmpitemId + "'");
        if (StringUtils.isNotBlank((CharSequence)fid) && StringUtils.isNotBlank((CharSequence)sourceBillId)) {
            dateSql.append(" and fid not in ('" + fid + "' , '" + sourceBillId + "')");
        } else if (StringUtils.isNotBlank((CharSequence)fid)) {
            dateSql.append(" and fid != '" + fid + "' ");
        } else if (StringUtils.isNotBlank((CharSequence)sourceBillId)) {
            dateSql.append(" and fid != '" + sourceBillId + "'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)dateSql.toString());
        if (rs.next()) {
            flag = false;
        }
        JSONUtils.writeJson((HttpServletResponse)response, (Object)flag);
    }

    public void submitEffectAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws EASBizException, BOSException, SHRWebException, SQLException {
        System.out.println("\u5de5\u8d44\u5305\u63d0\u4ea4\u751f\u6548====" + modelMap);
        CoreBaseInfo model = (CoreBaseInfo)request.getAttribute("dynamic_model");
        Context ctx = SHRContext.getInstance().getContext();
        String currentid = model.getString("id");
        SalaryBagInfo demoInfo = null;
        if (StringUtils.isNotEmpty((CharSequence)currentid)) {
            demoInfo = SalaryBagFactory.getLocalInstance((Context)ctx).getSalaryBagInfo((IObjectPK)new ObjectUuidPK(currentid));
            HRBillStateEnum status = demoInfo.getBillState();
            if (status.getValue() != 0) {
                throw new SHRWebException("Documents that are in the process of being audited or have already been audited cannot be submitted !");
            }
        } else {
            demoInfo = (SalaryBagInfo)model;
        }
        this.beforeSave(request, response, model);
        try {
            ISalaryBag idemo = (ISalaryBag)MetaDataUtil.getBizInterface((String)"com.kingdee.eas.custom.bill.salary.app.SalaryBag");
            idemo.submitEffect(model);
        }
        catch (Exception e) {
            JSONUtils.ERROR((String)"Submission validation failure !");
        }
        this.afterSave(request, response, model);
        System.out.println("\u5de5\u8d44\u5355\u5df2\u63d0\u4ea4\u751f\u6548 : " + demoInfo.toString());
        System.out.println("\u6e90\u5355\u636e\u7f16\u7801\uff1a" + demoInfo.getSourceBillId());
        if (StringUtils.isNotBlank((CharSequence)demoInfo.getSourceBillId())) {
            String updateSql = "update CT_SAL_SalaryBag set FBillState = '1' where fid = '" + demoInfo.getSourceBillId() + "'";
            System.out.print("\u53d8\u66f4\u5355\u636e\u72b6\u6001\u66f4\u65b0=========" + updateSql);
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        String id = model.getId().toString();
        this.writeSuccessData(id);
    }
}

