/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Json;

public class EventBindingCache {
    private static final ReadLockFreeMap<String, Boolean> entities = new ReadLockFreeMap();
    private static final ReadLockFreeMap<Key, List<EventArgs>> bindings = new ReadLockFreeMap();

    public static List<EventArgs> find(String dataCenter, String entity, String event) {
        if (!entities.containsKey(entity)) {
            return Collections.emptyList();
        }
        return bindings.get(new Key(entity, dataCenter, event));
    }

    public static void init(String dataCenter, Connection cn) {
        EventBindingCache.removeBindingsByDC(dataCenter);
        String sql = "select fisc_hub,fentity,ftrigger_type,ftrigger_id,fevents,frequired_fields from T_ISCB_CON_EVT_BND";
        ObjectReader<DataRow> reader = DbUtil.executeQuery(cn, sql, Collections.<Object>emptyList(), Collections.<Integer>emptyList());
        HashMap<String, Boolean> entities = new HashMap<String, Boolean>();
        HashMap bindings = new HashMap();
        DataRow row = reader.read();
        while (row != null) {
            String entity = D.s(row.get("fentity"));
            String isc_hub = D.s(row.get("fisc_hub"));
            String trigger_type = D.s(row.get("ftrigger_type"));
            String trigger_id = D.s(row.get("ftrigger_id"));
            Map frequired_fields = (Map)Json.toObject(D.s(row.get("frequired_fields")));
            String[] events = D.s(row.get("fevents")).split(",");
            entities.put(entity, Boolean.TRUE);
            String[] stringArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                String event = stringArray[n2];
                Key key = new Key(entity, dataCenter, D.s(event));
                ArrayList<EventArgs> list = (ArrayList<EventArgs>)bindings.get(key);
                if (list == null) {
                    list = new ArrayList<EventArgs>(1);
                    bindings.put(key, list);
                }
                EventArgs value = new EventArgs(isc_hub, trigger_type, trigger_id, frequired_fields);
                list.add(value);
                ++n2;
            }
            row = reader.read();
        }
        EventBindingCache.entities.putAll(entities);
        EventBindingCache.bindings.putAll(bindings);
    }

    private static void removeBindingsByDC(String dataCenter) {
        ArrayList<Key> keys = new ArrayList<Key>();
        for (Key key : bindings.keySet()) {
            if (!dataCenter.equals(key.dataCenter)) continue;
            keys.add(key);
        }
        bindings.removeAll(keys);
    }

    public static final class EventArgs {
        private String trigger_type;
        private String trigger_id;
        private String isc_hub;
        private Map<String, Object> required_fields;

        public String getTriggerType() {
            return this.trigger_type;
        }

        public String getTriggerId() {
            return this.trigger_id;
        }

        public String getIscHub() {
            return this.isc_hub;
        }

        public Map<String, Object> getRequiredFields() {
            return this.required_fields;
        }

        public EventArgs(String isc_hub, String trigger_type, String trigger_id, Map<String, Object> required_fields) {
            this.isc_hub = isc_hub;
            this.trigger_type = trigger_type;
            this.trigger_id = trigger_id;
            this.required_fields = required_fields;
        }
    }

    public static final class Key {
        private String dataCenter;
        private String entity;
        private String event;

        public Key(String entity, String dataCenter, String event) {
            this.entity = entity;
            this.event = event;
            this.dataCenter = dataCenter;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dataCenter == null ? 0 : this.dataCenter.hashCode());
            result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
            result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.dataCenter == null ? other.dataCenter != null : !this.dataCenter.equals(other.dataCenter)) {
                return false;
            }
            if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
                return false;
            }
            return !(this.event == null ? other.event != null : !this.event.equals(other.event));
        }
    }
}

