/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.advanced;

import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.LockFactory;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.feature.control.advanced.DebuggableContainer;
import kd.isc.iscb.util.script.feature.control.advanced.Synchronized;

final class SynchronizedEvaluator
extends DebuggableContainer
implements Evaluator {
    private final Object lock;
    private final Object timeout;

    SynchronizedEvaluator(Object lock, Object timeout, Object body, int line) {
        super(body, line);
        this.lock = lock;
        this.timeout = timeout;
    }

    @Override
    public Object eval(ScriptContext ctx) {
        Object body = super.getBody(ctx);
        this.checkThreadLock();
        String s = this.getLockString(this.lock, ctx);
        int t = this.getTimeout(this.timeout, ctx);
        return this.run(body, ctx, s, t);
    }

    private void checkThreadLock() {
        String key = Synchronized.held_lock.get();
        if (key != null) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u5f53\u524d\u7ebf\u7a0b\u5df2\u6301\u6709\u9501\uff08%s\uff09\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u7533\u8bf7\u9501\u4ee5\u9632\u6b7b\u9501\uff01", "SynchronizedEvaluator_6", "isc-iscb-util", new Object[0]), key));
        }
    }

    private String getLockString(Object lock, ScriptContext ctx) {
        String s = D.s(Util.eval(ctx, lock));
        if (s == null) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u9501\u6807\u8bc6\uff08%s\uff09\u662f\u7a7a\u503c\uff01", "SynchronizedEvaluator_7", "isc-iscb-util", new Object[0]), lock));
        }
        return s;
    }

    private int getTimeout(Object timeout, ScriptContext ctx) {
        int t = D.i(Util.eval(ctx, timeout));
        if (t <= 0) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u8d85\u65f6\u8bbe\u7f6e\uff08%s\uff09\u4e0d\u5927\u4e8e0\uff01", "SynchronizedEvaluator_8", "isc-iscb-util", new Object[0]), timeout));
        }
        return t;
    }

    private Object run(Object body, ScriptContext ctx, String key, int timeout) {
        LockFactory.Lock lock = LockFactory.INSTANCE.get().getLock(key);
        try {
            Object object = this.tryRunWithLock(ctx, key, timeout, lock, body);
            return object;
        }
        finally {
            lock.close();
        }
    }

    private Object tryRunWithLock(ScriptContext ctx, String key, int timeout, LockFactory.Lock lock, Object body) {
        if (lock.tryLock(timeout)) {
            try {
                Object object = this.runWithLock(ctx, lock, key, body);
                return object;
            }
            finally {
                lock.unLock();
            }
        }
        throw CommonError.LOCK_TIMEOUT.create(String.valueOf(timeout), key);
    }

    private Object runWithLock(ScriptContext ctx, LockFactory.Lock lock, String key, Object body) {
        try {
            Synchronized.held_lock.set(key);
            Object object = Util.eval(ctx, body);
            return object;
        }
        finally {
            Synchronized.held_lock.remove();
        }
    }

    public String toString() {
        return "synchronized(" + this.lock + ")" + super.directGetBody();
    }
}

