/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.data;

import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.data.Schema;
import kd.isc.iscb.util.script.data.Struct;

public class StructBuilder
implements Constructor {
    @Override
    public String name() {
        return "struct";
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        int count = statement.length() - 1;
        if (count <= 0) {
            throw new IscBizException("No fields!");
        }
        String[] fields = new String[count];
        int i = 0;
        while (i < count) {
            Identifier id = (Identifier)pos.getOperand(statement, i);
            fields[i] = id.name();
            ++i;
        }
        final Schema schema = new Schema(fields);
        return new NativeFunction(){

            @Override
            public Object call(ScriptContext ctx, Object[] args) {
                if (args.length != schema.size()) {
                    Object[] params = new Object[schema.size()];
                    System.arraycopy(args, 0, params, 0, Math.min(params.length, args.length));
                    args = params;
                }
                return new Struct<Object>(schema, args);
            }

            @Override
            public String name() {
                return null;
            }
        };
    }
}

