/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class WFPassAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFPassAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum messageModel = null;
    private Map<String, Map<String, Object>> eidContentMap = null;

    public boolean isNeedSendXT() {
        return true;
    }

    public WFPassAdapter(Message message) {
        logger.debug((Object)"WFPassAdapter init");
        this.message = message;
        this.ctx = WFPassAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    public MessageModelEnum getModel() {
        return this.messageModel;
    }

    public Map<String, Object> getContent() {
        String urlPath;
        this.eidContentMap = this.eidContentMap == null ? new HashMap() : this.eidContentMap;
        String dbCode = this.ctx.getAIS();
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(dbCode);
        if (this.eidContentMap.get(eid) != null) {
            return this.eidContentMap.get(eid);
        }
        HashMap<String, Object> contents = new HashMap<String, Object>();
        Map<String, Object> parseContent = this.parseContent();
        contents.putAll(parseContent);
        String sourceIDs = this.message.getStringHeader("sourceIDs");
        String[] sourcdids = sourceIDs.replace("PASS::", "").split(":");
        String[] sourcdidsnew = sourceIDs.split("\\|");
        String fproinstid = sourcdids.length == 1 && sourcdidsnew.length > 1 ? sourcdidsnew[1] : sourcdids[0];
        String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
        String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
        String newEid = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "eid", "");
        String url = "";
        String assignId = "null".equals(sourcdids[5]) ? "" : sourcdids[5];
        String receiver = this.message.getStringHeader("receiver");
        String mbosurl = this.getMbosUrl(assignId, fproinstid, eid);
        String string = urlPath = host.indexOf("?") > -1 ? "&storeEid=21231&name=approveui.navui&" : "/passAssignDetail.html?";
        if (this.message.getStringHeader("titlel2").indexOf("\u4f20\u9605\u53cd\u9988") > -1) {
            String billID = sourcdidsnew[2];
            fproinstid = sourcdidsnew[1];
            String param = "eid=" + newEid + "&type=mysend&billID=" + URLEncoder.encode(billID) + "&appid=" + appId + "&fprocinstid=" + fproinstid + "&personName=senderl2" + "&personID=" + receiver;
            url = StringUtils.isEmpty((String)mbosurl) ? String.valueOf(host) + urlPath : String.valueOf(mbosurl.replace("page/loadPage", "mbosw/getWorkflowUrl")) + "&";
            url = String.valueOf(url) + (!StringUtils.isEmpty((String)mbosurl) && host.contains("&") ? host.substring(host.indexOf("&"), host.length()) : "");
            url = String.valueOf(url) + param;
        } else {
            String param = "eid=" + newEid + "&type=myreceive&appid=" + appId + "&billID=" + URLEncoder.encode(sourcdids[1]) + "&assignID=" + assignId + "&fprocinstid=" + fproinstid + "&personID=" + sourcdids[2] + "&isAllowrepass=" + sourcdids[4] + "&passId=" + sourcdids[6];
            url = StringUtils.isEmpty((String)mbosurl) ? String.valueOf(host) + urlPath : String.valueOf(mbosurl.replace("page/loadPage", "mbosw/getWorkflowUrl")) + "&";
            url = String.valueOf(url) + param;
        }
        Locale locale = this.getConfigLocale(eid);
        String wxtitle = "l1".equalsIgnoreCase(locale.getDisplayName()) ? "pass message" : "\u60a8\u6709\u4f20\u9605\u6d88\u606f";
        contents.put("url", url);
        contents.put("wxtitle", wxtitle);
        contents.put("assignId", assignId);
        contents.put("procinstid", fproinstid);
        contents.put("sendId", this.message.getStringHeader("initiatorId"));
        contents.put("receiver", receiver);
        contents.put("todo", "0");
        contents.put("appid", appId);
        if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)this.messageModel)) {
            String text = (String)parseContent.get("text");
            String itemtitle = text.replaceAll("\n[\\s\\S]*", "");
            contents.put("itemtitle", itemtitle);
            contents.put("text", text.replace(String.valueOf(itemtitle) + "\n", ""));
            contents.put("tagId", "notify");
            contents.put("assignId", UUID.randomUUID() + "LCZSITEM");
        }
        return contents;
    }

    private String getMbosUrl(String assignId, String fproinstId, String eid) {
        String actDefId;
        String procDefId;
        block7: {
            ActivityInstInfo[] actinsts;
            procDefId = "";
            actDefId = "";
            if (!StringUtils.isEmpty((String)fproinstId) && (actinsts = EnactmentServiceFactory.createEnactService((Context)this.ctx).getActInstMetaArrayByProcInstId(fproinstId)).length > 1) {
                ActivityInstInfo actinst = actinsts[1];
                procDefId = actinst.getProcDefId();
                actDefId = actinst.getActDefId();
            }
            if (!StringUtils.isEmpty((String)actDefId) && !StringUtils.isEmpty((String)actDefId)) break block7;
            return null;
        }
        try {
            IRowSet rowSet;
            StringBuffer sql = new StringBuffer("SELECT url FROM T_WFR_MBOS_WORKFLOW WHERE url like '%eid=" + eid + "%'");
            if (!StringUtils.isEmpty((String)actDefId)) {
                sql.append(" and actDefId in ('" + actDefId + "')");
            }
            if (!StringUtils.isEmpty((String)procDefId)) {
                sql.append(" and procdefid in ('" + procDefId + "')");
            }
            if ((rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString())).next()) {
                return rowSet.getString("url");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    private Map<String, Object> parseContent() {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String msgContent = "";
        String opinion = "";
        String userName = "";
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        Locale locale = this.getConfigLocale(eid);
        if (this.message.getStringHeader("titlel2").indexOf("\u4f20\u9605\u53cd\u9988") > -1) {
            userName = this.message.getLocaleStringHeader("sender", new Locale("L2"));
            opinion = this.message.getLocaleStringHeader("body", new Locale("L2"));
            userName = StringUtils.isEmpty((String)userName) ? "" : String.valueOf(userName) + "\u7684";
            msgContent = String.valueOf(msgContent) + userName + "\u4f20\u9605\u53cd\u9988";
            msgContent = String.valueOf(msgContent) + "\n" + this.message.getLocaleStringHeader("title", new Locale("L2"));
            opinion = StringUtils.isEmpty((String)userName) ? "" : opinion.replaceFirst("\u6536\u5230\u6765\u81ea[\\s\\S]+\u7684\u4f20\u9605\u53cd\u9988\u4fe1\u606f", "");
            opinion = opinion.replaceFirst("\u4f20\u9605\u53cd\u9988\\[[\\s\\S]+\\]", "");
            opinion = opinion.replaceFirst("\u4f20\u9605\u53cd\u9988\u4eba\uff1a[\\s\\S]*", "").replaceAll("\n", "").replaceAll("\r", "");
            msgContent = String.valueOf(msgContent) + "\n\u4f20\u9605\u53cd\u9988\u610f\u89c1\uff1a" + opinion;
        } else {
            String body = this.message.getLocaleStringHeader("body", new Locale("L2"));
            if (body.matches("\u4f20\u9605\\[[\\s\\S]+/\\*\u4ee5\u4e0b\u662f\u4f20\u9605\u610f\u89c1[\\s\\S]+\u4f20\u9605\u4eba :[\\s\\S]+\\*/")) {
                opinion = body.replaceAll("[\\s\\S]+/\\*\u4ee5\u4e0b\u662f\u4f20\u9605\u610f\u89c1", "").replaceAll("\u4f20\u9605\u4eba :[\\s\\S]+", "");
                userName = body.replaceAll("[\\s\\S]+\u4f20\u9605\u4eba :", "").replaceAll("\\*/", "").replaceAll("\n", "").replaceAll("\r", "");
            } else if (body.matches("\u4f20\u9605\\[[\\s\\S]+\u4f20\u9605\u4eba:[\\s\\S]+\u4f20\u9605\u610f\u89c1:[\\s\\S]+")) {
                opinion = body.replaceAll("[\\s\\S]+\u4f20\u9605\u610f\u89c1:", "").replaceAll("\"", "&quot;");
                userName = body.replaceAll("[\\s\\S]+\u4f20\u9605\u4eba:", "").replaceAll("\u4f20\u9605\u610f\u89c1:[\\s\\S]+", "").replaceAll("\n", "").replaceAll("\r", "");
            } else {
                String[] bodys = body.split("/*\u4ee5\u4e0b\u662f\u4f20\u9605\u610f\u89c1");
                if (bodys.length > 1) {
                    opinion = bodys[1].replaceAll("\n", "");
                    String[] opinions = opinion.split("\u4f20\u9605\u4eba :");
                    opinion = opinions[0];
                    userName = opinions[1].replace("*/", "");
                } else {
                    try {
                        String[] content = body.split("\u4f20\u9605\u4eba:");
                        String[] passInfo = content[1].split("\u4f20\u9605\u610f\u89c1:");
                        userName = passInfo[0].replace("\n", "");
                        opinion = passInfo[1];
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u4f20\u9605\u4fe1\u606f\u62fc\u63a5\u9519\u8bef\uff1a" + e.getMessage()));
                    }
                }
            }
            msgContent = String.valueOf(msgContent) + userName + "\u7684\u4f20\u9605";
            msgContent = String.valueOf(msgContent) + "\n" + this.message.getLocaleStringHeader("title", new Locale("L2"));
            msgContent = String.valueOf(msgContent) + "\n\u4f20\u9605\u610f\u89c1\uff1a" + opinion;
        }
        contents.put("text", msgContent);
        logger.info((Object)("XT Message parseContext() body=" + this.message.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + this.message.getLocaleStringHeader("title", new Locale("L2"))));
        return contents;
    }

    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String msgReceiver = this.message.getStringHeader("receiver");
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() get personID error!", (Throwable)e);
        }
        return list;
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private Locale getConfigLocale(String eid) {
        String localeStr = XTServiceConfig.getInstance().getLocale(eid);
        localeStr = StringUtils.isEmpty((String)localeStr) ? "L2" : localeStr;
        return LocaleUtils.getLocale((String)localeStr);
    }

    private void initMessageModel() {
        boolean ifInit = false;
        String apiVersion = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        try {
            if ("flowcenter".equalsIgnoreCase(apiVersion)) {
                String sourceIDs = this.message.getStringHeader("sourceIDs");
                String[] sourcdids = sourceIDs.replace("PASS::", "").split(":");
                String[] sourcdidsnew = sourceIDs.split("\\|");
                String procinstid = sourcdids.length == 1 && sourcdidsnew.length > 1 ? sourcdidsnew[1] : sourcdids[0];
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                String initiatorId = service.getProcessInstInfo(procinstid).getInitiatorId();
                this.message.setStringHeader("initiatorId", initiatorId);
                String quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? ";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)quarySql, (Object[])new Object[]{initiatorId, initiatorId});
                if (rowSet.next()) {
                    ifInit = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ifInitFlowCenterMoudle error!", (Throwable)e);
        }
        if (ifInit) {
            this.messageModel = MessageModelEnum.FLOWCENTERREAD;
        }
    }

    public static void main(String[] args) {
        Message newMessage = MessageFactory.newMessage();
        Locale locale = new Locale("L2");
        newMessage.setLocaleStringHeader("title", "aaa", locale);
        newMessage.setLocaleStringHeader("body", "bbb", locale);
        newMessage.setLocaleStringHeader("sender", "ccc", locale);
    }
}

