/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class WFUrgentAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFUrgentAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum MESSAGEMODEL = null;
    private Map<String, Map<String, Object>> eidContentMap = null;

    public boolean isNeedSendXT() {
        return true;
    }

    public WFUrgentAdapter(Message message) {
        logger.debug((Object)"WFUrgentAdapter init");
        this.message = message;
        this.ctx = WFUrgentAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    public MessageModelEnum getModel() {
        return this.MESSAGEMODEL;
    }

    public Map<String, Object> getContent() {
        this.eidContentMap = this.eidContentMap == null ? new HashMap() : this.eidContentMap;
        String dbCode = this.ctx.getAIS();
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(dbCode);
        if (this.eidContentMap.get(eid) != null) {
            return this.eidContentMap.get(eid);
        }
        HashMap<String, Object> contents = new HashMap<String, Object>();
        Map<String, Object> content = this.parseContent();
        contents.putAll(content);
        Locale locale = this.getConfigLocale(eid);
        String wxtitle = "l1".equalsIgnoreCase(locale.getDisplayName()) ? "urgent task" : "\u60a8\u6709\u50ac\u529e\u6d88\u606f";
        contents.put("wxtitle", wxtitle);
        String assignId = this.message.getStringHeader("sourceID");
        String process = this.message.getStringHeader("ProcessInstId");
        String host = instance.getPubAcctProperty(eid, "WFMessage", "host", "");
        String appId = instance.getPubAcctProperty(eid, "WFMessage", "appId", "");
        String newEid = instance.getPubAcctProperty(eid, "WFMessage", "eid", "");
        String path = host.indexOf("?") > -1 ? "&storeEid=21231&name=approveui.navui&viewtype=message" : "/dealWithNotice.html?viewtype=message";
        String param = "&eid=" + newEid + "&type=message&appid=" + appId + "&assignId=" + assignId + "&fprocinstid=" + process;
        String mbosUrl = this.getMbosUrl(assignId, eid);
        String url = StringUtils.isEmpty((String)mbosUrl) ? String.valueOf(host) + path : mbosUrl.replace("page/loadPage", "mbosw/getWorkflowUrl");
        url = String.valueOf(url) + (!StringUtils.isEmpty((String)mbosUrl) && host.contains("&") ? host.substring(host.indexOf("&"), host.length()) : "");
        url = String.valueOf(url) + param;
        contents.put("url", url);
        contents.put("appid", appId);
        contents.put("assignId", assignId);
        contents.put("procinstid", process);
        contents.put("sendId", this.message.getStringHeader("initiatorId"));
        contents.put("receiver", this.message.getStringHeader("receiver"));
        contents.put("todo", "0");
        if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)this.MESSAGEMODEL)) {
            contents.put("itemtitle", this.message.getLocaleStringHeader("title", locale));
            contents.put("text", this.message.getLocaleStringHeader("body", locale));
            contents.put("tagId", "notify");
            contents.put("assignId", UUID.randomUUID() + "LCZSITEM");
        }
        return contents;
    }

    private Map<String, Object> parseContent() {
        String msgContent;
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        Locale locale = this.getConfigLocale(eid);
        String msgTitle = this.message.getLocaleStringHeader("title", locale);
        String msgBody = this.message.getLocaleStringHeader("body", locale);
        msgTitle = StringUtils.isEmpty((String)msgTitle) ? msgBody : msgTitle;
        String string = msgContent = !StringUtils.isEmpty((String)msgBody) && msgBody.startsWith(msgTitle) ? "" : msgTitle;
        msgContent = StringUtils.isEmpty((String)msgContent) ? msgBody : String.valueOf(msgContent) + (StringUtils.isEmpty((String)msgBody) ? "" : "\n" + msgBody);
        contents.put("text", msgContent);
        return contents;
    }

    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message getUsers() msgReceiver: " + msgReceiver));
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() error!", (Throwable)e);
        }
        return list;
    }

    private String getMbosUrl(String assignid, String eid) {
        try {
            IRowSet rowSet;
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo info = svc.getAssignmentById(assignid);
            String procDefId = info.getProcDefId();
            String actDefId = info.getActDefId();
            StringBuffer sql = new StringBuffer("SELECT url FROM T_WFR_MBOS_WORKFLOW WHERE url like '%eid=" + eid + "%'");
            if (!StringUtils.isEmpty((String)actDefId)) {
                sql.append(" and actDefId in ('" + actDefId + "')");
            }
            if (!StringUtils.isEmpty((String)procDefId)) {
                sql.append(" and procdefid in ('" + procDefId + "')");
            }
            if ((rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString())).next()) {
                return rowSet.getString("url");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Locale getConfigLocale(String eid) {
        String localeStr = XTServiceConfig.getInstance().getLocale(eid);
        localeStr = StringUtils.isEmpty((String)localeStr) ? "L2" : localeStr;
        return LocaleUtils.getLocale((String)localeStr);
    }

    private void initMessageModel() {
        boolean ifInit = false;
        String apiVersion = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        try {
            if ("flowcenter".equalsIgnoreCase(apiVersion)) {
                String assignid = this.message.getStringHeader("sourceID");
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                String initiatorId = service.getProcessInstInfoByAssign(assignid).getInitiatorId();
                this.message.setStringHeader("initiatorId", initiatorId);
                String quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? ";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)quarySql, (Object[])new Object[]{initiatorId, initiatorId});
                if (rowSet.next()) {
                    ifInit = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ifInitFlowCenterMoudle error!", (Throwable)e);
        }
        if (ifInit) {
            this.MESSAGEMODEL = MessageModelEnum.FLOWCENTERNOTICE;
        }
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }
}

