/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.rpt;

import com.cloudera.impala.jdbc4.internal.apache.log4j.Logger;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONObject;
import org.springframework.ui.ModelMap;

public class DeclarationListHandler
extends ListHandler {
    Context ctx = SHRContext.getInstance().getContext();
    private static Logger logger1 = Logger.getLogger((String)"com.kingdee.shr.customer.gtiit.rpt.DeclarationListHandler");
    private int totalCount;

    public String getGridColModelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, SQLException {
        ArrayList<String> colNames = this.getcolNamesAction();
        List<Map<String, Object>> colModel = this.getcolModelAction();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        map.put("colNames", colNames);
        map.put("colModel", colModel);
        JSONUtils.writeJson((HttpServletResponse)response, map);
        return null;
    }

    public void getGridDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException {
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        String fastFilterItems = request.getParameter("fastFilterItems");
        JSONObject tofastFilterItems = new JSONObject(fastFilterItems);
        JSONObject periodEmploymentJson = tofastFilterItems.getJSONObject("periodEmployment");
        String pervalues = periodEmploymentJson.getString("values");
        String startDate = null;
        String endDate = null;
        if (pervalues != null && !pervalues.equals("")) {
            JSONObject periodEmploymentValues = periodEmploymentJson.getJSONObject("values");
            startDate = periodEmploymentValues.getString("startDate");
            endDate = periodEmploymentValues.getString("endDate");
        }
        JSONObject statusJson = tofastFilterItems.getJSONObject("status");
        String status = statusJson.getString("values");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getSql(startDate, endDate, status));
        ArrayList maplist = new ArrayList();
        int num = 0;
        while (rs.next()) {
            if (++num < rows * (page - 1) + 1 || num > rows * page) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Name", rs.getString("person"));
            map.put("FNumber", rs.getString("FNumber"));
            map.put("positionName", rs.getString("positionName"));
            map.put("CFSuperiorName", rs.getString("CFSuperiorName"));
            map.put("CFHourlyWage", rs.getBigDecimal("CFHourlyWage"));
            map.put("CFTotalWorkHours", rs.getBigDecimal("CFTotalWorkHours"));
            map.put("CFTotalAmount", rs.getBigDecimal("CFTotalAmount"));
            maplist.add(map);
        }
        this.totalCount = num;
        LinkedHashMap<String, Serializable> gridDataMap = new LinkedHashMap<String, Serializable>();
        if (this.totalCount % rows == 0) {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows));
        } else {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows + 1));
        }
        gridDataMap.put("page", Integer.valueOf(page));
        gridDataMap.put("records", Integer.valueOf(this.totalCount));
        gridDataMap.put("rows", maplist);
        JSONUtils.writeJson((HttpServletResponse)response, gridDataMap);
    }

    public ArrayList<String> getcolNamesAction() throws SHRWebException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Person Number \u804c\u5de5\u53f7");
        list.add("Name \u59d3\u540d");
        list.add("Position \u804c\u4f4d");
        list.add("Line Manager \u76f4\u5c5e\u4e0a\u7ea7");
        list.add("Hourly Rate \u65f6\u85aa");
        list.add("Working Hours \u5de5\u65f6\u6570");
        list.add("Total Payment \u603b\u5de5\u8d44");
        return list;
    }

    public List<Map<String, Object>> getcolModelAction() {
        ArrayList<Map<String, Object>> modelColList = new ArrayList<Map<String, Object>>();
        modelColList.add(this.buildColModelMap("FNumber", "Person Number \u804c\u5de5\u53f7", 70));
        modelColList.add(this.buildColModelMap("Name", "Name \u59d3\u540d", 70));
        modelColList.add(this.buildColModelMap("positionName", "Position \u804c\u4f4d", 70));
        modelColList.add(this.buildColModelMap("CFSuperiorName", "Line Manager \u76f4\u5c5e\u4e0a\u7ea7", 70));
        modelColList.add(this.buildColModelMap("CFHourlyWage", "Hourly Rate \u65f6\u85aa", 70));
        modelColList.add(this.buildColModelMap("CFTotalWorkHours", "Working Hours \u5de5\u65f6\u6570", 70));
        modelColList.add(this.buildColModelMap("CFTotalAmount", "Total Payment \u603b\u5de5\u8d44", 70));
        return modelColList;
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width) {
        return this.buildColModelMap(index, label, width, false, false, false);
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width, boolean rowspan, boolean isKey, boolean isHedden) {
        LinkedHashMap<String, Object> gridIdMap = new LinkedHashMap<String, Object>();
        gridIdMap.put("index", index);
        gridIdMap.put("name", index);
        gridIdMap.put("label", label);
        gridIdMap.put("width", width);
        if (rowspan) {
            gridIdMap.put("rowspan", rowspan);
        }
        if (isKey) {
            gridIdMap.put("key", isKey);
        }
        if (isHedden) {
            gridIdMap.put("hidden", isHedden);
        }
        return gridIdMap;
    }

    public String getSql(String starTime, String endTime, String status) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct d.FName_L1 as person,d.FNumber,e.FName_L1 as positionName,c.CFSuperiorName,c.CFHourlyWage ,a.CFTotalWorkHours,a.CFTotalAmount FROM T_HR_SBatchSubmitShemeBill a  right join T_HR_SchemeBillEntry c on a.fid=c.FBillID left join t_bd_person d on c.FPersonID=d.fid left join T_ORG_Position e on c.FPositionID= e.fid where 1 =1  and a.fsubmitschemeid in(SELECT fid FROM T_HR_SCalSubmitScheme where fnumber in ('eply_GS','eply_LZGS'))\r\n");
        String[] statusArry = new String[]{};
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{status})) {
            statusArry = status.split(",");
            sql.append(" and  a.FBillState in (");
            String[] stringArray = statusArry;
            int n = statusArry.length;
            int n2 = 0;
            while (n2 < n) {
                String statu = stringArray[n2];
                sql.append("'");
                sql.append(statu);
                sql.append("'");
                sql.append(",");
                ++n2;
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{starTime}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{endTime})) {
                sql.append(" and  c.FEffectDate >=");
                sql.append("'");
                sql.append(starTime);
                sql.append("' and  c.FEffectDate<= '");
                sql.append(endTime);
                sql.append("'");
            }
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{starTime}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{endTime})) {
            sql.append(" and  c.FEffectDate >=");
            sql.append("'");
            sql.append(starTime);
            sql.append("' and  c.FEffectDate<= '");
            sql.append(endTime);
            sql.append("'");
        }
        return sql.toString();
    }

    public String toExcelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException {
        String fastFilterItems = request.getParameter("fastFilterItems");
        JSONObject tofastFilterItems = new JSONObject(fastFilterItems);
        JSONObject periodEmploymentJson = tofastFilterItems.getJSONObject("periodEmployment");
        String pervalues = periodEmploymentJson.getString("values");
        String startDate = null;
        String endDate = null;
        if (pervalues != null && !pervalues.equals("")) {
            JSONObject periodEmploymentValues = periodEmploymentJson.getJSONObject("values");
            startDate = periodEmploymentValues.getString("startDate");
            endDate = periodEmploymentValues.getString("endDate");
        }
        JSONObject statusJson = tofastFilterItems.getJSONObject("status");
        String status = statusJson.getString("values");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getSql(startDate, endDate, status));
        LinkedHashMap<String, String> selectFieldsTypeMap = new LinkedHashMap<String, String>();
        String stringType = "String_@";
        selectFieldsTypeMap.put("FNumber", stringType);
        selectFieldsTypeMap.put("person", stringType);
        selectFieldsTypeMap.put("positionName", stringType);
        selectFieldsTypeMap.put("CFSuperiorName", stringType);
        selectFieldsTypeMap.put("CFHourlyWage", stringType);
        selectFieldsTypeMap.put("CFTotalWorkHours", stringType);
        selectFieldsTypeMap.put("CFTotalAmount", stringType);
        ArrayList<String> list = this.getcolNamesAction();
        ArrayList<String> fieldlist = this.getcolNamesAction();
        fieldlist.add("CFHourlyWage");
        fieldlist.add("CFTotalWorkHours");
        fieldlist.add("CFTotalAmount");
        DeclarationListHandler.exportData(response, rs, "StaffTimekeepingList.xlsx", selectFieldsTypeMap, list, fieldlist);
        return null;
    }

    public static void exportData(HttpServletResponse response, Object resource, String fileName, LinkedHashMap<String, String> selectFieldsTypeMap, List<String> list, List<String> fiedlist) throws SQLException {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet("Sheet1");
        XSSFDataFormat format = workBook.createDataFormat();
        if (resource != null && resource instanceof IRowSet) {
            IRowSet rs = (IRowSet)resource;
            int numColumns = selectFieldsTypeMap.entrySet().size();
            int i = 0;
            XSSFRow titleRow = sheet.createRow(i);
            List keyList = selectFieldsTypeMap.keySet().stream().collect(Collectors.toList());
            XSSFFont font = workBook.createFont();
            font.setFontName("\u5b8b\u4f53");
            font.setFontHeightInPoints((short)11);
            font.setColor(IndexedColors.BLACK.getIndex());
            font.setBold(true);
            XSSFCellStyle cellStyle = workBook.createCellStyle();
            cellStyle.setFont((Font)font);
            if (i == 0) {
                int j = 0;
                while (j < numColumns) {
                    XSSFCell cell = titleRow.createCell(j);
                    cell.setCellValue(list.get(j));
                    cell.setCellValue(list.get(j));
                    sheet.setColumnWidth(j, 6000);
                    titleRow.getCell(j).setCellStyle((CellStyle)cellStyle);
                    ++j;
                }
            }
            ++i;
            while (rs.next()) {
                try {
                    XSSFRow dateRow = sheet.createRow(i);
                    int j = 0;
                    while (j < numColumns) {
                        XSSFCell cell = dateRow.createCell(j);
                        String column = (String)keyList.get(j);
                        String fieldTypeAndcellStyleType = selectFieldsTypeMap.get(column);
                        int indexOf = fieldTypeAndcellStyleType.indexOf("_");
                        String fieldType = fieldTypeAndcellStyleType.substring(0, indexOf);
                        String cellStyleType = fieldTypeAndcellStyleType.substring(indexOf + 1, fieldTypeAndcellStyleType.length());
                        if (fiedlist.contains(column) && StringUtils.isNotBlank((CharSequence)rs.getString(column))) {
                            String bigcolumn = rs.getBigDecimal(column).setScale(2, 4).toString();
                            cell.setCellValue(bigcolumn);
                        } else {
                            cell.setCellValue(rs.getString(column));
                        }
                        ++j;
                    }
                    ++i;
                }
                catch (Exception e) {
                    logger1.info((Object)("Excel file was created Error!" + e.getMessage()));
                }
            }
            try {
                DeclarationListHandler.setResponseHeader(response, fileName);
                ServletOutputStream os = response.getOutputStream();
                workBook.write((OutputStream)os);
                workBook.close();
                os.flush();
                os.close();
                logger1.info((Object)"Excel file was created successfully!");
            }
            catch (IOException e) {
                logger1.info((Object)("Error while writing to file " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public static void setResponseHeader(HttpServletResponse response, String fileName) {
        try {
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

