/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.compensation.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class AdvancedZipUtils {
    public static void createZipWithCompressionLevel(byte[] fileData, String fileName, String zipFilePath, int compressionLevel) {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            zos.setLevel(compressionLevel);
            zos.setComment("Created by Java Zip Utils");
            ZipEntry entry = new ZipEntry(fileName);
            zos.putNextEntry(entry);
            zos.write(fileData);
            zos.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createZipWithDirectory(byte[] fileData, String filePathInZip, String zipFilePath) {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ZipEntry entry = new ZipEntry(filePathInZip);
            zos.putNextEntry(entry);
            zos.write(fileData);
            zos.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createZipFromMultipleFiles(Map<String, byte[]> files, String zipFilePath) {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (Map.Entry<String, byte[]> file : files.entrySet()) {
                ZipEntry entry = new ZipEntry(file.getKey());
                zos.putNextEntry(entry);
                zos.write(file.getValue());
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

