/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.erp.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.eas.custom.erp.util.HttpsReqUtil;
import com.kingdee.eas.custom.erp.util.SynPublicUtils;
import com.kingdee.eas.custom.erp.util.SynSalaryFromErpUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynAdminOrgToERPUtils {
    private static Logger log = LoggerFactory.getLogger(SynSalaryFromErpUtils.class);
    private static String ierp = "https://sites.gtiit.edu.cn/kderpdev/ierp";

    public static String getGt15AdminOrgAddUrl() {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/kapi/v2/gt15/base/bos_adminorg/gt15_adminorg_add").toString();
    }

    public static String getGt15AdminOrgBetaUrl() {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/kapi/v2/gt15/base/bos_adminorg/gt15_adminorg_beta").toString();
    }

    private static String getAdminOrgDetailEntry(Context ctx, String startDateStr, String endDateStr) throws BOSException, SQLException {
        String lastDateZeroTimeStr = "";
        String noeTimeStr = "";
        if (StringUtils.isEmpty((CharSequence)startDateStr) || StringUtils.isEmpty((CharSequence)endDateStr)) {
            lastDateZeroTimeStr = SynPublicUtils.getLastUpdateSynTableTimeStrByEvenName(ctx, "synAdminOrgToErp");
            if (StringUtils.isEmpty((CharSequence)lastDateZeroTimeStr)) {
                lastDateZeroTimeStr = SynPublicUtils.getLastDateZeroTime();
            }
            SynPublicUtils.updateSynTimeTable(ctx, "synAdminOrgToErp");
            noeTimeStr = SynPublicUtils.getNowTimeStr();
        } else {
            lastDateZeroTimeStr = startDateStr;
            noeTimeStr = endDateStr;
        }
        String sql = "select admin.fnumber as number,admin.fname_l1 as name_l1,admin.fname_l2 as name_l2,admin.fname_l3 as name_l3,admin.fsimplename as gt15_shortname,admin.fname_l2 as gt15_chinesename ,layerType.fnumber as orgpattern_number,layerType.fname_l1 as orgpattern_name ,admin.fdescription_l1 as fcomment,admin2.fnumber as viewparent_number from t_org_admin admin  left join T_Org_LayerType   layerType on layerType.fid = admin.flayertypeid  left join t_org_admin admin2 on admin2.fid = admin.fparentid where admin.fisousealup = 0   and ( (admin.flastupdatetime >  {ts '" + lastDateZeroTimeStr + "'} and  admin.flastupdatetime <=  {ts '" + noeTimeStr + "'} ) " + "  or (layerType.flastupdatetime >  {ts '" + lastDateZeroTimeStr + "'} and  layerType.flastupdatetime <=  {ts '" + noeTimeStr + "'} ) " + "  or (admin2.flastupdatetime >  {ts '" + lastDateZeroTimeStr + "'} and  admin2.flastupdatetime <=  {ts '" + noeTimeStr + "'} )) ";
        log.info("getAdminOrgDetailEntry.sql:" + sql);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        JSONArray datas = new JSONArray();
        String paramJOStr = "";
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                String number = executeQuery.getString("number");
                String name_l1 = executeQuery.getString("name_l1");
                String name_l2 = executeQuery.getString("name_l2");
                String name_l3 = executeQuery.getString("name_l3");
                String gt15_shortname = executeQuery.getString("gt15_shortname");
                String gt15_chinesename = executeQuery.getString("gt15_chinesename");
                String orgpattern_number = executeQuery.getString("orgpattern_number");
                String orgpattern_name = executeQuery.getString("orgpattern_name");
                String fcomment = executeQuery.getString("fcomment");
                String viewparent_number = executeQuery.getString("viewparent_number");
                JSONArray structures = new JSONArray();
                JSONObject structure = new JSONObject();
                structure.put("view_number", (Object)"01");
                if (StringUtils.isEmpty((CharSequence)viewparent_number)) continue;
                structure.put("viewparent_number", (Object)viewparent_number);
                structures.add((Object)structure);
                JSONObject data = new JSONObject();
                data.put("number", (Object)number);
                JSONObject name = new JSONObject();
                name.put("en_US", (Object)name_l1);
                name.put("zh_CN", (Object)name_l2);
                name.put("zh_TW", (Object)name_l3);
                data.put("name", (Object)name);
                data.put("gt15_shortname", (Object)gt15_shortname);
                data.put("gt15_chinesename", (Object)gt15_chinesename);
                data.put("orgpattern_name", (Object)orgpattern_name);
                if ("\u96c6\u56e2".equals(orgpattern_number)) {
                    orgpattern_number = "Group";
                } else if ("\u516c\u53f8".equals(orgpattern_number)) {
                    orgpattern_number = "Company";
                } else if ("\u90e8\u95e8".equals(orgpattern_number)) {
                    orgpattern_number = "Dept";
                }
                data.put("orgpattern_number", (Object)orgpattern_number);
                data.put("fcomment", (Object)fcomment);
                data.put("structure", (Object)structures);
                datas.add((Object)data);
            }
            JSONObject paramJO = new JSONObject();
            paramJO.put("data", (Object)datas);
            paramJOStr = paramJO.toString();
        }
        return paramJOStr;
    }

    public static String gt15_adminorg_add(Context ctx, String accessToken, String startDate, String endDate) throws Exception {
        String gt15AdminOrgAddUrl = SynAdminOrgToERPUtils.getGt15AdminOrgAddUrl();
        log.info("SynAdminOrgToERPUtils.gt15_adminorg_add.gt15AdminOrgAddUrl:" + gt15AdminOrgAddUrl);
        String paramJOStr = SynAdminOrgToERPUtils.getAdminOrgDetailEntry(ctx, startDate, endDate);
        log.info("SynAdminOrgToERPUtils.gt15_adminorg_add.paramJOStr:" + paramJOStr);
        String responseMsg = HttpsReqUtil.postByHttps(gt15AdminOrgAddUrl, paramJOStr, accessToken);
        return responseMsg;
    }

    public static String synAdminorgToErp(Context ctx, String startDate, String endDate) throws Exception {
        String appToken = SynSalaryFromErpUtils.getAppToken(ctx);
        log.info("\u83b7\u53d6synAdminorgToErp.appToken\uff1a" + appToken);
        String accessToken = SynSalaryFromErpUtils.getAccessToken(appToken);
        log.info("\u83b7\u53d6synAdminorgToErp.accessToken\u72b6\u6001\u4e3a\uff1a" + accessToken);
        String responseMsg = SynAdminOrgToERPUtils.gt15_adminorg_add(ctx, accessToken, startDate, endDate);
        log.info("synAdminorgToErp.responseMsg\uff1a" + accessToken);
        return null;
    }

    public static List<String> getAdminOrgBetaDetailEntry(Context ctx, String startDateStr, String endDateStr) throws BOSException, SQLException {
        String lastDateZeroTimeStr = "";
        String noeTimeStr = "";
        if (StringUtils.isEmpty((CharSequence)startDateStr) || StringUtils.isEmpty((CharSequence)endDateStr)) {
            lastDateZeroTimeStr = SynPublicUtils.getLastUpdateSynTableTimeStrByEvenName(ctx, "synAdminOrgBetaToErp");
            if (StringUtils.isEmpty((CharSequence)lastDateZeroTimeStr)) {
                lastDateZeroTimeStr = SynPublicUtils.getLastDateZeroTime();
            }
            SynPublicUtils.updateSynTimeTable(ctx, "synAdminOrgBetaToErp");
            noeTimeStr = SynPublicUtils.getNowTimeStr();
        } else {
            lastDateZeroTimeStr = startDateStr;
            noeTimeStr = endDateStr;
        }
        String sql = " select fnumber as number from  t_org_admin where fisousealup = 1  and (flastupdatetime > {ts '" + lastDateZeroTimeStr + "'} and  flastupdatetime <=  {ts '" + noeTimeStr + "'})";
        log.info("getAdminOrgBetaDetailEntry.sql" + sql);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> numbers = new ArrayList<String>();
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                String number = executeQuery.getString("number");
                numbers.add(number);
            }
        }
        return numbers;
    }

    public static String getParamJOStrByNumber(String number) {
        JSONObject data = new JSONObject();
        data.put("number", (Object)number);
        JSONObject paramJO = new JSONObject();
        paramJO.put("data", (Object)data);
        String paramJOStr = paramJO.toString();
        return paramJOStr;
    }

    public static void synGt15_adminorg_beta(Context ctx, String accessToken, String startDate, String endDate) throws Exception {
        String gt15AdminOrgBetaUrl = SynAdminOrgToERPUtils.getGt15AdminOrgBetaUrl();
        log.info("SynAdminOrgToERPUtils.synGt15_adminorg_beta.gt15AdminOrgBetaUrl:" + gt15AdminOrgBetaUrl);
        List<String> numbers = SynAdminOrgToERPUtils.getAdminOrgBetaDetailEntry(ctx, startDate, endDate);
        log.info("SynAdminOrgToERPUtils.gt15_adminorg_add.numbers:" + numbers.size());
        for (String number : numbers) {
            String paramJOStr = SynAdminOrgToERPUtils.getParamJOStrByNumber(number);
            String string = HttpsReqUtil.postByHttps(gt15AdminOrgBetaUrl, paramJOStr, accessToken);
        }
    }

    public static String syndminorgBetaToErp(Context ctx, String startDate, String endDate) throws Exception {
        String appToken = SynSalaryFromErpUtils.getAppToken(ctx);
        log.info("\u83b7\u53d6syndminorgBetaToErp.appToken\uff1a" + appToken);
        String accessToken = SynSalaryFromErpUtils.getAccessToken(appToken);
        log.info("\u83b7\u53d6syndminorgBetaToErp.accessToken\u4e3a\uff1a" + accessToken);
        SynAdminOrgToERPUtils.synGt15_adminorg_beta(ctx, accessToken, startDate, endDate);
        log.info("syndminorgBetaToErp.responseMsg\uff1a" + accessToken);
        return "";
    }
}

